/*
 * Decompiled with CFR 0.152.
 */
package net.blackhacker.crypto.algorithm;

import java.lang.reflect.InvocationTargetException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import net.blackhacker.crypto.CryptoException;
import net.blackhacker.crypto.Utils;
import net.blackhacker.crypto.Validator;

public enum SymmetricAlgorithm {
    AES(128, SecretKeySpec.class, IvParameterSpec.class),
    AES192(192, SecretKeySpec.class, IvParameterSpec.class, "AES"),
    AES256(256, SecretKeySpec.class, IvParameterSpec.class, "AES"),
    DES(DESKeySpec.class, IvParameterSpec.class),
    DESede(64, DESedeKeySpec.class, IvParameterSpec.class, "TripleDES");

    private final String transformationName;
    private final int blockSize;
    private final Class<? extends KeySpec> keySpecClass;
    private final Class<? extends AlgorithmParameterSpec> algorParamSpecClass;

    private SymmetricAlgorithm(Class<? extends KeySpec> keySpecClass, Class<? extends AlgorithmParameterSpec> algorParamSpecClass) {
        this(64, keySpecClass, algorParamSpecClass, null);
    }

    private SymmetricAlgorithm(int s, Class<? extends KeySpec> keySpecClass, Class<? extends AlgorithmParameterSpec> algorParamSpecClass) {
        this(s, keySpecClass, algorParamSpecClass, null);
    }

    private SymmetricAlgorithm(int s, Class<? extends KeySpec> keySpecClass, Class<? extends AlgorithmParameterSpec> algorParamSpecClass, String transformationName) {
        this.blockSize = s;
        this.keySpecClass = keySpecClass;
        this.algorParamSpecClass = algorParamSpecClass;
        this.transformationName = transformationName;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public KeySpec makeKeySpec(Object ... parameters) throws CryptoException {
        Validator.isTrue(parameters.length > 0, "parameters are empty");
        Class<?>[] classes = Utils.getClasses(parameters);
        try {
            try {
                return (KeySpec)PBEKeySpec.class.getConstructor(classes).newInstance(parameters);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    return this.keySpecClass.getConstructor(classes).newInstance(parameters);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    try {
                        return this.keySpecClass.getConstructor(parameters[0].getClass(), String.class).newInstance(parameters[0], this.name());
                    }
                    catch (NoSuchMethodException noSuchMethodException3) {
                        throw new CryptoException("Unsupported parameters");
                    }
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException ex) {
            throw new CryptoException(String.format("Couldn't create key spec :%s : %s", this.name(), ex.getLocalizedMessage()), ex);
        }
    }

    public AlgorithmParameterSpec makeParameterSpec(Object ... parameters) throws CryptoException {
        Validator.isTrue(parameters.length > 0, "");
        try {
            return this.algorParamSpecClass.getConstructor(Utils.getClasses(parameters)).newInstance(parameters);
        }
        catch (NoSuchMethodException ex) {
            throw new CryptoException("Unsupported parameters");
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException ex) {
            throw new CryptoException("Couldn't make parameter spec", ex);
        }
    }

    public Class<? extends KeySpec> getKeySpecClass() {
        return this.keySpecClass;
    }

    public Class<? extends AlgorithmParameterSpec> getAlgorParamSpecClass() {
        return this.algorParamSpecClass;
    }

    public final String getTransformationName() {
        return this.transformationName == null ? this.name() : this.transformationName;
    }
}

