/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.bull.javamelody.Counter;

public class LoggingHandler
extends Handler {
    private static final Level MINIMUM_LEVEL = Level.WARNING;
    private static final Counter LOG_COUNTER = new Counter("log", "log.png");
    private static final LoggingHandler SINGLETON;

    static LoggingHandler getSingleton() {
        return SINGLETON;
    }

    static Counter getLogCounter() {
        return LOG_COUNTER;
    }

    static void addErrorLogToCounter(String message, Throwable throwable) {
        if (throwable == null) {
            LOG_COUNTER.addRequestForSystemError(message, -1L, -1L, null);
        } else {
            StringWriter stackTrace = new StringWriter(200);
            throwable.printStackTrace(new PrintWriter(stackTrace));
            LOG_COUNTER.addRequestForSystemError(message, -1L, -1L, stackTrace.toString());
        }
    }

    void register() {
        for (String name : Collections.list(LogManager.getLogManager().getLoggerNames())) {
            Logger.getLogger(name).addHandler(this);
        }
    }

    void deregister() {
        for (String name : Collections.list(LogManager.getLogManager().getLoggerNames())) {
            Logger.getLogger(name).removeHandler(this);
        }
    }

    public void publish(LogRecord record) {
        if (record.getLevel().intValue() < MINIMUM_LEVEL.intValue()) {
            return;
        }
        LoggingHandler.addErrorLogToCounter(record.getLevel().getName() + ": " + record.getMessage(), record.getThrown());
    }

    public void close() {
    }

    public void flush() {
    }

    static {
        LOG_COUNTER.setMaxRequestsCount(500);
        SINGLETON = new LoggingHandler();
    }
}

