/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.Anchor;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JobInformations;
import net.bull.javamelody.PdfDocumentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PdfJobInformationsReport {
    private final List<JobInformations> jobInformationsList;
    private final Document document;
    private final DateFormat fireTimeFormat = I18N.createDateAndTimeFormat();
    private final DateFormat elapsedTimeFormat = I18N.createDurationFormat();
    private final Font cellFont = PdfDocumentFactory.TABLE_CELL_FONT;
    private PdfPTable currentTable;

    PdfJobInformationsReport(List<JobInformations> jobInformationsList, Document document) {
        assert (jobInformationsList != null);
        assert (document != null);
        this.jobInformationsList = jobInformationsList;
        this.document = document;
    }

    void toPdf() throws DocumentException {
        this.writeHeader();
        PdfPCell defaultCell = this.getDefaultCell();
        boolean odd = false;
        for (JobInformations jobInformations : this.jobInformationsList) {
            if (odd) {
                defaultCell.setGrayFill(0.97f);
            } else {
                defaultCell.setGrayFill(1.0f);
            }
            odd = !odd;
            this.writeJobInformations(jobInformations);
        }
        this.document.add((Element)this.currentTable);
        this.addConfigurationReference();
    }

    private void addConfigurationReference() throws DocumentException {
        Anchor quartzAnchor = new Anchor("Configuration reference", PdfDocumentFactory.BLUE_FONT);
        quartzAnchor.setName("Quartz configuration reference");
        quartzAnchor.setReference("http://www.quartz-scheduler.org/docs/index.html");
        quartzAnchor.setFont(PdfDocumentFactory.BLUE_FONT);
        Paragraph quartzParagraph = new Paragraph();
        quartzParagraph.add((Object)quartzAnchor);
        quartzParagraph.setAlignment(2);
        this.document.add((Element)quartzParagraph);
    }

    private void writeHeader() throws DocumentException {
        List<String> headers = this.createHeaders();
        int[] relativeWidths = new int[headers.size()];
        Arrays.fill(relativeWidths, 0, headers.size(), 1);
        relativeWidths[1] = 2;
        relativeWidths[2] = 3;
        relativeWidths[3] = 3;
        this.currentTable = PdfDocumentFactory.createPdfPTable(headers, relativeWidths);
    }

    private List<String> createHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(PdfJobInformationsReport.getI18nString("JobGroup"));
        headers.add(PdfJobInformationsReport.getI18nString("JobName"));
        headers.add(PdfJobInformationsReport.getI18nString("JobDescription"));
        headers.add(PdfJobInformationsReport.getI18nString("JobClassName"));
        headers.add(PdfJobInformationsReport.getI18nString("JobPreviousFireTime"));
        headers.add(PdfJobInformationsReport.getI18nString("JobNextFireTime"));
        headers.add(PdfJobInformationsReport.getI18nString("JobElapsedTime"));
        headers.add(PdfJobInformationsReport.getI18nString("JobPaused"));
        return headers;
    }

    private void writeJobInformations(JobInformations jobInformations) {
        PdfPCell defaultCell = this.getDefaultCell();
        defaultCell.setHorizontalAlignment(0);
        this.addCell(jobInformations.getGroup());
        this.addCell(jobInformations.getName());
        if (jobInformations.getDescription() != null) {
            this.addCell(jobInformations.getDescription());
        } else {
            this.addCell("");
        }
        this.addCell(jobInformations.getJobClassName());
        defaultCell.setHorizontalAlignment(2);
        if (jobInformations.getPreviousFireTime() != null) {
            this.addCell(this.fireTimeFormat.format(jobInformations.getPreviousFireTime()));
        } else {
            this.addCell("");
        }
        if (jobInformations.getNextFireTime() != null) {
            this.addCell(this.fireTimeFormat.format(jobInformations.getNextFireTime()));
        } else {
            this.addCell("");
        }
        if (jobInformations.getElapsedTime() >= 0L) {
            this.addCell(this.elapsedTimeFormat.format(jobInformations.getElapsedTime()));
        } else {
            this.addCell("");
        }
        defaultCell.setHorizontalAlignment(1);
        if (jobInformations.isPaused()) {
            this.addCell(PdfJobInformationsReport.getI18nString("oui"));
        } else {
            this.addCell(PdfJobInformationsReport.getI18nString("non"));
        }
    }

    private static String getI18nString(String key) {
        return I18N.getString(key);
    }

    private PdfPCell getDefaultCell() {
        return this.currentTable.getDefaultCell();
    }

    private void addCell(String string) {
        this.currentTable.addCell(new Phrase(string, this.cellFont));
    }
}

