/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterRequest;
import net.bull.javamelody.CounterRequestContext;
import net.bull.javamelody.HtmlCounterReport;
import net.bull.javamelody.HtmlThreadInformationsReport;
import net.bull.javamelody.I18N;
import net.bull.javamelody.PID;
import net.bull.javamelody.Period;
import net.bull.javamelody.ThreadInformations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HtmlCounterRequestContextReport {
    private final List<CounterRequestContext> rootCurrentContexts;
    private final Map<String, HtmlCounterReport> counterReportsByCounterName;
    private final Map<Long, ThreadInformations> threadInformationsByThreadId;
    private final Writer writer;
    private final boolean childHitsDisplayed;
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();
    private final long timeOfSnapshot = System.currentTimeMillis();
    private final boolean stackTraceEnabled;
    private final HtmlThreadInformationsReport htmlThreadInformationsReport;

    HtmlCounterRequestContextReport(List<CounterRequestContext> rootCurrentContexts, Map<String, HtmlCounterReport> counterReportsByCounterName, List<ThreadInformations> threadInformationsList, boolean stackTraceEnabled, Writer writer) {
        assert (rootCurrentContexts != null);
        assert (threadInformationsList != null);
        assert (writer != null);
        this.rootCurrentContexts = rootCurrentContexts;
        this.counterReportsByCounterName = counterReportsByCounterName == null ? new HashMap<String, HtmlCounterReport>() : counterReportsByCounterName;
        this.threadInformationsByThreadId = new HashMap<Long, ThreadInformations>(threadInformationsList.size());
        for (ThreadInformations threadInformations : threadInformationsList) {
            this.threadInformationsByThreadId.put(threadInformations.getId(), threadInformations);
        }
        this.writer = writer;
        boolean oneRootHasChild = false;
        for (CounterRequestContext rootCurrentContext : rootCurrentContexts) {
            if (rootCurrentContext.getParentCounter().getChildCounterName() == null) continue;
            oneRootHasChild = true;
            break;
        }
        this.childHitsDisplayed = oneRootHasChild;
        this.htmlThreadInformationsReport = new HtmlThreadInformationsReport(threadInformationsList, stackTraceEnabled, writer);
        this.stackTraceEnabled = stackTraceEnabled;
    }

    void toHtml() throws IOException {
        if (this.rootCurrentContexts.isEmpty()) {
            return;
        }
        this.writeContexts(Collections.singletonList(this.rootCurrentContexts.get(0)));
        this.writeln("<div align='right'>");
        this.writeln(I18N.getFormattedString("nb_requete_en_cours", this.integerFormat.format(this.rootCurrentContexts.size())));
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        String counterName = this.rootCurrentContexts.get(0).getParentCounter().getName();
        this.writeShowHideLink("contextDetails" + counterName + PID.getPID(), "#Details#");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("</div>");
        this.writeln("<div id='contextDetails" + counterName + PID.getPID() + "' style='display: none;'>");
        this.writeContexts(this.rootCurrentContexts);
        this.writeln("</div>");
    }

    private void writeContexts(List<CounterRequestContext> contexts) throws IOException {
        boolean displayRemoteUser = false;
        for (CounterRequestContext context : contexts) {
            if (context.getRemoteUser() == null) continue;
            displayRemoteUser = true;
            break;
        }
        this.writeln("<table class='sortable' width='100%' border='1' cellspacing='0' cellpadding='2' summary='#Requetes_en_cours#'>");
        this.write("<thead><tr><th>#Thread#</th>");
        if (displayRemoteUser) {
            this.write("<th>#Utilisateur#</th>");
        }
        this.write("<th>#Requete#</th>");
        this.write("<th class='sorttable_numeric'>#Duree_ecoulee#</th><th class='sorttable_numeric'>#Temps_moyen#</th>");
        this.write("<th class='sorttable_numeric'>#Temps_cpu#</th><th class='sorttable_numeric'>#Temps_cpu_moyen#</th>");
        if (this.childHitsDisplayed) {
            String childCounterName = contexts.get(0).getParentCounter().getChildCounterName();
            this.write("<th class='sorttable_numeric'>" + I18N.getFormattedString("hits_fils", childCounterName));
            this.write("</th><th class='sorttable_numeric'>" + I18N.getFormattedString("hits_fils_moyens", childCounterName));
            this.write("</th><th class='sorttable_numeric'>" + I18N.getFormattedString("temps_fils", childCounterName));
            this.write("</th><th class='sorttable_numeric'>" + I18N.getFormattedString("temps_fils_moyen", childCounterName) + "</th>");
        }
        if (this.stackTraceEnabled) {
            this.write("<th>#Methode_executee#</th>");
        }
        this.writeln("</tr></thead><tbody>");
        boolean odd = false;
        for (CounterRequestContext context : contexts) {
            if (odd) {
                this.write("<tr class='odd' onmouseover=\"this.className='highlight'\" onmouseout=\"this.className='odd'\">");
            } else {
                this.write("<tr onmouseover=\"this.className='highlight'\" onmouseout=\"this.className=''\">");
            }
            odd = !odd;
            this.writeContext(context, displayRemoteUser);
            this.writeln("</tr>");
        }
        this.writeln("</tbody></table>");
    }

    private void writeContext(CounterRequestContext rootContext, boolean displayRemoteUser) throws IOException {
        ThreadInformations threadInformations = this.threadInformationsByThreadId.get(rootContext.getThreadId());
        this.write("<td valign='top'>");
        String espace = "&nbsp;";
        if (threadInformations == null) {
            this.write("&nbsp;");
        } else {
            this.htmlThreadInformationsReport.writeThreadWithStackTrace(threadInformations);
        }
        if (displayRemoteUser) {
            this.write("</td> <td valign='top'>");
            if (rootContext.getRemoteUser() == null) {
                this.write("&nbsp;");
            } else {
                this.write(rootContext.getRemoteUser());
            }
        }
        ArrayList<CounterRequestContext> contexts = new ArrayList<CounterRequestContext>(3);
        contexts.add(rootContext);
        contexts.addAll(rootContext.getChildContexts());
        CounterRequestContextReportHelper counterRequestContextReportHelper = new CounterRequestContextReportHelper(contexts, this.childHitsDisplayed);
        this.write("</td> <td>");
        this.writeRequests(contexts, counterRequestContextReportHelper);
        this.write("</td> <td align='right' valign='top'>");
        this.writeDurations(contexts);
        for (int[] requestValues : counterRequestContextReportHelper.getRequestValues()) {
            this.writeRequestValues(requestValues);
        }
        if (this.stackTraceEnabled) {
            this.write("</td> <td valign='top'>");
            if (threadInformations == null) {
                this.write("&nbsp;");
            } else {
                this.htmlThreadInformationsReport.writeExecutedMethod(threadInformations);
            }
        }
        this.write("</td>");
    }

    private void writeRequests(List<CounterRequestContext> contexts, CounterRequestContextReportHelper counterRequestContextReportHelper) throws IOException {
        int margin = 0;
        for (CounterRequestContext context : contexts) {
            this.write("<div style='margin-left: ");
            this.write(Integer.toString(margin));
            this.writeln("px;'>");
            this.writeRequest(context, counterRequestContextReportHelper);
            this.write("</div>");
            margin += 10;
        }
    }

    private void writeRequest(CounterRequestContext context, CounterRequestContextReportHelper counterRequestContextReportHelper) throws IOException {
        Counter parentCounter = context.getParentCounter();
        if (parentCounter.getIconName() != null) {
            this.write("<img src='?resource=");
            this.write(parentCounter.getIconName());
            this.write("' alt='");
            this.write(parentCounter.getName());
            this.write("' width='16' height='16' />&nbsp;");
        }
        HtmlCounterReport counterReport = this.getCounterReport(parentCounter, Period.TOUT);
        CounterRequest counterRequest = counterRequestContextReportHelper.getCounterRequest(context);
        counterReport.writeRequestGraph(counterRequest.getId(), context.getCompleteRequestName());
    }

    private HtmlCounterReport getCounterReport(Counter parentCounter, Period period) {
        HtmlCounterReport counterReport = this.counterReportsByCounterName.get(parentCounter.getName());
        if (counterReport == null) {
            counterReport = new HtmlCounterReport(parentCounter, period.getRange(), this.writer);
            this.counterReportsByCounterName.put(parentCounter.getName(), counterReport);
        }
        return counterReport;
    }

    private void writeDurations(List<CounterRequestContext> contexts) throws IOException {
        boolean first = true;
        for (CounterRequestContext context : contexts) {
            if (!first) {
                this.writeln("<br/>");
            }
            int duration = context.getDuration(this.timeOfSnapshot);
            Counter parentCounter = context.getParentCounter();
            if (parentCounter.getIconName() != null) {
                this.write("<img src='?resource=");
                this.write(parentCounter.getIconName());
                this.write("' alt='");
                this.write(parentCounter.getName());
                this.write("' width='16' height='16' />&nbsp;");
            }
            HtmlCounterReport counterReport = this.counterReportsByCounterName.get(parentCounter.getName());
            this.write("<span class='");
            this.write(counterReport.getSlaHtmlClass(duration));
            this.write("'>");
            this.write(this.integerFormat.format(duration));
            this.write("</span>");
            first = false;
        }
    }

    private void writeRequestValues(int[] requestValues) throws IOException {
        this.write("</td> <td align='right' valign='top'>");
        boolean first = true;
        for (int value : requestValues) {
            if (!first) {
                this.writeln("<br/>");
            }
            if (value == -1) {
                this.write("&nbsp;");
            } else {
                this.write(this.integerFormat.format(value));
            }
            first = false;
        }
    }

    private void writeShowHideLink(String idToShow, String label) throws IOException {
        this.writeln("<a href=\"javascript:showHide('" + idToShow + "');\" class='noPrint'><img id='" + idToShow + "Img' src='?resource=bullets/plus.png' alt=''/> " + label + "</a>");
    }

    private void write(String html) throws IOException {
        I18N.writeTo(html, this.writer);
    }

    private void writeln(String html) throws IOException {
        I18N.writelnTo(html, this.writer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CounterRequestContextReportHelper {
        private final List<CounterRequestContext> contexts;
        private final boolean childHitsDisplayed;
        private final Map<String, CounterRequest> counterRequestsByRequestName = new HashMap<String, CounterRequest>();

        CounterRequestContextReportHelper(List<CounterRequestContext> contexts, boolean childHitsDisplayed) {
            assert (contexts != null);
            this.contexts = contexts;
            this.childHitsDisplayed = childHitsDisplayed;
        }

        List<int[]> getRequestValues() {
            ArrayList<int[]> result = new ArrayList<int[]>();
            int contextsSize = this.contexts.size();
            int[] durationMeans = new int[contextsSize];
            int[] cpuTimes = new int[contextsSize];
            int[] cpuTimesMeans = new int[contextsSize];
            int i = 0;
            for (CounterRequestContext context : this.contexts) {
                CounterRequest counterRequest = this.getCounterRequest(context);
                durationMeans[i] = counterRequest.getMean();
                cpuTimesMeans[i] = counterRequest.getCpuTimeMean();
                cpuTimes[i] = cpuTimesMeans[i] >= 0 ? context.getCpuTime() : -1;
                ++i;
            }
            result.add(durationMeans);
            result.add(cpuTimes);
            result.add(cpuTimesMeans);
            if (this.childHitsDisplayed) {
                int[] totalChildHits = new int[contextsSize];
                int[] childHitsMeans = new int[contextsSize];
                int[] totalChildDurationsSum = new int[contextsSize];
                int[] childDurationsMeans = new int[contextsSize];
                i = 0;
                for (CounterRequestContext context : this.contexts) {
                    totalChildHits[i] = CounterRequestContextReportHelper.getValueOrIgnoreIfNoChildHitForContext(context, context.getTotalChildHits());
                    CounterRequest counterRequest = this.getCounterRequest(context);
                    childHitsMeans[i] = CounterRequestContextReportHelper.getValueOrIgnoreIfNoChildHitForContext(context, counterRequest.getChildHitsMean());
                    totalChildDurationsSum[i] = CounterRequestContextReportHelper.getValueOrIgnoreIfNoChildHitForContext(context, context.getTotalChildDurationsSum());
                    childDurationsMeans[i] = CounterRequestContextReportHelper.getValueOrIgnoreIfNoChildHitForContext(context, counterRequest.getChildDurationsMean());
                    ++i;
                }
                result.add(totalChildHits);
                result.add(childHitsMeans);
                result.add(totalChildDurationsSum);
                result.add(childDurationsMeans);
            }
            return result;
        }

        private static int getValueOrIgnoreIfNoChildHitForContext(CounterRequestContext context, int value) {
            if (context.getParentCounter().getChildCounterName() == null) {
                return -1;
            }
            return value;
        }

        CounterRequest getCounterRequest(CounterRequestContext context) {
            String requestName = context.getRequestName();
            CounterRequest counterRequest = this.counterRequestsByRequestName.get(requestName);
            if (counterRequest == null) {
                counterRequest = context.getParentCounter().getCounterRequest(context);
                this.counterRequestsByRequestName.put(requestName, counterRequest);
            }
            return counterRequest;
        }
    }
}

