/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.Anchor;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPTable;
import java.text.DecimalFormat;
import java.util.List;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.MemoryInformations;
import net.bull.javamelody.PdfDocumentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PdfJavaInformationsReport {
    private final DecimalFormat decimalFormat = I18N.createPercentFormat();
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();
    private final List<JavaInformations> javaInformationsList;
    private final Document document;
    private final Font cellFont = PdfDocumentFactory.TABLE_CELL_FONT;
    private final Font boldCellFont = PdfDocumentFactory.BOLD_CELL_FONT;
    private PdfPTable currentTable;

    PdfJavaInformationsReport(List<JavaInformations> javaInformationsList, Document document) {
        assert (javaInformationsList != null);
        assert (document != null);
        this.javaInformationsList = javaInformationsList;
        this.document = document;
    }

    void toPdf() throws DocumentException {
        for (JavaInformations javaInformations : this.javaInformationsList) {
            this.currentTable = PdfJavaInformationsReport.createJavaInformationsTable();
            this.writeSummary(javaInformations);
            this.addCell("");
            this.addCell("");
            this.document.add((Element)this.currentTable);
        }
    }

    private static PdfPTable createJavaInformationsTable() throws DocumentException {
        PdfPTable table = new PdfPTable(2);
        table.setHorizontalAlignment(0);
        table.setWidthPercentage(100.0f);
        table.setWidths(new int[]{2, 8});
        table.getDefaultCell().setBorder(0);
        return table;
    }

    private void writeSummary(JavaInformations javaInformations) {
        this.addCell(PdfJavaInformationsReport.getI18nString("Host") + ':');
        this.currentTable.addCell(new Phrase(javaInformations.getHost(), this.boldCellFont));
        this.addCell(PdfJavaInformationsReport.getI18nString("memoire_utilisee") + ':');
        String divide = " / ";
        MemoryInformations memoryInformations = javaInformations.getMemoryInformations();
        this.addCell(this.integerFormat.format(memoryInformations.getUsedMemory() / 1024L / 1024L) + ' ' + PdfJavaInformationsReport.getI18nString("Mo") + " / " + this.integerFormat.format(memoryInformations.getMaxMemory() / 1024L / 1024L) + ' ' + PdfJavaInformationsReport.getI18nString("Mo"));
        this.addCell(PdfJavaInformationsReport.getI18nString("nb_sessions_http") + ':');
        this.addCell(this.integerFormat.format(javaInformations.getSessionCount()));
        this.addCell(PdfJavaInformationsReport.getI18nString("nb_threads_actifs") + "\n(" + PdfJavaInformationsReport.getI18nString("Requetes_http_en_cours") + "):");
        this.addCell(this.integerFormat.format(javaInformations.getActiveThreadCount()));
        this.addCell(PdfJavaInformationsReport.getI18nString("nb_connexions_actives") + ':');
        this.addCell(this.integerFormat.format(javaInformations.getActiveConnectionCount()));
        this.addCell(PdfJavaInformationsReport.getI18nString("nb_connexions_utilisees") + "\n(" + PdfJavaInformationsReport.getI18nString("ouvertes") + "):");
        String usedConnectionCount = javaInformations.getMaxConnectionCount() < 0 ? this.integerFormat.format(javaInformations.getUsedConnectionCount()) : this.integerFormat.format(javaInformations.getUsedConnectionCount()) + " / " + this.integerFormat.format(javaInformations.getMaxConnectionCount());
        this.addCell(usedConnectionCount);
        if (javaInformations.getSystemLoadAverage() >= 0.0) {
            this.addCell(PdfJavaInformationsReport.getI18nString("Charge_systeme") + ':');
            this.addCell(this.decimalFormat.format(javaInformations.getSystemLoadAverage()));
        }
    }

    void writeInformationsDetails() throws DocumentException {
        for (JavaInformations javaInformations : this.javaInformationsList) {
            this.currentTable = PdfJavaInformationsReport.createJavaInformationsTable();
            this.writeSummary(javaInformations);
            this.writeDetails(javaInformations);
            this.document.add((Element)this.currentTable);
        }
    }

    private void writeDetails(JavaInformations javaInformations) {
        this.addCell(PdfJavaInformationsReport.getI18nString("OS") + ':');
        this.addCell(javaInformations.getOS() + " (" + javaInformations.getAvailableProcessors() + ' ' + PdfJavaInformationsReport.getI18nString("coeurs") + ')');
        this.addCell(PdfJavaInformationsReport.getI18nString("Java") + ':');
        this.addCell(javaInformations.getJavaVersion());
        this.addCell(PdfJavaInformationsReport.getI18nString("JVM") + ':');
        this.addCell(javaInformations.getJvmVersion());
        this.addCell(PdfJavaInformationsReport.getI18nString("PID") + ':');
        this.addCell(javaInformations.getPID());
        if (javaInformations.getUnixOpenFileDescriptorCount() >= 0L) {
            this.addCell(PdfJavaInformationsReport.getI18nString("nb_fichiers") + ':');
            this.addCell(this.integerFormat.format(javaInformations.getUnixOpenFileDescriptorCount()) + " / " + this.integerFormat.format(javaInformations.getUnixMaxFileDescriptorCount()));
        }
        if (javaInformations.getServerInfo() != null) {
            this.addCell(PdfJavaInformationsReport.getI18nString("Serveur") + ':');
            this.addCell(javaInformations.getServerInfo());
            this.addCell(PdfJavaInformationsReport.getI18nString("Contexte_webapp") + ':');
            this.addCell(javaInformations.getContextPath());
        }
        this.addCell(PdfJavaInformationsReport.getI18nString("Demarrage") + ':');
        this.addCell(I18N.createDateAndTimeFormat().format(javaInformations.getStartDate()));
        this.addCell(PdfJavaInformationsReport.getI18nString("Arguments_JVM") + ':');
        this.addCell(javaInformations.getJvmArguments());
        this.addCell(PdfJavaInformationsReport.getI18nString("Gestion_memoire") + ':');
        this.writeMemoryInformations(javaInformations.getMemoryInformations());
        if (javaInformations.getFreeDiskSpaceInTemp() >= 0L) {
            this.addCell(PdfJavaInformationsReport.getI18nString("Free_disk_space") + ':');
            this.addCell(this.integerFormat.format(javaInformations.getFreeDiskSpaceInTemp() / 1024L / 1024L) + ' ' + PdfJavaInformationsReport.getI18nString("Mo"));
        }
        this.addCell(PdfJavaInformationsReport.getI18nString("Base_de_donnees") + ':');
        this.addCell(javaInformations.getDataBaseVersion());
        if (javaInformations.getDataSourceDetails() != null) {
            this.addCell(PdfJavaInformationsReport.getI18nString("DataSource_jdbc") + ':');
            this.addCell(javaInformations.getDataSourceDetails());
            this.addCell("");
            Anchor anchor = new Anchor("DataSource reference", PdfDocumentFactory.BLUE_FONT);
            anchor.setName("DataSource reference");
            anchor.setReference("http://commons.apache.org/dbcp/apidocs/org/apache/commons/dbcp/BasicDataSource.html");
            this.currentTable.addCell((Phrase)anchor);
        }
        if (javaInformations.isDependenciesEnabled()) {
            this.addCell(PdfJavaInformationsReport.getI18nString("Dependencies") + ':');
            this.addCell(I18N.getFormattedString("nb_dependencies", javaInformations.getDependenciesList().size()) + " ;\n" + javaInformations.getDependencies());
        }
        this.addCell("");
        this.addCell("");
    }

    private void writeMemoryInformations(MemoryInformations memoryInformations) {
        this.addCell(memoryInformations.getMemoryDetails().replace(" Mo", ' ' + PdfJavaInformationsReport.getI18nString("Mo")));
        long usedPermGen = memoryInformations.getUsedPermGen();
        long maxPermGen = memoryInformations.getMaxPermGen();
        this.addCell(PdfJavaInformationsReport.getI18nString("Memoire_Perm_Gen") + ':');
        if (maxPermGen >= 0L) {
            this.addCell(this.integerFormat.format(usedPermGen / 1024L / 1024L) + ' ' + PdfJavaInformationsReport.getI18nString("Mo") + " / " + this.integerFormat.format(maxPermGen / 1024L / 1024L) + ' ' + PdfJavaInformationsReport.getI18nString("Mo"));
        } else {
            this.addCell(this.integerFormat.format(usedPermGen / 1024L / 1024L) + ' ' + PdfJavaInformationsReport.getI18nString("Mo"));
        }
    }

    private static String getI18nString(String key) {
        return I18N.getString(key);
    }

    private void addCell(String string) {
        this.currentTable.addCell(new Phrase(string, this.cellFont));
    }
}

