/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bull.javamelody.HtmlThreadInformationsReport;
import net.bull.javamelody.I18N;
import net.bull.javamelody.PdfDocumentFactory;
import net.bull.javamelody.ThreadInformations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PdfThreadInformationsReport {
    private final List<ThreadInformations> threadInformationsList;
    private final Document document;
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();
    private final boolean stackTraceEnabled;
    private final boolean cpuTimeEnabled;
    private final Font cellFont = PdfDocumentFactory.TABLE_CELL_FONT;
    private PdfPTable currentTable;
    private final PdfDocumentFactory pdfDocumentFactory;

    PdfThreadInformationsReport(List<ThreadInformations> threadInformationsList, boolean stackTraceEnabled, PdfDocumentFactory pdfDocumentFactory, Document document) {
        assert (threadInformationsList != null);
        assert (pdfDocumentFactory != null);
        assert (document != null);
        this.threadInformationsList = threadInformationsList;
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.document = document;
        this.stackTraceEnabled = stackTraceEnabled;
        this.cpuTimeEnabled = !threadInformationsList.isEmpty() && threadInformationsList.get(0).getCpuTimeMillis() != -1L;
    }

    void toPdf() throws DocumentException, IOException {
        this.writeHeader();
        PdfPCell defaultCell = this.getDefaultCell();
        boolean odd = false;
        for (ThreadInformations threadInformations : this.threadInformationsList) {
            if (odd) {
                defaultCell.setGrayFill(0.97f);
            } else {
                defaultCell.setGrayFill(1.0f);
            }
            odd = !odd;
            this.writeThreadInformations(threadInformations);
        }
        this.document.add((Element)this.currentTable);
        Paragraph tempsThreads = new Paragraph(I18N.getString("Temps_threads") + '\n', this.cellFont);
        tempsThreads.setAlignment(2);
        this.document.add((Element)tempsThreads);
    }

    void writeDeadlocks() throws DocumentException {
        ArrayList<ThreadInformations> deadlockedThreads = new ArrayList<ThreadInformations>();
        for (ThreadInformations thread : this.threadInformationsList) {
            if (!thread.isDeadlocked()) continue;
            deadlockedThreads.add(thread);
        }
        if (!deadlockedThreads.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append('\n');
            sb.append(I18N.getString("Threads_deadlocks"));
            String separator = " ";
            for (ThreadInformations thread : deadlockedThreads) {
                sb.append(separator);
                sb.append(thread.getName());
                separator = ", ";
            }
            sb.append('\n');
            this.document.add((Element)new Phrase(sb.toString(), PdfDocumentFactory.SEVERE_CELL_FONT));
        }
    }

    private void writeHeader() throws DocumentException {
        List<String> headers = this.createHeaders();
        int[] relativeWidths = new int[headers.size()];
        Arrays.fill(relativeWidths, 0, headers.size(), 1);
        relativeWidths[0] = 3;
        relativeWidths[3] = 2;
        if (this.stackTraceEnabled) {
            relativeWidths[4] = 6;
        }
        this.currentTable = PdfDocumentFactory.createPdfPTable(headers, relativeWidths);
    }

    private List<String> createHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(PdfThreadInformationsReport.getI18nString("Thread"));
        headers.add(PdfThreadInformationsReport.getI18nString("Demon"));
        headers.add(PdfThreadInformationsReport.getI18nString("Priorite"));
        headers.add(PdfThreadInformationsReport.getI18nString("Etat"));
        if (this.stackTraceEnabled) {
            headers.add(PdfThreadInformationsReport.getI18nString("Methode_executee"));
        }
        if (this.cpuTimeEnabled) {
            headers.add(PdfThreadInformationsReport.getI18nString("Temps_cpu"));
            headers.add(PdfThreadInformationsReport.getI18nString("Temps_user"));
        }
        return headers;
    }

    private void writeThreadInformations(ThreadInformations threadInformations) throws DocumentException, IOException {
        PdfPCell defaultCell = this.getDefaultCell();
        defaultCell.setHorizontalAlignment(0);
        this.addCell(threadInformations.getName());
        defaultCell.setHorizontalAlignment(1);
        if (threadInformations.isDaemon()) {
            this.addCell(PdfThreadInformationsReport.getI18nString("oui"));
        } else {
            this.addCell(PdfThreadInformationsReport.getI18nString("non"));
        }
        defaultCell.setHorizontalAlignment(2);
        this.addCell(this.integerFormat.format(threadInformations.getPriority()));
        defaultCell.setHorizontalAlignment(0);
        PdfPCell cell = new PdfPCell();
        Paragraph paragraph = new Paragraph(this.getDefaultCell().getLeading() + this.cellFont.getSize());
        paragraph.add((Object)new Chunk(this.getImage("bullets/" + HtmlThreadInformationsReport.getStateIcon(threadInformations)), 0.0f, -1.0f));
        paragraph.add((Object)new Phrase(String.valueOf((Object)threadInformations.getState()), this.cellFont));
        cell.addElement((Element)paragraph);
        this.currentTable.addCell(cell);
        if (this.stackTraceEnabled) {
            this.addCell(threadInformations.getExecutedMethod());
        }
        if (this.cpuTimeEnabled) {
            defaultCell.setHorizontalAlignment(2);
            this.addCell(this.integerFormat.format(threadInformations.getCpuTimeMillis()));
            this.addCell(this.integerFormat.format(threadInformations.getUserTimeMillis()));
        }
    }

    private Image getImage(String resourceFileName) throws DocumentException, IOException {
        return this.pdfDocumentFactory.getSmallImage(resourceFileName);
    }

    private static String getI18nString(String key) {
        return I18N.getString(key);
    }

    private PdfPCell getDefaultCell() {
        return this.currentTable.getDefaultCell();
    }

    private void addCell(String string) {
        this.currentTable.addCell(new Phrase(string, this.cellFont));
    }
}

