/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterRequest;
import net.bull.javamelody.HtmlJavaInformationsReport;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JobInformations;
import net.bull.javamelody.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HtmlJobInformationsReport {
    private static final long ONE_DAY_MILLIS = 86400000L;
    private final List<JobInformations> jobInformationsList;
    private final Map<String, CounterRequest> counterRequestsByRequestName;
    private final Writer writer;
    private final DateFormat fireTimeFormat = I18N.createDateAndTimeFormat();
    private final DateFormat durationFormat = I18N.createDurationFormat();
    private final boolean systemActionsEnabled = Parameters.isSystemActionsEnabled();

    HtmlJobInformationsReport(List<JobInformations> jobInformationsList, Counter rangeJobCounter, Writer writer) {
        assert (jobInformationsList != null);
        assert (rangeJobCounter != null);
        assert (writer != null);
        this.jobInformationsList = jobInformationsList;
        this.writer = writer;
        List<CounterRequest> counterRequests = rangeJobCounter.getRequests();
        this.counterRequestsByRequestName = new HashMap<String, CounterRequest>(counterRequests.size());
        for (CounterRequest counterRequest : counterRequests) {
            this.counterRequestsByRequestName.put(counterRequest.getName(), counterRequest);
        }
    }

    void toHtml() throws IOException {
        this.writeln("<table class='sortable' width='100%' border='1' cellspacing='0' cellpadding='2' summary='#Jobs#'>");
        this.write("<thead><tr><th>#JobGroup#</th>");
        this.write("<th>#JobName#</th>");
        this.write("<th>#JobClassName#</th>");
        this.write("<th>#JobLastException#</th>");
        this.write("<th class='sorttable_date'>#JobMeanTime#</th>");
        this.write("<th class='sorttable_date'>#JobElapsedTime#</th>");
        this.write("<th class='sorttable_date'>#JobPreviousFireTime#</th>");
        this.write("<th class='sorttable_date'>#JobNextFireTime#</th>");
        this.write("<th>#JobPeriodOrCronExpression#</th>");
        this.write("<th>#JobPaused#</th>");
        if (this.systemActionsEnabled) {
            this.write("<th class='noPrint'>#Pause_job#</th>");
            this.write("<th class='noPrint'>#Resume_job#</th>");
        }
        this.writeln("</tr></thead><tbody>");
        boolean odd = false;
        for (JobInformations jobInformations : this.jobInformationsList) {
            if (odd) {
                this.write("<tr class='odd' onmouseover=\"this.className='highlight'\" onmouseout=\"this.className='odd'\">");
            } else {
                this.write("<tr onmouseover=\"this.className='highlight'\" onmouseout=\"this.className=''\">");
            }
            odd = !odd;
            this.writeJobInformations(jobInformations);
            this.writeln("</tr>");
        }
        this.writeln("</tbody></table>");
        this.write("<div align='right' class='noPrint'>");
        if (this.systemActionsEnabled) {
            String onClickConfirm = "' onclick=\"javascript:return confirm('";
            String endOnClickConfirm = "');\">";
            this.writeln("<a href='?action=pause_job&amp;jobId=all' onclick=\"javascript:return confirm('" + I18N.getStringForJavascript("confirm_pause_all_jobs") + "');\">");
            this.writeln("<img src='?resource=control_pause_blue.png' width='18' height='18' alt=\"#Pause_all_jobs#\" /> #Pause_all_jobs#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.writeln("<a href='?action=resume_job&amp;jobId=all' onclick=\"javascript:return confirm('" + I18N.getStringForJavascript("confirm_resume_all_jobs") + "');\">");
            this.writeln("<img src='?resource=control_play_blue.png' width='18' height='18' alt=\"#Resume_all_jobs#\" /> #Resume_all_jobs#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        }
        this.writer.write("<a href='http://www.quartz-scheduler.org/docs/index.html'");
        this.writeln("target='_blank'>Configuration reference</a>");
        this.writeln("</div>");
    }

    private void writeJobInformations(JobInformations jobInformations) throws IOException {
        this.write("<td>");
        String nextColumnAlignRight = "</td> <td align='right'>";
        this.writer.write(HtmlJobInformationsReport.htmlEncode(jobInformations.getGroup()));
        this.write("</td> <td>");
        this.writeNameWithDescription(jobInformations);
        this.write("</td> <td>");
        this.writer.write(HtmlJobInformationsReport.htmlEncode(jobInformations.getJobClassName()));
        CounterRequest counterRequest = this.getCounterRequest(jobInformations);
        if (counterRequest != null) {
            this.write("</td> <td align='center'>");
            this.writeStackTrace(counterRequest.getStackTrace());
            this.write("</td> <td align='right'>");
            this.write(this.durationFormat.format(new Date(counterRequest.getMean())));
        } else {
            this.write("</td><td>&nbsp;</td><td>&nbsp;");
        }
        this.writeJobTimes(jobInformations, counterRequest);
        this.write("</td> <td align='center'>");
        if (jobInformations.isPaused()) {
            this.write("#oui#");
        } else {
            this.write("#non#");
        }
        if (this.systemActionsEnabled) {
            this.writePauseJobAndResumeJobLinks(jobInformations);
        }
        this.write("</td>");
    }

    private void writeNameWithDescription(JobInformations jobInformations) throws IOException {
        if (jobInformations.getDescription() == null) {
            this.writer.write(HtmlJobInformationsReport.htmlEncode(jobInformations.getName()));
        } else {
            this.write("<a class='tooltip'><em>");
            this.writer.write(HtmlJobInformationsReport.htmlEncode(jobInformations.getDescription()));
            this.writeln("</em>");
            this.writer.write(HtmlJobInformationsReport.htmlEncode(jobInformations.getName()));
            this.writeln("</a>");
        }
    }

    private void writeStackTrace(String stackTrace) throws IOException {
        if (stackTrace == null) {
            this.write("<img src='?resource=bullets/green.png' alt='#JobWithoutLastException#' title='#JobWithoutLastException#'/>");
        } else {
            this.write("<a class='tooltip'>");
            this.write("<em>");
            this.writeln(I18N.htmlEncode(stackTrace.replace("[See nested", "\n[See nested"), true));
            this.writeln("</em>");
            this.write("<img src='?resource=bullets/red.png' alt=''/>");
            this.writeln("</a>");
        }
    }

    private void writeJobTimes(JobInformations jobInformations, CounterRequest counterRequest) throws IOException {
        String nextColumnAlignRight = "</td> <td align='right'>";
        String nbsp = "&nbsp;";
        this.write("</td> <td align='right'>");
        if (jobInformations.getElapsedTime() >= 0L) {
            this.write(this.durationFormat.format(new Date(jobInformations.getElapsedTime())));
            if (counterRequest != null) {
                this.write("<br/>");
                this.writeln(HtmlJobInformationsReport.toBar(counterRequest.getMean(), jobInformations.getElapsedTime()));
            }
        } else {
            this.write("&nbsp;");
        }
        this.write("</td> <td align='right'>");
        if (jobInformations.getPreviousFireTime() != null) {
            this.write(this.fireTimeFormat.format(jobInformations.getPreviousFireTime()));
        } else {
            this.write("&nbsp;");
        }
        this.write("</td> <td align='right'>");
        if (jobInformations.getNextFireTime() != null) {
            this.write(this.fireTimeFormat.format(jobInformations.getNextFireTime()));
        } else {
            this.write("&nbsp;");
        }
        this.write("</td> <td align='right'>");
        if (jobInformations.getRepeatInterval() > 0L && jobInformations.getRepeatInterval() < 86400000L) {
            this.write(this.durationFormat.format(new Date(jobInformations.getRepeatInterval())));
        } else if (jobInformations.getCronExpression() != null) {
            this.write(jobInformations.getCronExpression());
        } else {
            this.write("&nbsp;");
        }
    }

    private void writePauseJobAndResumeJobLinks(JobInformations jobInformations) throws IOException {
        this.write("</td> <td align='center' class='noPrint'>");
        String onClickConfirm = "' onclick=\"javascript:return confirm('";
        String endOnClickConfirm = "');\">";
        this.writeln("<a href='?action=pause_job&amp;jobId=" + jobInformations.getGlobalJobId() + "' onclick=\"javascript:return confirm('" + I18N.getStringForJavascript("confirm_pause_job") + "');\">");
        this.writeln("<img src='?resource=control_pause_blue.png' width='18' height='18' alt=\"#Pause_job#\" title=\"#Pause_job#\" /></a>");
        this.write("</td> <td align='center' class='noPrint'>");
        this.writeln("<a href='?action=resume_job&amp;jobId=" + jobInformations.getGlobalJobId() + "' onclick=\"javascript:return confirm('" + I18N.getStringForJavascript("confirm_resume_job") + "');\">");
        this.writeln("<img src='?resource=control_play_blue.png' width='18' height='18' alt=\"#Resume_job#\" title=\"#Resume_job#\" /></a>");
    }

    private CounterRequest getCounterRequest(JobInformations jobInformations) {
        String jobFullName = jobInformations.getGroup() + '.' + jobInformations.getName();
        return this.counterRequestsByRequestName.get(jobFullName);
    }

    private static String toBar(int mean, long elapsedTime) {
        return HtmlJavaInformationsReport.toBar(100.0 * (double)elapsedTime / (double)mean);
    }

    private static String htmlEncode(String text) {
        return I18N.htmlEncode(text, false);
    }

    private void write(String html) throws IOException {
        I18N.writeTo(html, this.writer);
    }

    private void writeln(String html) throws IOException {
        I18N.writelnTo(html, this.writer);
    }
}

