/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import net.bull.javamelody.PID;
import net.bull.javamelody.Parameters;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.SchedulerRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JobInformations
implements Serializable {
    static final boolean QUARTZ_AVAILABLE = JobInformations.isQuartzAvailable();
    private static final long serialVersionUID = -2826168112578815952L;
    private final String group;
    private final String name;
    private final String description;
    private final String jobClassName;
    private final Date previousFireTime;
    private final Date nextFireTime;
    private final long elapsedTime;
    private final long repeatInterval;
    private final String cronExpression;
    private final boolean paused;
    private final String globalJobId;

    JobInformations(JobDetail jobDetail, JobExecutionContext jobExecutionContext, Scheduler scheduler) throws SchedulerException {
        assert (jobDetail != null);
        assert (scheduler != null);
        this.group = jobDetail.getGroup();
        this.name = jobDetail.getName();
        this.description = jobDetail.getDescription();
        this.jobClassName = jobDetail.getJobClass().getName();
        this.elapsedTime = jobExecutionContext == null ? -1L : System.currentTimeMillis() - jobExecutionContext.getFireTime().getTime();
        Trigger[] triggers = scheduler.getTriggersOfJob(this.name, this.group);
        this.nextFireTime = JobInformations.getNextFireTime(triggers);
        this.previousFireTime = JobInformations.getPreviousFireTime(triggers);
        String cronTriggerExpression = null;
        long simpleTriggerRepeatInterval = -1L;
        boolean jobPaused = true;
        for (Trigger trigger : triggers) {
            if (trigger instanceof CronTrigger) {
                cronTriggerExpression = ((CronTrigger)trigger).getCronExpression();
            } else if (trigger instanceof SimpleTrigger) {
                simpleTriggerRepeatInterval = ((SimpleTrigger)trigger).getRepeatInterval();
            }
            jobPaused = jobPaused && scheduler.getTriggerState(trigger.getName(), trigger.getGroup()) != 1;
        }
        this.repeatInterval = simpleTriggerRepeatInterval;
        this.cronExpression = cronTriggerExpression;
        this.paused = jobPaused;
        this.globalJobId = JobInformations.buildGlobalJobId(jobDetail);
    }

    private static boolean isQuartzAvailable() {
        try {
            Class.forName("org.quartz.Job");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static List<JobInformations> buildJobInformationsList() {
        if (!QUARTZ_AVAILABLE) {
            return Collections.emptyList();
        }
        ArrayList<JobInformations> result = new ArrayList<JobInformations>();
        try {
            for (Scheduler scheduler : JobInformations.getAllSchedulers()) {
                LinkedHashMap<String, JobExecutionContext> currentlyExecutingJobsByFullName = new LinkedHashMap<String, JobExecutionContext>();
                for (JobExecutionContext currentlyExecutingJob : scheduler.getCurrentlyExecutingJobs()) {
                    currentlyExecutingJobsByFullName.put(currentlyExecutingJob.getJobDetail().getFullName(), currentlyExecutingJob);
                }
                for (JobDetail jobDetail : JobInformations.getAllJobsOfScheduler(scheduler)) {
                    JobExecutionContext jobExecutionContext = (JobExecutionContext)currentlyExecutingJobsByFullName.get(jobDetail.getFullName());
                    result.add(new JobInformations(jobDetail, jobExecutionContext, scheduler));
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    static List<Scheduler> getAllSchedulers() {
        return new ArrayList<Scheduler>(SchedulerRepository.getInstance().lookupAll());
    }

    static List<JobDetail> getAllJobsOfScheduler(Scheduler scheduler) throws SchedulerException {
        ArrayList<JobDetail> result = new ArrayList<JobDetail>();
        for (String jobGroupName : scheduler.getJobGroupNames()) {
            for (String jobName : scheduler.getJobNames(jobGroupName)) {
                JobDetail jobDetail = scheduler.getJobDetail(jobName, jobGroupName);
                if (jobDetail == null) continue;
                result.add(jobDetail);
            }
        }
        return result;
    }

    private static Date getPreviousFireTime(Trigger[] triggers) {
        Date triggerPreviousFireTime = null;
        for (Trigger trigger : triggers) {
            if (triggerPreviousFireTime != null && (trigger.getPreviousFireTime() == null || !triggerPreviousFireTime.before(trigger.getPreviousFireTime()))) continue;
            triggerPreviousFireTime = trigger.getPreviousFireTime();
        }
        return triggerPreviousFireTime;
    }

    private static Date getNextFireTime(Trigger[] triggers) {
        Date triggerNextFireTime = null;
        for (Trigger trigger : triggers) {
            if (triggerNextFireTime != null && (trigger.getNextFireTime() == null || !triggerNextFireTime.after(trigger.getNextFireTime()))) continue;
            triggerNextFireTime = trigger.getNextFireTime();
        }
        return triggerNextFireTime;
    }

    String getGlobalJobId() {
        return this.globalJobId;
    }

    String getName() {
        return this.name;
    }

    String getGroup() {
        return this.group;
    }

    String getDescription() {
        return this.description;
    }

    String getJobClassName() {
        return this.jobClassName;
    }

    long getElapsedTime() {
        return this.elapsedTime;
    }

    boolean isCurrentlyExecuting() {
        return this.elapsedTime >= 0L;
    }

    Date getNextFireTime() {
        return this.nextFireTime;
    }

    Date getPreviousFireTime() {
        return this.previousFireTime;
    }

    long getRepeatInterval() {
        return this.repeatInterval;
    }

    String getCronExpression() {
        return this.cronExpression;
    }

    boolean isPaused() {
        return this.paused;
    }

    private static String buildGlobalJobId(JobDetail jobDetail) {
        return PID.getPID() + '_' + Parameters.getHostAddress() + '_' + jobDetail.getFullName().hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[name=" + this.getName() + ", group=" + this.getGroup() + ']';
    }
}

