/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.Anchor;
import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.awt.Image;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterRequest;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JobInformations;
import net.bull.javamelody.PdfDocumentFactory;
import net.bull.javamelody.PdfJavaInformationsReport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PdfJobInformationsReport {
    private static final long ONE_DAY_MILLIS = 86400000L;
    private final List<JobInformations> jobInformationsList;
    private final Map<String, CounterRequest> counterRequestsByRequestName;
    private final Document document;
    private final DateFormat fireTimeFormat = I18N.createDateAndTimeFormat();
    private final DateFormat durationFormat = I18N.createDurationFormat();
    private final Font cellFont = PdfDocumentFactory.TABLE_CELL_FONT;
    private PdfPTable currentTable;

    PdfJobInformationsReport(List<JobInformations> jobInformationsList, Counter rangeJobCounter, Document document) {
        assert (jobInformationsList != null);
        assert (rangeJobCounter != null);
        assert (document != null);
        this.jobInformationsList = jobInformationsList;
        this.document = document;
        List<CounterRequest> counterRequests = rangeJobCounter.getRequests();
        this.counterRequestsByRequestName = new HashMap<String, CounterRequest>(counterRequests.size());
        for (CounterRequest counterRequest : counterRequests) {
            this.counterRequestsByRequestName.put(counterRequest.getName(), counterRequest);
        }
    }

    void toPdf() throws DocumentException, IOException {
        this.writeHeader();
        PdfPCell defaultCell = this.getDefaultCell();
        boolean odd = false;
        for (JobInformations jobInformations : this.jobInformationsList) {
            if (odd) {
                defaultCell.setGrayFill(0.97f);
            } else {
                defaultCell.setGrayFill(1.0f);
            }
            odd = !odd;
            this.writeJobInformations(jobInformations);
        }
        this.document.add((Element)this.currentTable);
        this.addConfigurationReference();
    }

    private void addConfigurationReference() throws DocumentException {
        Anchor quartzAnchor = new Anchor("Configuration reference", PdfDocumentFactory.BLUE_FONT);
        quartzAnchor.setName("Quartz configuration reference");
        quartzAnchor.setReference("http://www.quartz-scheduler.org/docs/index.html");
        quartzAnchor.setFont(PdfDocumentFactory.BLUE_FONT);
        Paragraph quartzParagraph = new Paragraph();
        quartzParagraph.add((Object)quartzAnchor);
        quartzParagraph.setAlignment(2);
        this.document.add((Element)quartzParagraph);
    }

    private void writeHeader() throws DocumentException {
        List<String> headers = this.createHeaders();
        int[] relativeWidths = new int[headers.size()];
        Arrays.fill(relativeWidths, 0, headers.size(), 2);
        relativeWidths[1] = 3;
        relativeWidths[2] = 5;
        relativeWidths[headers.size() - 1] = 1;
        this.currentTable = PdfDocumentFactory.createPdfPTable(headers, relativeWidths);
    }

    private List<String> createHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(PdfJobInformationsReport.getI18nString("JobGroup"));
        headers.add(PdfJobInformationsReport.getI18nString("JobName"));
        headers.add(PdfJobInformationsReport.getI18nString("JobClassName"));
        headers.add(PdfJobInformationsReport.getI18nString("JobMeanTime"));
        headers.add(PdfJobInformationsReport.getI18nString("JobElapsedTime"));
        headers.add(PdfJobInformationsReport.getI18nString("JobPreviousFireTime"));
        headers.add(PdfJobInformationsReport.getI18nString("JobNextFireTime"));
        headers.add(PdfJobInformationsReport.getI18nString("JobPeriodOrCronExpression"));
        headers.add(PdfJobInformationsReport.getI18nString("JobPaused"));
        return headers;
    }

    private void writeJobInformations(JobInformations jobInformations) throws BadElementException, IOException {
        PdfPCell defaultCell = this.getDefaultCell();
        defaultCell.setHorizontalAlignment(0);
        this.addCell(jobInformations.getGroup());
        this.addCell(jobInformations.getName());
        this.addCell(jobInformations.getJobClassName());
        defaultCell.setHorizontalAlignment(2);
        CounterRequest counterRequest = this.getCounterRequest(jobInformations);
        if (counterRequest != null) {
            this.addCell(this.durationFormat.format(new Date(counterRequest.getMean())));
        } else {
            this.addCell("");
        }
        this.writeJobTimes(jobInformations, counterRequest);
        defaultCell.setHorizontalAlignment(1);
        if (jobInformations.isPaused()) {
            this.addCell(PdfJobInformationsReport.getI18nString("oui"));
        } else {
            this.addCell(PdfJobInformationsReport.getI18nString("non"));
        }
    }

    private void writeJobTimes(JobInformations jobInformations, CounterRequest counterRequest) throws BadElementException, IOException {
        long elapsedTime = jobInformations.getElapsedTime();
        if (elapsedTime >= 0L) {
            Phrase elapsedTimePhrase = new Phrase(this.durationFormat.format(elapsedTime), this.cellFont);
            if (counterRequest != null) {
                com.lowagie.text.Image memoryImage = com.lowagie.text.Image.getInstance((Image)PdfJavaInformationsReport.Bar.toBar(100.0 * (double)elapsedTime / (double)counterRequest.getMean()), null);
                memoryImage.scalePercent(47.0f);
                elapsedTimePhrase.add((Object)"\n");
                elapsedTimePhrase.add((Object)new Chunk(memoryImage, 0.0f, 0.0f));
            }
            this.currentTable.addCell(elapsedTimePhrase);
        } else {
            this.addCell("");
        }
        if (jobInformations.getPreviousFireTime() != null) {
            this.addCell(this.fireTimeFormat.format(jobInformations.getPreviousFireTime()));
        } else {
            this.addCell("");
        }
        if (jobInformations.getNextFireTime() != null) {
            this.addCell(this.fireTimeFormat.format(jobInformations.getNextFireTime()));
        } else {
            this.addCell("");
        }
        if (jobInformations.getRepeatInterval() > 0L && jobInformations.getRepeatInterval() < 86400000L) {
            this.addCell(this.durationFormat.format(new Date(jobInformations.getRepeatInterval())));
        } else if (jobInformations.getCronExpression() != null) {
            this.addCell(jobInformations.getCronExpression());
        } else {
            this.addCell("");
        }
    }

    private CounterRequest getCounterRequest(JobInformations jobInformations) {
        String jobFullName = jobInformations.getGroup() + '.' + jobInformations.getName();
        return this.counterRequestsByRequestName.get(jobFullName);
    }

    private static String getI18nString(String key) {
        return I18N.getString(key);
    }

    private PdfPCell getDefaultCell() {
        return this.currentTable.getDefaultCell();
    }

    private void addCell(String string) {
        this.currentTable.addCell(new Phrase(string, this.cellFont));
    }
}

