/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterError;
import net.bull.javamelody.CounterRequest;
import net.bull.javamelody.CounterRequestContext;
import net.bull.javamelody.JRobin;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.LOG;
import net.bull.javamelody.MemoryInformations;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.Period;
import net.bull.javamelody.PeriodCounterFactory;
import net.bull.javamelody.Range;
import net.bull.javamelody.TomcatInformations;
import net.bull.javamelody.VirtualMachine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Collector {
    private final int periodMillis;
    private final String application;
    private final List<Counter> counters;
    private final Map<String, JRobin> requestJRobinsById = new ConcurrentHashMap<String, JRobin>();
    private final Map<String, JRobin> counterJRobins = new LinkedHashMap<String, JRobin>();
    private final Map<String, JRobin> otherJRobins = new LinkedHashMap<String, JRobin>();
    private final Map<Counter, CounterRequest> globalRequestsByCounter = new HashMap<Counter, CounterRequest>();
    private final Map<String, CounterRequest> requestsById = new HashMap<String, CounterRequest>();
    private final Map<Counter, Counter> dayCountersByCounter = new LinkedHashMap<Counter, Counter>();
    private long cpuTimeMillis;
    private long gcTimeMillis;
    private long tomcatBytesReceived;
    private long tomcatBytesSent;
    private long lastCollectDuration;
    private long estimatedMemorySize;
    private boolean firstCollectDone;
    private final boolean noDatabase = Parameters.isNoDatabase();

    Collector(String application, List<Counter> counters) {
        assert (application != null);
        assert (counters != null);
        this.application = application;
        this.counters = Collections.unmodifiableList(new ArrayList<Counter>(counters));
        for (Counter counter : counters) {
            for (Counter otherCounter : counters) {
                assert (counter == otherCounter || !counter.getName().equals(otherCounter.getName()));
            }
            counter.setApplication(application);
            Counter dayCounter = new PeriodCounterFactory(counter).createDayCounterAtDate(new Date());
            this.dayCountersByCounter.put(counter, dayCounter);
        }
        this.periodMillis = Parameters.getResolutionSeconds() * 1000;
        try {
            for (Counter counter : counters) {
                counter.readFromFile();
            }
            for (Counter counter : counters) {
                this.dayCountersByCounter.get(counter).readFromFile();
            }
            LOG.debug("counters data read from files in " + Parameters.getStorageDirectory(application));
        }
        catch (IOException e) {
            LOG.warn("exception while reading counters data from files in " + Parameters.getStorageDirectory(application), e);
        }
    }

    String getApplication() {
        return this.application;
    }

    List<Counter> getCounters() {
        return this.counters;
    }

    Counter getCounterByName(String counterName) {
        for (Counter counter : this.counters) {
            if (!counter.getName().equals(counterName)) continue;
            return counter;
        }
        return null;
    }

    List<CounterRequestContext> getRootCurrentContexts() {
        ArrayList<CounterRequestContext> rootCurrentContexts = new ArrayList<CounterRequestContext>();
        for (Counter counter : this.counters) {
            if (!counter.isDisplayed()) continue;
            rootCurrentContexts.addAll(counter.getOrderedRootCurrentContexts());
        }
        if (rootCurrentContexts.size() > 1) {
            Collections.sort(rootCurrentContexts, Collections.reverseOrder(new Counter.CounterRequestContextComparator(System.currentTimeMillis())));
        }
        return rootCurrentContexts;
    }

    long getLastCollectDuration() {
        return this.lastCollectDuration;
    }

    long getEstimatedMemorySize() {
        return this.estimatedMemorySize;
    }

    List<Counter> getRangeCounters(Range range) throws IOException {
        if (range.getPeriod() == Period.TOUT) {
            return new ArrayList<Counter>(this.counters);
        }
        Collection<Counter> currentDayCounters = this.dayCountersByCounter.values();
        ArrayList<Counter> result = new ArrayList<Counter>(currentDayCounters.size());
        for (Counter dayCounter : currentDayCounters) {
            Counter counter = this.getRangeCounter(range, dayCounter);
            result.add(counter);
        }
        return result;
    }

    private Counter getRangeCounter(Range range, Counter dayCounter) throws IOException {
        Counter counter;
        PeriodCounterFactory periodCounterFactory = new PeriodCounterFactory(dayCounter);
        if (range.getPeriod() == null) {
            counter = periodCounterFactory.getCustomCounter(range);
        } else {
            switch (range.getPeriod()) {
                case JOUR: {
                    counter = periodCounterFactory.getDayCounter();
                    break;
                }
                case SEMAINE: {
                    counter = periodCounterFactory.getWeekCounter();
                    break;
                }
                case MOIS: {
                    counter = periodCounterFactory.getMonthCounter();
                    break;
                }
                case ANNEE: {
                    counter = periodCounterFactory.getYearCounter();
                    break;
                }
                case TOUT: {
                    throw new IllegalStateException(range.getPeriod().toString());
                }
                default: {
                    throw new IllegalArgumentException(range.getPeriod().toString());
                }
            }
        }
        return counter;
    }

    List<Counter> getRangeCountersToBeDisplayed(Range range) throws IOException {
        ArrayList<Counter> result = new ArrayList<Counter>(this.getRangeCounters(range));
        Iterator it = result.iterator();
        while (it.hasNext()) {
            Counter counter = (Counter)it.next();
            if (counter.isDisplayed() && !counter.isJobCounter()) continue;
            it.remove();
        }
        return Collections.unmodifiableList(result);
    }

    Counter getRangeCounter(Range range, String counterName) throws IOException {
        Counter counter = this.getCounterByName(counterName);
        if (counter == null) {
            throw new IllegalArgumentException(counterName);
        }
        if (range.getPeriod() == Period.TOUT) {
            return counter;
        }
        return this.getRangeCounter(range, this.dayCountersByCounter.get(counter));
    }

    void collectLocalContextWithoutErrors() {
        try {
            JavaInformations javaInformations = new JavaInformations(Parameters.getServletContext(), false);
            this.collectWithoutErrors(Collections.singletonList(javaInformations));
        }
        catch (Throwable t) {
            LOG.warn("exception while collecting data", t);
        }
    }

    void collectWithoutErrors(List<JavaInformations> javaInformationsList) {
        assert (javaInformationsList != null);
        long start = System.currentTimeMillis();
        try {
            this.estimatedMemorySize = this.collect(javaInformationsList);
        }
        catch (Throwable t) {
            LOG.warn("exception while collecting data", t);
        }
        this.lastCollectDuration = Math.max(0L, System.currentTimeMillis() - start);
        this.firstCollectDone = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long collect(List<JavaInformations> javaInformationsList) throws IOException {
        Collector collector = this;
        synchronized (collector) {
            if (!javaInformationsList.isEmpty()) {
                this.collectJavaInformations(javaInformationsList);
            }
            long memorySize = 0L;
            for (Counter counter : this.counters) {
                this.dayCountersByCounter.get(counter).setDisplayed(counter.isDisplayed());
                if (!counter.isDisplayed()) continue;
                memorySize += this.collectCounterData(counter);
            }
            return memorySize;
        }
    }

    private void collectJavaInformations(List<JavaInformations> javaInformationsList) throws IOException {
        long usedMemory = 0L;
        long processesCpuTimeMillis = 0L;
        long usedNonHeapMemory = 0L;
        int loadedClassesCount = 0;
        long garbageCollectionTimeMillis = 0L;
        long usedPhysicalMemorySize = 0L;
        long usedSwapSpaceSize = 0L;
        int availableProcessors = 0;
        int sessionCount = 0;
        long sessionAgeSum = 0L;
        int threadCount = 0;
        int activeThreadCount = 0;
        int activeConnectionCount = 0;
        int usedConnectionCount = 0;
        double systemLoadAverage = 0.0;
        long unixOpenFileDescriptorCount = 0L;
        int tomcatBusyThreads = 0;
        long bytesReceived = 0L;
        long bytesSent = 0L;
        boolean tomcatUsed = false;
        for (JavaInformations javaInformations : javaInformationsList) {
            MemoryInformations memoryInformations = javaInformations.getMemoryInformations();
            usedMemory = Collector.add(memoryInformations.getUsedMemory(), usedMemory);
            sessionCount = Collector.add(javaInformations.getSessionCount(), sessionCount);
            sessionAgeSum = Collector.add(javaInformations.getSessionAgeSum(), sessionAgeSum);
            threadCount = Collector.add(javaInformations.getThreadCount(), threadCount);
            activeThreadCount = Collector.add(javaInformations.getActiveThreadCount(), activeThreadCount);
            activeConnectionCount = Collector.add(javaInformations.getActiveConnectionCount(), activeConnectionCount);
            usedConnectionCount = Collector.add(javaInformations.getUsedConnectionCount(), usedConnectionCount);
            availableProcessors = Collector.add(Math.max(javaInformations.getAvailableProcessors(), 1), availableProcessors);
            processesCpuTimeMillis = Collector.add(javaInformations.getProcessCpuTimeMillis(), processesCpuTimeMillis);
            usedNonHeapMemory = Collector.add(memoryInformations.getUsedNonHeapMemory(), usedNonHeapMemory);
            loadedClassesCount = Collector.add(memoryInformations.getLoadedClassesCount(), loadedClassesCount);
            usedPhysicalMemorySize = Collector.add(memoryInformations.getUsedPhysicalMemorySize(), usedPhysicalMemorySize);
            usedSwapSpaceSize = Collector.add(memoryInformations.getUsedSwapSpaceSize(), usedSwapSpaceSize);
            garbageCollectionTimeMillis = Collector.add(memoryInformations.getGarbageCollectionTimeMillis(), garbageCollectionTimeMillis);
            systemLoadAverage = Collector.add(javaInformations.getSystemLoadAverage(), systemLoadAverage);
            unixOpenFileDescriptorCount = Collector.add(javaInformations.getUnixOpenFileDescriptorCount(), unixOpenFileDescriptorCount);
            for (TomcatInformations tomcatInformations : javaInformations.getTomcatInformationsList()) {
                tomcatBusyThreads = Collector.add(tomcatInformations.getCurrentThreadsBusy(), tomcatBusyThreads);
                bytesReceived = Collector.add(tomcatInformations.getBytesReceived(), bytesReceived);
                bytesSent = Collector.add(tomcatInformations.getBytesSent(), bytesSent);
                tomcatUsed = true;
            }
        }
        this.collectJRobinValues(usedMemory, processesCpuTimeMillis, availableProcessors, sessionCount, activeThreadCount, activeConnectionCount, usedConnectionCount);
        if (tomcatUsed) {
            this.collectTomcatValues(tomcatBusyThreads, bytesReceived, bytesSent);
        }
        this.collectGcTime(garbageCollectionTimeMillis, availableProcessors);
        this.collectorOtherJRobinsValues(usedNonHeapMemory, loadedClassesCount, usedPhysicalMemorySize, usedSwapSpaceSize, threadCount, systemLoadAverage, unixOpenFileDescriptorCount);
        this.collectSessionsMeanAge(sessionAgeSum, sessionCount);
    }

    private static double add(double t1, double t2) {
        if (t1 < 0.0 && t2 > 0.0) {
            return t2;
        }
        if (t1 > 0.0 && t2 < 0.0) {
            return t1;
        }
        return t1 + t2;
    }

    private static long add(long t1, long t2) {
        if (t1 < 0L && t2 > 0L) {
            return t2;
        }
        if (t1 > 0L && t2 < 0L) {
            return t1;
        }
        return t1 + t2;
    }

    private static int add(int t1, int t2) {
        if (t1 < 0 && t2 > 0) {
            return t2;
        }
        if (t1 > 0 && t2 < 0) {
            return t1;
        }
        return t1 + t2;
    }

    private void collectJRobinValues(long usedMemory, long processesCpuTimeMillis, int availableProcessors, int sessionCount, int activeThreadCount, int activeConnectionCount, int usedConnectionCount) throws IOException {
        this.getCounterJRobin("usedMemory").addValue(usedMemory);
        this.collectCpu(processesCpuTimeMillis, availableProcessors);
        if (this.getCounterByName("http") != null) {
            if (sessionCount >= 0) {
                this.getCounterJRobin("httpSessions").addValue(sessionCount);
            }
            this.getCounterJRobin("activeThreads").addValue(activeThreadCount);
        }
        if (!this.noDatabase) {
            this.getCounterJRobin("activeConnections").addValue(activeConnectionCount);
            this.getCounterJRobin("usedConnections").addValue(usedConnectionCount);
        }
        if (this.getCounterByName("builds") != null) {
            this.getCounterJRobin("runningBuilds").addValue(JdbcWrapper.getRunningBuildCount());
        }
    }

    private void collectCpu(long processesCpuTimeMillis, int availableProcessors) throws IOException {
        if (processesCpuTimeMillis >= 0L) {
            int cpuPercentage = Math.min((int)((processesCpuTimeMillis - this.cpuTimeMillis) * 100L / (long)this.periodMillis / (long)availableProcessors), 100);
            this.getCounterJRobin("cpu").addValue(cpuPercentage);
            this.cpuTimeMillis = processesCpuTimeMillis;
        }
    }

    private void collectGcTime(long garbageCollectionTimeMillis, int availableProcessors) throws IOException {
        if (garbageCollectionTimeMillis >= 0L) {
            int gcPercentage = Math.min((int)((garbageCollectionTimeMillis - this.gcTimeMillis) * 100L / (long)this.periodMillis / (long)availableProcessors), 100);
            this.getOtherJRobin("gc").addValue(gcPercentage);
            this.gcTimeMillis = garbageCollectionTimeMillis;
        }
    }

    private void collectTomcatValues(int tomcatBusyThreads, long bytesReceived, long bytesSent) throws IOException {
        this.getOtherJRobin("tomcatBusyThreads").addValue(tomcatBusyThreads);
        double periodMinutes = (double)this.periodMillis / 60000.0;
        this.getOtherJRobin("tomcatBytesReceived").addValue((double)(bytesReceived - this.tomcatBytesReceived) / periodMinutes);
        this.getOtherJRobin("tomcatBytesSent").addValue((double)(bytesSent - this.tomcatBytesSent) / periodMinutes);
        this.tomcatBytesReceived = bytesReceived;
        this.tomcatBytesSent = bytesSent;
    }

    private void collectorOtherJRobinsValues(long usedNonHeapMemory, int loadedClassesCount, long usedPhysicalMemorySize, long usedSwapSpaceSize, int threadCount, double systemLoadAverage, long unixOpenFileDescriptorCount) throws IOException {
        LinkedHashMap<String, Double> otherJRobinsValues = new LinkedHashMap<String, Double>();
        otherJRobinsValues.put("threadCount", Double.valueOf(threadCount));
        otherJRobinsValues.put("loadedClassesCount", Double.valueOf(loadedClassesCount));
        otherJRobinsValues.put("usedNonHeapMemory", Double.valueOf(usedNonHeapMemory));
        otherJRobinsValues.put("usedPhysicalMemorySize", Double.valueOf(usedPhysicalMemorySize));
        otherJRobinsValues.put("usedSwapSpaceSize", Double.valueOf(usedSwapSpaceSize));
        otherJRobinsValues.put("systemLoad", systemLoadAverage);
        otherJRobinsValues.put("fileDescriptors", Double.valueOf(unixOpenFileDescriptorCount));
        for (Map.Entry entry : otherJRobinsValues.entrySet()) {
            if (!((Double)entry.getValue() >= 0.0)) continue;
            this.getOtherJRobin((String)entry.getKey()).addValue((Double)entry.getValue());
        }
    }

    private void collectSessionsMeanAge(long sessionAgeSum, int sessionCount) throws IOException {
        if (sessionCount >= 0 && this.getCounterByName("http") != null) {
            long sessionAgeMeanInMinutes = sessionCount > 0 ? sessionAgeSum / (long)sessionCount / 60000L : -1L;
            this.getOtherJRobin("httpSessionsMeanAge").addValue(sessionAgeMeanInMinutes);
        }
    }

    private long collectCounterData(Counter counter) throws IOException {
        String counterName = counter.getName();
        List<CounterRequest> requests = counter.getRequests();
        if (!counter.isErrorCounter()) {
            JRobin systemErrorsJRobin;
            JRobin meanTimesJRobin;
            JRobin hitsJRobin;
            CounterRequest newGlobalRequest = new CounterRequest(counterName + " global", counterName);
            for (CounterRequest request : requests) {
                newGlobalRequest.addHits(request);
            }
            if (!counter.isJspOrStrutsCounter()) {
                hitsJRobin = this.getCounterJRobin(counterName + "HitsRate");
                meanTimesJRobin = this.getCounterJRobin(counterName + "MeanTimes");
                systemErrorsJRobin = this.getCounterJRobin(counterName + "SystemErrors");
            } else {
                hitsJRobin = this.getOtherJRobin(counterName + "HitsRate");
                meanTimesJRobin = this.getOtherJRobin(counterName + "MeanTimes");
                systemErrorsJRobin = this.getOtherJRobin(counterName + "SystemErrors");
            }
            CounterRequest globalRequest = this.globalRequestsByCounter.get(counter);
            if (globalRequest != null) {
                CounterRequest lastPeriodGlobalRequest = newGlobalRequest.clone();
                lastPeriodGlobalRequest.removeHits(globalRequest);
                long hits = lastPeriodGlobalRequest.getHits();
                long hitsParMinute = hits * 60L * 1000L / (long)this.periodMillis;
                hitsJRobin.addValue(hitsParMinute);
                if (hits > 0L) {
                    meanTimesJRobin.addValue(lastPeriodGlobalRequest.getMean());
                    systemErrorsJRobin.addValue(lastPeriodGlobalRequest.getSystemErrorPercentage());
                    counter.writeToFile();
                }
            }
            this.globalRequestsByCounter.put(counter, newGlobalRequest);
        }
        long dayCounterEstimatedMemorySize = this.collectCounterRequestsAndErrorsData(counter, requests);
        return counter.getEstimatedMemorySize() + dayCounterEstimatedMemorySize;
    }

    private long collectCounterRequestsAndErrorsData(Counter counter, List<CounterRequest> requests) throws IOException {
        int size = requests.size();
        Counter dayCounter = this.getCurrentDayCounter(counter);
        int maxRequestsCount = counter.getMaxRequestsCount();
        for (CounterRequest newRequest : requests) {
            if (size > maxRequestsCount && newRequest.getHits() < 10L) {
                this.removeRequest(counter, newRequest);
                --size;
                continue;
            }
            this.collectCounterRequestData(dayCounter, newRequest);
        }
        while (size > maxRequestsCount && !requests.isEmpty()) {
            this.removeRequest(counter, requests.get(0));
            --size;
        }
        if (dayCounter.isErrorCounter()) {
            dayCounter.addErrors(this.getDeltaOfErrors(counter, dayCounter));
        }
        dayCounter.writeToFile();
        return dayCounter.getEstimatedMemorySize();
    }

    private void collectCounterRequestData(Counter dayCounter, CounterRequest newRequest) throws IOException {
        String requestStorageId = newRequest.getId();
        JRobin requestJRobin = !dayCounter.isJspOrStrutsCounter() && (!dayCounter.isErrorCounter() || dayCounter.isJobCounter()) ? this.getRequestJRobin(requestStorageId, newRequest.getName()) : null;
        CounterRequest request = this.requestsById.get(requestStorageId);
        if (request != null) {
            CounterRequest lastPeriodRequest = newRequest.clone();
            lastPeriodRequest.removeHits(request);
            if (lastPeriodRequest.getHits() > 0L) {
                if (requestJRobin != null) {
                    requestJRobin.addValue(lastPeriodRequest.getMean());
                }
                dayCounter.addHits(lastPeriodRequest);
            }
        } else if (this.firstCollectDone) {
            dayCounter.addHits(newRequest);
        }
        this.requestsById.put(requestStorageId, newRequest);
    }

    private List<CounterError> getDeltaOfErrors(Counter counter, Counter dayCounter) {
        List<CounterError> errors = counter.getErrors();
        if (errors.isEmpty()) {
            return Collections.emptyList();
        }
        List<CounterError> dayErrors = dayCounter.getErrors();
        long lastErrorTime = dayErrors.isEmpty() ? dayCounter.getStartDate().getTime() : dayErrors.get(dayErrors.size() - 1).getTime();
        ArrayList<CounterError> errorsOfDay = new ArrayList<CounterError>();
        for (CounterError error : errors) {
            if (error.getTime() <= lastErrorTime) continue;
            errorsOfDay.add(error);
        }
        return errorsOfDay;
    }

    private Counter getCurrentDayCounter(Counter counter) throws IOException {
        Counter dayCounter = this.dayCountersByCounter.get(counter);
        Calendar calendar = Calendar.getInstance();
        int currentDayOfYear = calendar.get(6);
        calendar.setTime(dayCounter.getStartDate());
        if (calendar.get(6) != currentDayOfYear) {
            dayCounter = new PeriodCounterFactory(dayCounter).buildNewDayCounter();
            this.dayCountersByCounter.put(counter, dayCounter);
        }
        return dayCounter;
    }

    private void removeRequest(Counter counter, CounterRequest newRequest) {
        counter.removeRequest(newRequest.getName());
        this.requestsById.remove(newRequest.getId());
        JRobin requestJRobin = this.requestJRobinsById.remove(newRequest.getId());
        if (requestJRobin != null) {
            requestJRobin.deleteFile();
        }
    }

    private JRobin getRequestJRobin(String requestId, String requestName) throws IOException {
        JRobin jrobin = this.requestJRobinsById.get(requestId);
        if (jrobin == null) {
            jrobin = JRobin.createInstance(this.getApplication(), requestId, requestName);
            this.requestJRobinsById.put(requestId, jrobin);
        }
        return jrobin;
    }

    private JRobin getCounterJRobin(String name) throws IOException {
        JRobin jrobin = this.counterJRobins.get(name);
        if (jrobin == null) {
            jrobin = JRobin.createInstance(this.getApplication(), name, null);
            this.counterJRobins.put(name, jrobin);
        }
        return jrobin;
    }

    private JRobin getOtherJRobin(String name) throws IOException {
        JRobin jrobin = this.otherJRobins.get(name);
        if (jrobin == null) {
            jrobin = JRobin.createInstance(this.getApplication(), name, null);
            this.otherJRobins.put(name, jrobin);
        }
        return jrobin;
    }

    JRobin getJRobin(String graphName) {
        JRobin jrobin = this.counterJRobins.get(graphName);
        if (jrobin == null && (jrobin = this.otherJRobins.get(graphName)) == null && (jrobin = this.requestJRobinsById.get(graphName)) == null) {
            return null;
        }
        return jrobin;
    }

    Collection<JRobin> getCounterJRobins() {
        return Collections.unmodifiableCollection(this.counterJRobins.values());
    }

    Collection<JRobin> getOtherJRobins() {
        return Collections.unmodifiableCollection(this.otherJRobins.values());
    }

    void clearCounter(String counterName) {
        Counter counter = this.getCounterByName(counterName);
        if (counter != null) {
            List<CounterRequest> requests = counter.getRequests();
            counter.clear();
            this.globalRequestsByCounter.remove(counter);
            for (CounterRequest request : requests) {
                this.requestsById.remove(request.getId());
                this.requestJRobinsById.remove(request.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        try {
            for (Counter counter : this.counters) {
                counter.writeToFile();
            }
        }
        catch (IOException e) {
            LOG.warn("exception while writing counters data to files", e);
        }
        finally {
            for (Counter counter : this.counters) {
                counter.clear();
            }
        }
    }

    static void stopJRobin() {
        if (Boolean.parseBoolean(System.getProperty("javamelody.jrobinStopDisabled"))) {
            return;
        }
        try {
            JRobin.stop();
        }
        catch (Throwable t) {
            LOG.warn("stopping jrobin failed", t);
        }
    }

    static void detachVirtualMachine() {
        try {
            VirtualMachine.detach();
        }
        catch (Throwable t) {
            LOG.warn("exception while detaching virtual machine", t);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[application=" + this.getApplication() + ", periodMillis=" + this.periodMillis + ", counters=" + this.getCounters() + ']';
    }
}

