/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;
import net.bull.javamelody.CounterError;
import net.bull.javamelody.CounterRequest;
import net.bull.javamelody.CounterRequestContext;
import net.bull.javamelody.CounterStorage;
import net.bull.javamelody.ThreadInformations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Counter
implements Cloneable,
Serializable {
    static final String HTTP_COUNTER_NAME = "http";
    static final String ERROR_COUNTER_NAME = "error";
    static final String LOG_COUNTER_NAME = "log";
    static final String JSP_COUNTER_NAME = "jsp";
    static final String STRUTS_COUNTER_NAME = "struts";
    static final String JOB_COUNTER_NAME = "job";
    static final String BUILDS_COUNTER_NAME = "builds";
    static final int MAX_ERRORS_COUNT = 100;
    private static final int MAX_REQUESTS_COUNT = 10000;
    private static final long serialVersionUID = 6759729262180992976L;
    private String application;
    private boolean displayed = true;
    private transient boolean used;
    private final String name;
    private final boolean errorCounter;
    private final String storageName;
    private final String iconName;
    private final String childCounterName;
    private final ConcurrentMap<String, CounterRequest> requests = new ConcurrentHashMap<String, CounterRequest>();
    private final ConcurrentMap<Long, CounterRequestContext> rootCurrentContextsByThreadId = new ConcurrentHashMap<Long, CounterRequestContext>();
    private final LinkedList<CounterError> errors;
    private Date startDate = new Date();
    private int maxRequestsCount = 10000;
    private long estimatedMemorySize;
    private final transient ThreadLocal<CounterRequestContext> contextThreadLocal;
    private transient Pattern requestTransformPattern;

    Counter(String name, String iconName) {
        this(name, name, iconName, null, new ThreadLocal<CounterRequestContext>());
    }

    Counter(String name, String storageName, String iconName, String childCounterName) {
        this(name, storageName, iconName, childCounterName, new ThreadLocal<CounterRequestContext>());
    }

    Counter(String name, String iconName, Counter childCounter) {
        this(name, name, iconName, childCounter.getName(), childCounter.contextThreadLocal);
    }

    private Counter(String name, String storageName, String iconName, String childCounterName, ThreadLocal<CounterRequestContext> contextThreadLocal) {
        assert (name != null);
        assert (storageName != null);
        this.name = name;
        this.storageName = storageName;
        this.errorCounter = ERROR_COUNTER_NAME.equals(name) || LOG_COUNTER_NAME.equals(name) || JOB_COUNTER_NAME.equals(name);
        this.iconName = iconName;
        this.childCounterName = childCounterName;
        this.contextThreadLocal = contextThreadLocal;
        this.errors = this.errorCounter ? new LinkedList() : null;
    }

    void setApplication(String application) {
        assert (application != null);
        this.application = application;
    }

    String getApplication() {
        return this.application;
    }

    String getName() {
        return this.name;
    }

    String getStorageName() {
        return this.storageName;
    }

    String getIconName() {
        return this.iconName;
    }

    String getChildCounterName() {
        return this.childCounterName;
    }

    Date getStartDate() {
        return this.startDate;
    }

    void setStartDate(Date startDate) {
        assert (startDate != null);
        this.startDate = startDate;
    }

    boolean isDisplayed() {
        return this.displayed;
    }

    void setDisplayed(boolean displayed) {
        this.displayed = displayed;
    }

    boolean isUsed() {
        return this.used;
    }

    void setUsed(boolean used) {
        this.used = used;
    }

    Pattern getRequestTransformPattern() {
        return this.requestTransformPattern;
    }

    void setRequestTransformPattern(Pattern requestTransformPattern) {
        this.requestTransformPattern = requestTransformPattern;
    }

    int getMaxRequestsCount() {
        return this.maxRequestsCount;
    }

    void setMaxRequestsCount(int maxRequestsCount) {
        assert (maxRequestsCount > 0);
        this.maxRequestsCount = maxRequestsCount;
    }

    long getEstimatedMemorySize() {
        return this.estimatedMemorySize;
    }

    void bindContextIncludingCpu(String requestName) {
        this.bindContext(requestName, requestName, null, ThreadInformations.getCurrentThreadCpuTime());
    }

    void bindContext(String requestName, String completeRequestName, String remoteUser, long startCpuTime) {
        CounterRequestContext context = new CounterRequestContext(this, this.contextThreadLocal.get(), requestName, completeRequestName, remoteUser, startCpuTime);
        this.contextThreadLocal.set(context);
        if (context.getParentContext() == null) {
            this.rootCurrentContextsByThreadId.put(context.getThreadId(), context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unbindContext() {
        try {
            this.contextThreadLocal.remove();
        }
        finally {
            this.rootCurrentContextsByThreadId.remove(Thread.currentThread().getId());
        }
    }

    void addRequestForCurrentContext(boolean systemError) {
        CounterRequestContext context = this.contextThreadLocal.get();
        if (context != null) {
            long duration = context.getDuration(System.currentTimeMillis());
            long cpuUsedMillis = context.getCpuTime();
            this.addRequest(context.getRequestName(), duration, cpuUsedMillis, systemError, -1);
        }
    }

    void addRequestForCurrentContext(String systemErrorStackTrace) {
        assert (this.errorCounter);
        CounterRequestContext context = this.contextThreadLocal.get();
        if (context != null) {
            long duration = context.getDuration(System.currentTimeMillis());
            long cpuUsedMillis = context.getCpuTime();
            this.addRequest(context.getRequestName(), duration, cpuUsedMillis, systemErrorStackTrace != null, systemErrorStackTrace, -1);
        }
    }

    void addRequest(String requestName, long duration, long cpuTime, boolean systemError, int responseSize) {
        this.addRequest(requestName, duration, cpuTime, systemError, null, responseSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRequest(String requestName, long duration, long cpuTime, boolean systemError, String systemErrorStackTrace, int responseSize) {
        CounterRequest request;
        assert (requestName != null);
        assert (duration >= 0L);
        assert (cpuTime >= -1L);
        assert (responseSize >= -1);
        String aggregateRequestName = this.getAggregateRequestName(requestName);
        CounterRequestContext context = this.contextThreadLocal.get();
        Cloneable cloneable = request = this.getCounterRequestInternal(aggregateRequestName);
        synchronized (cloneable) {
            request.addHit(duration, cpuTime, systemError, systemErrorStackTrace, responseSize);
            if (context != null) {
                if (context.getParentCounter() == this) {
                    request.addChildHits(context);
                }
                request.addChildRequests(context.getChildRequestsExecutionsByRequestId());
            }
        }
        if (context != null) {
            if (context.getParentCounter() == this) {
                CounterRequestContext parentContext = context.getParentContext();
                if (parentContext == null) {
                    this.unbindContext();
                } else {
                    context.addChildRequest(this, aggregateRequestName, request.getId(), duration, systemError, responseSize);
                    parentContext.closeChildContext();
                    this.contextThreadLocal.set(parentContext);
                }
            } else {
                context.addChildRequest(this, aggregateRequestName, request.getId(), duration, systemError, responseSize);
            }
        }
        if (systemErrorStackTrace != null) {
            assert (this.errorCounter);
            cloneable = this.errors;
            synchronized (cloneable) {
                this.errors.addLast(new CounterError(requestName, systemErrorStackTrace));
                if (this.errors.size() > 100) {
                    this.errors.removeFirst();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRequestForSystemError(String requestName, long duration, long cpuTime, String stackTrace) {
        CounterRequest request;
        assert (requestName != null);
        assert (duration >= -1L);
        assert (cpuTime >= -1L);
        assert (this.errorCounter);
        assert (this.contextThreadLocal.get() == null);
        String aggregateRequestName = this.getAggregateRequestName(requestName);
        Cloneable cloneable = request = this.getCounterRequestInternal(aggregateRequestName);
        synchronized (cloneable) {
            request.addHit(duration, cpuTime, true, stackTrace, -1);
        }
        cloneable = this.errors;
        synchronized (cloneable) {
            this.errors.addLast(new CounterError(requestName, stackTrace));
            if (this.errors.size() > 100) {
                this.errors.removeFirst();
            }
        }
    }

    boolean isErrorCounter() {
        return this.errorCounter;
    }

    boolean isJobCounter() {
        return JOB_COUNTER_NAME.equals(this.name);
    }

    boolean isJspOrStrutsCounter() {
        return JSP_COUNTER_NAME.equals(this.name) || STRUTS_COUNTER_NAME.equals(this.name);
    }

    boolean isBusinessFacadeCounter() {
        return "services".equals(this.name) || "ejb".equals(this.name) || "spring".equals(this.name) || "guice".equals(this.name);
    }

    boolean isRequestIdFromThisCounter(String requestId) {
        return requestId.startsWith(this.getName());
    }

    private String getAggregateRequestName(String requestName) {
        String aggregateRequestName = this.requestTransformPattern == null ? requestName : this.requestTransformPattern.matcher(requestName).replaceAll("\\$");
        return aggregateRequestName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRequestsAndErrors(Counter newCounter) {
        int maxRequests;
        assert (this.getName().equals(newCounter.getName()));
        for (CounterRequest newRequest : newCounter.getRequests()) {
            CounterRequest request;
            if (newRequest.getHits() <= 0L) continue;
            CounterRequest counterRequest = request = this.getCounterRequestInternal(newRequest.getName());
            synchronized (counterRequest) {
                request.addHits(newRequest);
            }
        }
        int size = this.requests.size();
        if (size > (maxRequests = this.getMaxRequestsCount())) {
            for (CounterRequest request : this.requests.values()) {
                if (request.getHits() >= 10L) continue;
                this.removeRequest(request.getName());
                if (--size > maxRequests) continue;
                break;
            }
        }
        if (this.isErrorCounter()) {
            this.addErrors(newCounter.getErrors());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addHits(CounterRequest counterRequest) {
        if (counterRequest.getHits() > 0L) {
            CounterRequest request;
            CounterRequest newRequest = counterRequest.clone();
            CounterRequest counterRequest2 = request = this.getCounterRequestInternal(newRequest.getName());
            synchronized (counterRequest2) {
                request.addHits(newRequest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addErrors(List<CounterError> counterErrorList) {
        assert (this.errorCounter);
        if (counterErrorList.isEmpty()) {
            return;
        }
        LinkedList<CounterError> linkedList = this.errors;
        synchronized (linkedList) {
            if (!this.errors.isEmpty() && this.errors.get(0).getTime() > counterErrorList.get(0).getTime()) {
                this.errors.addAll(0, counterErrorList);
            } else {
                this.errors.addAll(counterErrorList);
            }
            if (this.errors.size() > 1) {
                Collections.sort(this.errors, new CounterErrorComparator());
                while (this.errors.size() > 100) {
                    this.errors.removeFirst();
                }
            }
        }
    }

    void removeRequest(String requestName) {
        assert (requestName != null);
        this.requests.remove(requestName);
    }

    CounterRequest getCounterRequest(CounterRequestContext context) {
        return this.getCounterRequestByName(context.getRequestName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CounterRequest getCounterRequestByName(String requestName) {
        CounterRequest request;
        String aggregateRequestName = this.getAggregateRequestName(requestName);
        CounterRequest counterRequest = request = this.getCounterRequestInternal(aggregateRequestName);
        synchronized (counterRequest) {
            return request.clone();
        }
    }

    private CounterRequest getCounterRequestInternal(String requestName) {
        CounterRequest precedentRequest;
        CounterRequest request = (CounterRequest)this.requests.get(requestName);
        if (request == null && (precedentRequest = this.requests.putIfAbsent(requestName, request = new CounterRequest(requestName, this.getName()))) != null) {
            request = precedentRequest;
        }
        return request;
    }

    int getRequestsCount() {
        return this.requests.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<CounterRequest> getRequests() {
        ArrayList<CounterRequest> result = new ArrayList<CounterRequest>(this.requests.size());
        Iterator i$ = this.requests.values().iterator();
        while (i$.hasNext()) {
            CounterRequest request;
            CounterRequest counterRequest = request = (CounterRequest)i$.next();
            synchronized (counterRequest) {
                result.add(request.clone());
            }
        }
        return result;
    }

    List<CounterRequest> getOrderedRequests() {
        List<CounterRequest> requestList = this.getRequests();
        if (requestList.size() > 1) {
            Collections.sort(requestList, Collections.reverseOrder(new CounterRequestComparator()));
        }
        return requestList;
    }

    List<CounterRequest> getOrderedByHitsRequests() {
        List<CounterRequest> requestList = this.getRequests();
        if (requestList.size() > 1) {
            Collections.sort(requestList, Collections.reverseOrder(new CounterRequestByHitsComparator()));
        }
        return requestList;
    }

    List<CounterRequestContext> getOrderedRootCurrentContexts() {
        ArrayList<CounterRequestContext> contextList = new ArrayList<CounterRequestContext>(this.rootCurrentContextsByThreadId.size());
        for (CounterRequestContext rootCurrentContext : this.rootCurrentContextsByThreadId.values()) {
            contextList.add(rootCurrentContext.clone());
        }
        if (contextList.size() > 1) {
            Collections.sort(contextList, Collections.reverseOrder(new CounterRequestContextComparator(System.currentTimeMillis())));
        }
        return contextList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<CounterError> getErrors() {
        if (this.errors == null) {
            return Collections.emptyList();
        }
        LinkedList<CounterError> linkedList = this.errors;
        synchronized (linkedList) {
            return new ArrayList<CounterError>(this.errors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getErrorsCount() {
        if (this.errors == null) {
            return 0;
        }
        LinkedList<CounterError> linkedList = this.errors;
        synchronized (linkedList) {
            return this.errors.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        this.requests.clear();
        this.rootCurrentContextsByThreadId.clear();
        if (this.errors != null) {
            LinkedList<CounterError> linkedList = this.errors;
            synchronized (linkedList) {
                this.errors.clear();
            }
        }
        this.startDate = new Date();
    }

    public Counter clone() {
        Counter clone = new Counter(this.getName(), this.getStorageName(), this.getIconName(), this.getChildCounterName(), new ThreadLocal<CounterRequestContext>());
        clone.application = this.getApplication();
        clone.startDate = this.getStartDate();
        clone.maxRequestsCount = this.getMaxRequestsCount();
        clone.displayed = this.isDisplayed();
        clone.requestTransformPattern = this.getRequestTransformPattern();
        for (CounterRequest request : this.getRequests()) {
            clone.requests.put(request.getName(), request);
        }
        if (this.errors != null) {
            clone.errors.addAll(this.getErrors());
        }
        return clone;
    }

    void writeToFile() throws IOException {
        Counter counter = this.clone();
        counter.rootCurrentContextsByThreadId.clear();
        this.estimatedMemorySize = new CounterStorage(counter).writeToFile();
    }

    void readFromFile() throws IOException {
        Counter counter = new CounterStorage(this).readFromFile();
        if (counter != null) {
            Counter newCounter = this.clone();
            this.startDate = counter.getStartDate();
            this.requests.clear();
            for (CounterRequest request : counter.getRequests()) {
                this.requests.put(request.getName(), request);
            }
            if (this.errors != null) {
                this.errors.clear();
                this.errors.addAll(counter.getErrors());
            }
            this.addRequestsAndErrors(newCounter);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[application=" + this.getApplication() + ", name=" + this.getName() + ", storageName=" + this.getStorageName() + ", startDate=" + this.getStartDate() + ", childCounterName=" + this.getChildCounterName() + ", " + this.requests.size() + " requests, " + (this.errors == null ? "" : this.errors.size() + " errors, ") + "maxRequestsCount=" + this.getMaxRequestsCount() + ", displayed=" + this.isDisplayed() + ']';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CounterRequestContextComparator
    implements Comparator<CounterRequestContext>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final long timeOfSnapshot;

        CounterRequestContextComparator(long timeOfSnapshot) {
            this.timeOfSnapshot = timeOfSnapshot;
        }

        @Override
        public int compare(CounterRequestContext context1, CounterRequestContext context2) {
            if (context1.getDuration(this.timeOfSnapshot) > context2.getDuration(this.timeOfSnapshot)) {
                return 1;
            }
            if (context1.getDuration(this.timeOfSnapshot) < context2.getDuration(this.timeOfSnapshot)) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CounterErrorComparator
    implements Comparator<CounterError>,
    Serializable {
        private static final long serialVersionUID = 1L;

        CounterErrorComparator() {
        }

        @Override
        public int compare(CounterError error1, CounterError error2) {
            return (int)(error1.getTime() - error2.getTime());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CounterRequestByHitsComparator
    implements Comparator<CounterRequest>,
    Serializable {
        private static final long serialVersionUID = 1L;

        CounterRequestByHitsComparator() {
        }

        @Override
        public int compare(CounterRequest request1, CounterRequest request2) {
            if (request1.getHits() > request2.getHits()) {
                return 1;
            }
            if (request1.getHits() < request2.getHits()) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CounterRequestComparator
    implements Comparator<CounterRequest>,
    Serializable {
        private static final long serialVersionUID = 1L;

        CounterRequestComparator() {
        }

        @Override
        public int compare(CounterRequest request1, CounterRequest request2) {
            if (request1.getDurationsSum() > request2.getDurationsSum()) {
                return 1;
            }
            if (request1.getDurationsSum() < request2.getDurationsSum()) {
                return -1;
            }
            return 0;
        }
    }
}

