/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.util.List;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import net.bull.javamelody.MBeans;
import net.bull.javamelody.PdfDocumentFactory;

class PdfMBeansReport {
    private MBeans mbeans;
    private final Document document;
    private final Font boldFont = PdfDocumentFactory.BOLD_FONT;
    private final Font normalFont = PdfDocumentFactory.NORMAL_FONT;
    private final Font cellFont = PdfDocumentFactory.TABLE_CELL_FONT;
    private int margin;
    private PdfPTable currentTable;

    PdfMBeansReport(Document document) {
        assert (document != null);
        this.document = document;
        this.setMBeans(new MBeans());
    }

    void toPdf() throws JMException, DocumentException {
        this.writeTree();
    }

    void writeTree() throws JMException, DocumentException {
        this.writeTreeForCurrentMBeans();
        MBeanServer plateformMBeanServer = MBeans.getPlatformMBeanServer();
        for (MBeanServer mbeanServer : MBeans.getMBeanServers()) {
            if (mbeanServer == plateformMBeanServer) continue;
            this.setMBeans(new MBeans(mbeanServer));
            this.document.newPage();
            this.document.add((Element)new Chunk(mbeanServer.getDefaultDomain(), this.boldFont));
            this.writeTreeForCurrentMBeans();
        }
    }

    private void writeTreeForCurrentMBeans() throws JMException, DocumentException {
        Map<String, Map<String, List<ObjectName>>> mapObjectNamesByDomainAndFirstProperty = this.mbeans.getMapObjectNamesByDomainAndFirstProperty();
        for (Map.Entry<String, Map<String, List<ObjectName>>> entryObjectNamesByDomainAndFirstProperty : mapObjectNamesByDomainAndFirstProperty.entrySet()) {
            String domain = entryObjectNamesByDomainAndFirstProperty.getKey();
            this.margin = 0;
            this.addText(domain);
            Map<String, List<ObjectName>> mapObjectNamesByFirstProperty = entryObjectNamesByDomainAndFirstProperty.getValue();
            for (Map.Entry<String, List<ObjectName>> entryObjectNamesByFirstProperty : mapObjectNamesByFirstProperty.entrySet()) {
                String firstProperty = entryObjectNamesByFirstProperty.getKey();
                this.margin = 12;
                this.addText(firstProperty);
                List<ObjectName> objectNames = entryObjectNamesByFirstProperty.getValue();
                for (ObjectName name : objectNames) {
                    this.margin = 25;
                    String mbean = name.toString();
                    int indexOfComma = mbean.indexOf(44);
                    if (indexOfComma != -1) {
                        mbean = mbean.substring(indexOfComma + 1);
                        this.addText(mbean);
                        this.margin = 37;
                        this.writeAttributes(name);
                        continue;
                    }
                    this.writeAttributes(name);
                }
            }
        }
    }

    private void writeAttributes(ObjectName name) throws JMException, DocumentException {
        MBeanInfo mbeanInfo = this.mbeans.getMBeanInfo(name);
        MBeanAttributeInfo[] attributeInfos = mbeanInfo.getAttributes();
        Map<String, Object> attributes = this.mbeans.getAttributes(name, attributeInfos);
        String description = this.mbeans.formatMBeansDescription(mbeanInfo.getDescription());
        if (description != null || !attributes.isEmpty()) {
            this.currentTable = PdfMBeansReport.createAttributesTable();
            if (description != null) {
                this.currentTable.getDefaultCell().setColspan(3);
                this.addCell('(' + description + ')');
                this.currentTable.getDefaultCell().setColspan(1);
            }
            for (Map.Entry<String, Object> entryAttributes : attributes.entrySet()) {
                String attributeName = entryAttributes.getKey();
                Object attributeValue = entryAttributes.getValue();
                this.writeAttribute(attributeName, attributeValue, attributeInfos);
            }
            Paragraph paragraph = new Paragraph();
            paragraph.setIndentationLeft((float)this.margin);
            paragraph.add((Object)this.currentTable);
            this.document.add((Element)paragraph);
            this.addText("\n");
        }
    }

    private void writeAttribute(String attributeName, Object attributeValue, MBeanAttributeInfo[] attributeInfos) {
        this.addCell(attributeName);
        this.addCell(this.mbeans.formatAttributeValue(attributeValue));
        String attributeDescription = this.mbeans.getAttributeDescription(attributeName, attributeInfos);
        if (attributeDescription != null && !attributeDescription.equals(attributeName)) {
            this.addCell('(' + attributeDescription + ')');
        } else {
            this.addCell("");
        }
    }

    private void setMBeans(MBeans mBeans) {
        this.mbeans = mBeans;
    }

    private static PdfPTable createAttributesTable() {
        PdfPTable table = new PdfPTable(3);
        table.setWidthPercentage(100.0f);
        PdfPCell defaultCell = table.getDefaultCell();
        defaultCell.setPaddingLeft(2.0f);
        defaultCell.setPaddingRight(2.0f);
        defaultCell.setVerticalAlignment(4);
        defaultCell.setBorder(0);
        return table;
    }

    private void addText(String text) throws DocumentException {
        Paragraph paragraph = new Paragraph(text, this.normalFont);
        paragraph.setIndentationLeft((float)this.margin);
        this.document.add((Element)paragraph);
    }

    private void addCell(String string) {
        this.currentTable.addCell(new Phrase(string, this.cellFont));
    }
}

