/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import java.lang.reflect.Method;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import net.bull.javamelody.Counter;
import net.bull.javamelody.LOG;
import net.bull.javamelody.MonitoringProxy;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;

public class MonitoringInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Counter EJB_COUNTER = MonitoringProxy.getEjbCounter();
    private static final boolean COUNTER_HIDDEN = Parameters.isCounterHidden(EJB_COUNTER.getName());
    private static final boolean DISABLED = Boolean.parseBoolean(Parameters.getParameter(Parameter.DISABLED));

    public MonitoringInterceptor() {
        EJB_COUNTER.setDisplayed(!COUNTER_HIDDEN);
        EJB_COUNTER.setUsed(true);
        LOG.debug("ejb interceptor initialized");
    }

    @AroundInvoke
    public Object intercept(InvocationContext context) throws Exception {
        if (DISABLED || !EJB_COUNTER.isDisplayed()) {
            return context.proceed();
        }
        Method method = context.getMethod();
        String requestName = method.getDeclaringClass().getSimpleName() + '.' + method.getName();
        boolean systemError = false;
        try {
            EJB_COUNTER.bindContextIncludingCpu(requestName);
            Object object = context.proceed();
            Object var7_7 = null;
            EJB_COUNTER.addRequestForCurrentContext(systemError);
            return object;
        }
        catch (Error e) {
            try {
                systemError = true;
                throw e;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                EJB_COUNTER.addRequestForCurrentContext(systemError);
                throw throwable;
            }
        }
    }
}

