/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterRequestContext;
import net.bull.javamelody.HtmlCounterRequestContextReport;
import net.bull.javamelody.I18N;
import net.bull.javamelody.PdfCounterReport;
import net.bull.javamelody.PdfDocumentFactory;
import net.bull.javamelody.ThreadInformations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PdfCounterRequestContextReport {
    private final List<CounterRequestContext> rootCurrentContexts;
    private final Map<String, PdfCounterReport> counterReportsByCounterName;
    private final Map<Long, ThreadInformations> threadInformationsByThreadId;
    private final Document document;
    private final boolean childHitsDisplayed;
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();
    private final long timeOfSnapshot = System.currentTimeMillis();
    private final boolean stackTraceEnabled;
    private final Font cellFont = PdfDocumentFactory.TABLE_CELL_FONT;
    private final Font normalFont = PdfDocumentFactory.NORMAL_FONT;
    private PdfPTable currentTable;
    private final PdfDocumentFactory pdfDocumentFactory;

    PdfCounterRequestContextReport(List<CounterRequestContext> rootCurrentContexts, List<PdfCounterReport> pdfCounterReports, List<ThreadInformations> threadInformationsList, boolean stackTraceEnabled, PdfDocumentFactory pdfDocumentFactory, Document document) {
        assert (rootCurrentContexts != null);
        assert (pdfCounterReports != null);
        assert (threadInformationsList != null);
        assert (pdfDocumentFactory != null);
        assert (document != null);
        this.rootCurrentContexts = rootCurrentContexts;
        this.counterReportsByCounterName = new HashMap<String, PdfCounterReport>(pdfCounterReports.size());
        for (PdfCounterReport counterReport : pdfCounterReports) {
            this.counterReportsByCounterName.put(counterReport.getCounterName(), counterReport);
        }
        this.threadInformationsByThreadId = new HashMap<Long, ThreadInformations>(threadInformationsList.size());
        for (ThreadInformations threadInformations : threadInformationsList) {
            this.threadInformationsByThreadId.put(threadInformations.getId(), threadInformations);
        }
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.document = document;
        boolean oneRootHasChild = false;
        for (CounterRequestContext rootCurrentContext : rootCurrentContexts) {
            if (rootCurrentContext.getParentCounter().getChildCounterName() == null) continue;
            oneRootHasChild = true;
            break;
        }
        this.childHitsDisplayed = oneRootHasChild;
        this.stackTraceEnabled = stackTraceEnabled;
    }

    void toPdf() throws DocumentException, IOException {
        if (this.rootCurrentContexts.isEmpty()) {
            return;
        }
        this.writeContexts(Collections.singletonList(this.rootCurrentContexts.get(0)));
    }

    void writeContextDetails() throws DocumentException, IOException {
        if (this.rootCurrentContexts.isEmpty()) {
            return;
        }
        this.writeContexts(this.rootCurrentContexts);
    }

    private void writeContexts(List<CounterRequestContext> contexts) throws DocumentException, IOException {
        boolean displayRemoteUser = false;
        for (CounterRequestContext context : contexts) {
            if (context.getRemoteUser() == null) continue;
            displayRemoteUser = true;
            break;
        }
        this.writeHeader(contexts, displayRemoteUser);
        PdfPCell defaultCell = this.getDefaultCell();
        defaultCell.setLeading(2.0f, 1.0f);
        defaultCell.setPaddingTop(0.0f);
        boolean odd = false;
        for (CounterRequestContext context : contexts) {
            if (odd) {
                defaultCell.setGrayFill(0.97f);
            } else {
                defaultCell.setGrayFill(1.0f);
            }
            odd = !odd;
            this.writeContext(context, displayRemoteUser);
        }
        this.document.add((Element)this.currentTable);
        this.writeFooter();
    }

    private void writeHeader(List<CounterRequestContext> contexts, boolean displayRemoteUser) throws DocumentException {
        List<String> headers = this.createHeaders(contexts, displayRemoteUser);
        int[] relativeWidths = new int[headers.size()];
        Arrays.fill(relativeWidths, 0, headers.size(), 1);
        if (displayRemoteUser) {
            relativeWidths[2] = 6;
        } else {
            relativeWidths[1] = 6;
        }
        if (this.stackTraceEnabled) {
            relativeWidths[headers.size() - 1] = 3;
        }
        this.currentTable = PdfDocumentFactory.createPdfPTable(headers, relativeWidths);
    }

    private List<String> createHeaders(List<CounterRequestContext> contexts, boolean displayRemoteUser) {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(PdfCounterRequestContextReport.getI18nString("Thread"));
        if (displayRemoteUser) {
            headers.add(PdfCounterRequestContextReport.getI18nString("Utilisateur"));
        }
        headers.add(PdfCounterRequestContextReport.getI18nString("Requete"));
        headers.add(PdfCounterRequestContextReport.getI18nString("Duree_ecoulee"));
        headers.add(PdfCounterRequestContextReport.getI18nString("Temps_moyen"));
        headers.add(PdfCounterRequestContextReport.getI18nString("Temps_cpu"));
        headers.add(PdfCounterRequestContextReport.getI18nString("Temps_cpu_moyen"));
        if (this.childHitsDisplayed) {
            String childCounterName = contexts.get(0).getParentCounter().getChildCounterName();
            headers.add(I18N.getFormattedString("hits_fils", childCounterName));
            headers.add(I18N.getFormattedString("hits_fils_moyens", childCounterName));
            headers.add(I18N.getFormattedString("temps_fils", childCounterName));
            headers.add(I18N.getFormattedString("temps_fils_moyen", childCounterName));
        }
        if (this.stackTraceEnabled) {
            headers.add(PdfCounterRequestContextReport.getI18nString("Methode_executee"));
        }
        return headers;
    }

    private void writeFooter() throws DocumentException {
        Paragraph footer = new Paragraph(I18N.getFormattedString("nb_requete_en_cours", this.integerFormat.format(this.rootCurrentContexts.size())), this.normalFont);
        footer.setAlignment(2);
        this.document.add((Element)footer);
    }

    private void writeContext(CounterRequestContext rootContext, boolean displayRemoteUser) throws DocumentException, IOException {
        this.getDefaultCell().setHorizontalAlignment(0);
        ThreadInformations threadInformations = this.threadInformationsByThreadId.get(rootContext.getThreadId());
        if (threadInformations == null) {
            this.addCell("");
        } else {
            this.addCell(threadInformations.getName());
        }
        if (displayRemoteUser) {
            if (rootContext.getRemoteUser() == null) {
                this.addCell("");
            } else {
                this.addCell(rootContext.getRemoteUser());
            }
        }
        ArrayList<CounterRequestContext> contexts = new ArrayList<CounterRequestContext>();
        contexts.add(rootContext);
        contexts.addAll(rootContext.getChildContexts());
        this.writeRequests(contexts);
        this.writeDurations(contexts);
        HtmlCounterRequestContextReport.CounterRequestContextReportHelper counterRequestContextReportHelper = new HtmlCounterRequestContextReport.CounterRequestContextReportHelper(contexts, this.childHitsDisplayed);
        for (int[] requestValues : counterRequestContextReportHelper.getRequestValues()) {
            this.writeRequestValues(requestValues);
        }
        if (this.stackTraceEnabled) {
            this.getDefaultCell().setHorizontalAlignment(0);
            if (threadInformations == null) {
                this.addCell("");
            } else {
                this.addCell(threadInformations.getExecutedMethod());
            }
        }
    }

    private void writeDurations(List<CounterRequestContext> contexts) throws DocumentException, IOException {
        this.getDefaultCell().setHorizontalAlignment(2);
        Paragraph paragraph = new Paragraph("", this.cellFont);
        boolean first = true;
        for (CounterRequestContext context : contexts) {
            if (!first) {
                paragraph.add((Object)new Chunk('\n', this.cellFont));
            }
            int duration = context.getDuration(this.timeOfSnapshot);
            Counter parentCounter = context.getParentCounter();
            PdfCounterReport counterReport = this.counterReportsByCounterName.get(parentCounter.getName());
            if (parentCounter.getIconName() != null) {
                paragraph.add((Object)new Chunk(this.getImage(parentCounter.getIconName()), 0.0f, -1.0f));
            }
            Font slaFont = counterReport == null ? PdfDocumentFactory.INFO_CELL_FONT : counterReport.getSlaFont(duration);
            paragraph.add((Object)new Phrase(this.integerFormat.format(duration), slaFont));
            first = false;
        }
        this.currentTable.addCell((Phrase)paragraph);
    }

    private void writeRequests(List<CounterRequestContext> contexts) throws DocumentException, IOException {
        PdfPCell defaultCell = this.getDefaultCell();
        PdfPCell requestCell = new PdfPCell();
        Paragraph phrase = new Paragraph("", this.cellFont);
        int margin = 0;
        for (CounterRequestContext context : contexts) {
            this.writeRequest(context, requestCell, margin);
            margin += 5;
        }
        requestCell.addElement((Element)phrase);
        requestCell.setGrayFill(defaultCell.getGrayFill());
        requestCell.setPaddingTop(defaultCell.getPaddingTop());
        this.currentTable.addCell(requestCell);
    }

    private void writeRequest(CounterRequestContext context, PdfPCell cell, int margin) throws DocumentException, IOException {
        Paragraph paragraph = new Paragraph(this.getDefaultCell().getLeading() + this.cellFont.getSize());
        paragraph.setIndentationLeft((float)margin);
        if (context.getParentCounter().getIconName() != null) {
            paragraph.add((Object)new Chunk(this.getImage(context.getParentCounter().getIconName()), 0.0f, -1.0f));
        }
        paragraph.add((Object)new Phrase(context.getCompleteRequestName(), this.cellFont));
        cell.addElement((Element)paragraph);
    }

    private void writeRequestValues(int[] requestValues) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (int value : requestValues) {
            if (!first) {
                sb.append('\n');
            }
            if (value != -1) {
                sb.append(this.integerFormat.format(value));
            }
            first = false;
        }
        this.addCell(sb.toString());
    }

    private PdfPCell getDefaultCell() {
        return this.currentTable.getDefaultCell();
    }

    private void addCell(String string) {
        this.currentTable.addCell(new Phrase(string, this.cellFont));
    }

    private Image getImage(String resourceFileName) throws DocumentException, IOException {
        return this.pdfDocumentFactory.getSmallImage(resourceFileName);
    }

    private static String getI18nString(String key) {
        return I18N.getString(key);
    }
}

