/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bull.javamelody.HeapHistogram;
import net.bull.javamelody.I18N;
import net.bull.javamelody.PdfDocumentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PdfHeapHistogramReport {
    private final HeapHistogram heapHistogram;
    private final Document document;
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();
    private final Font cellFont = PdfDocumentFactory.TABLE_CELL_FONT;
    private final Font boldFont = PdfDocumentFactory.BOLD_CELL_FONT;
    private PdfPTable currentTable;

    PdfHeapHistogramReport(HeapHistogram heapHistogram, Document document) {
        assert (heapHistogram != null);
        assert (document != null);
        this.heapHistogram = heapHistogram;
        this.document = document;
    }

    void toPdf() throws DocumentException {
        this.document.add((Element)new Phrase(PdfHeapHistogramReport.getI18nString("Heap"), this.boldFont));
        List<HeapHistogram.ClassInfo> heap = this.heapHistogram.getHeapHistogram();
        long totalHeapInstances = this.heapHistogram.getTotalHeapInstances();
        long totalHeapBytes = this.heapHistogram.getTotalHeapBytes();
        String separator = ",   ";
        this.document.add((Element)new Phrase("     " + PdfHeapHistogramReport.getI18nString("Classes") + ": " + this.integerFormat.format(heap.size()) + ",   " + PdfHeapHistogramReport.getI18nString("Instances") + ": " + this.integerFormat.format(totalHeapInstances) + ",   " + PdfHeapHistogramReport.getI18nString("Kilo-Octets") + ": " + this.integerFormat.format(totalHeapBytes / 1024L), this.cellFont));
        this.writeHeader(this.heapHistogram.isSourceDisplayed(), this.heapHistogram.isDeltaDisplayed());
        this.writeClassInfo(heap, totalHeapInstances, totalHeapBytes, this.heapHistogram.isSourceDisplayed(), this.heapHistogram.isDeltaDisplayed());
        List<HeapHistogram.ClassInfo> permGen = this.heapHistogram.getPermGenHistogram();
        if (!permGen.isEmpty()) {
            this.document.add((Element)new Phrase("\n\n" + PdfHeapHistogramReport.getI18nString("PermGen"), this.boldFont));
            long totalPermGenInstances = this.heapHistogram.getTotalPermGenInstances();
            long totalPermGenBytes = this.heapHistogram.getTotalPermGenBytes();
            this.document.add((Element)new Phrase("     " + PdfHeapHistogramReport.getI18nString("Classes") + ": " + this.integerFormat.format(permGen.size()) + ",   " + PdfHeapHistogramReport.getI18nString("Instances") + ": " + this.integerFormat.format(totalPermGenInstances) + ",   " + PdfHeapHistogramReport.getI18nString("Kilo-Octets") + ": " + this.integerFormat.format(totalPermGenBytes / 1024L), this.cellFont));
            this.writeHeader(false, false);
            this.writeClassInfo(permGen, totalPermGenInstances, totalPermGenBytes, false, false);
        }
    }

    private void writeHeader(boolean sourceDisplayed, boolean deltaDisplayed) throws DocumentException {
        List<String> headers = this.createHeaders(sourceDisplayed, deltaDisplayed);
        int[] relativeWidths = new int[headers.size()];
        Arrays.fill(relativeWidths, 0, headers.size(), 1);
        relativeWidths[0] = 6;
        if (sourceDisplayed) {
            relativeWidths[headers.size() - 1] = 6;
        }
        this.currentTable = PdfDocumentFactory.createPdfPTable(headers, relativeWidths);
    }

    private List<String> createHeaders(boolean sourceDisplayed, boolean deltaDisplayed) {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(PdfHeapHistogramReport.getI18nString("Classe"));
        headers.add(PdfHeapHistogramReport.getI18nString("Taille"));
        headers.add(PdfHeapHistogramReport.getI18nString("pct_taille"));
        if (deltaDisplayed) {
            headers.add(PdfHeapHistogramReport.getI18nString("Delta"));
        }
        headers.add(PdfHeapHistogramReport.getI18nString("Instances"));
        headers.add(PdfHeapHistogramReport.getI18nString("pct_instances"));
        if (sourceDisplayed) {
            headers.add(PdfHeapHistogramReport.getI18nString("Source"));
        }
        return headers;
    }

    private void writeClassInfo(List<HeapHistogram.ClassInfo> classHistogram, long totalInstances, long totalBytes, boolean sourceDisplayed, boolean deltaDisplayed) throws DocumentException {
        PdfPCell defaultCell = this.getDefaultCell();
        boolean odd = false;
        for (HeapHistogram.ClassInfo classInfo : classHistogram) {
            if (odd) {
                defaultCell.setGrayFill(0.97f);
            } else {
                defaultCell.setGrayFill(1.0f);
            }
            odd = !odd;
            this.writeClassInfoRow(classInfo, totalInstances, totalBytes, sourceDisplayed, deltaDisplayed);
        }
        this.document.add((Element)this.currentTable);
    }

    private void writeClassInfoRow(HeapHistogram.ClassInfo classInfo, long totalInstances, long totalBytes, boolean sourceDisplayed, boolean deltaDisplayed) {
        PdfPCell defaultCell = this.getDefaultCell();
        defaultCell.setHorizontalAlignment(0);
        this.addCell(classInfo.getName());
        defaultCell.setHorizontalAlignment(2);
        long bytes = classInfo.getBytes();
        long instancesCount = classInfo.getInstancesCount();
        this.addCell(this.integerFormat.format(bytes / 1024L));
        this.addCell(this.integerFormat.format(bytes * 100L / totalBytes));
        if (deltaDisplayed) {
            if (classInfo.getBytesDelta() > 0L) {
                this.addCell('+' + this.integerFormat.format(classInfo.getBytesDelta() / 1024L));
            } else {
                this.addCell(this.integerFormat.format(classInfo.getBytesDelta() / 1024L));
            }
        }
        this.addCell(this.integerFormat.format(instancesCount));
        this.addCell(this.integerFormat.format(instancesCount * 100L / totalInstances));
        defaultCell.setHorizontalAlignment(0);
        if (sourceDisplayed) {
            String source = classInfo.getSource();
            if (source == null) {
                this.addCell("");
            } else {
                this.addCell(source);
            }
        }
    }

    private static String getI18nString(String key) {
        return I18N.getString(key);
    }

    private PdfPCell getDefaultCell() {
        return this.currentTable.getDefaultCell();
    }

    private void addCell(String string) {
        this.currentTable.addCell(new Phrase(string, this.cellFont));
    }
}

