/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.AbstractInterceptor;
import net.bull.javamelody.Counter;
import net.bull.javamelody.LOG;
import net.bull.javamelody.MonitoringProxy;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;

public final class StrutsInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 6536441072950545240L;
    private static final Counter STRUTS_COUNTER = MonitoringProxy.getStrutsCounter();
    private static final boolean COUNTER_HIDDEN = Parameters.isCounterHidden(STRUTS_COUNTER.getName());
    private static final boolean DISABLED = Boolean.parseBoolean(Parameters.getParameter(Parameter.DISABLED));

    public StrutsInterceptor() {
        STRUTS_COUNTER.setDisplayed(!COUNTER_HIDDEN);
        STRUTS_COUNTER.setUsed(true);
        LOG.debug("struts interceptor initialized");
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        if (DISABLED || !STRUTS_COUNTER.isDisplayed()) {
            return invocation.invoke();
        }
        boolean systemError = false;
        try {
            String actionName = invocation.getInvocationContext().getName();
            STRUTS_COUNTER.bindContextIncludingCpu(actionName);
            String string = invocation.invoke();
            Object var6_6 = null;
            STRUTS_COUNTER.addRequestForCurrentContext(systemError);
            return string;
        }
        catch (Error e) {
            try {
                systemError = true;
                throw e;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                STRUTS_COUNTER.addRequestForCurrentContext(systemError);
                throw throwable;
            }
        }
    }
}

