/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.List;
import javax.management.JMException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import net.bull.javamelody.Collector;
import net.bull.javamelody.CollectorServer;
import net.bull.javamelody.ConnectionInformations;
import net.bull.javamelody.DatabaseInformations;
import net.bull.javamelody.HeapHistogram;
import net.bull.javamelody.HtmlConnectionInformationsReport;
import net.bull.javamelody.HtmlCoreReport;
import net.bull.javamelody.HtmlCounterReport;
import net.bull.javamelody.HtmlDatabaseInformationsReport;
import net.bull.javamelody.HtmlHeapHistogramReport;
import net.bull.javamelody.HtmlJndiTreeReport;
import net.bull.javamelody.HtmlMBeansReport;
import net.bull.javamelody.HtmlProcessInformationsReport;
import net.bull.javamelody.HtmlSessionInformationsReport;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.Period;
import net.bull.javamelody.ProcessInformations;
import net.bull.javamelody.Range;
import net.bull.javamelody.SessionInformations;
import net.bull.javamelody.TransportFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HtmlReport {
    private static final String SCRIPT_BEGIN = "<script type='text/javascript'>";
    private static final String SCRIPT_END = "</script>";
    private final Collector collector;
    private final CollectorServer collectorServer;
    private final Range range;
    private final Writer writer;
    private final HtmlCoreReport htmlCoreReport;

    HtmlReport(Collector collector, CollectorServer collectorServer, List<JavaInformations> javaInformationsList, Range range, Writer writer) {
        assert (collector != null);
        assert (javaInformationsList != null && !javaInformationsList.isEmpty());
        assert (range != null);
        assert (writer != null);
        this.collector = collector;
        this.collectorServer = collectorServer;
        this.range = range;
        this.writer = writer;
        this.htmlCoreReport = new HtmlCoreReport(collector, collectorServer, javaInformationsList, range, writer);
    }

    HtmlReport(Collector collector, CollectorServer collectorServer, List<JavaInformations> javaInformationsList, Period period, Writer writer) {
        this(collector, collectorServer, javaInformationsList, period.getRange(), writer);
    }

    void toHtml(String message, String anchorNameForRedirect) throws IOException {
        this.writeHtmlHeader();
        this.htmlCoreReport.toHtml(message, anchorNameForRedirect);
        this.writeHtmlFooter();
    }

    void writeLastShutdown() throws IOException {
        this.writeHtmlHeader(false, true);
        this.htmlCoreReport.toHtml(null, null);
        this.writeHtmlFooter();
    }

    static void writeAddAndRemoveApplicationLinks(String currentApplication, Writer writer) throws IOException {
        HtmlCoreReport.writeAddAndRemoveApplicationLinks(currentApplication, writer);
    }

    void writeAllCurrentRequestsAsPart(boolean withoutHeaders) throws IOException {
        if (withoutHeaders) {
            this.htmlCoreReport.writeAllCurrentRequestsAsPart(false);
        } else {
            this.writeHtmlHeader();
            this.htmlCoreReport.writeAllCurrentRequestsAsPart(true);
            this.writeHtmlFooter();
        }
    }

    void writeAllThreadsAsPart() throws IOException {
        this.writeHtmlHeader();
        this.htmlCoreReport.writeAllThreadsAsPart();
        this.writeHtmlFooter();
    }

    void writeThreadsDump() throws IOException {
        this.htmlCoreReport.writeThreadsDump();
    }

    void writeCounterSummaryPerClass(String counterName, String requestId) throws IOException {
        this.writeHtmlHeader();
        this.htmlCoreReport.writeCounterSummaryPerClass(counterName, requestId);
        this.writeHtmlFooter();
    }

    void writeHtmlHeader() throws IOException {
        this.writeHtmlHeader(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHtmlHeader(boolean includeSlider, boolean includeCssInline) throws IOException {
        this.writeln("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
        this.writer.write("<html><head><title>" + I18N.getFormattedString("Monitoring_sur", this.collector.getApplication()) + "</title>");
        this.writeln("");
        if (includeCssInline) {
            this.writeln("<style type='text/css'>");
            BufferedInputStream in = new BufferedInputStream(this.getClass().getResourceAsStream(Parameters.getResourcePath("monitoring.css")));
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                TransportFormat.pump(in, out);
            }
            finally {
                ((InputStream)in).close();
            }
            this.writer.write(out.toString());
            this.writeln("</style>");
        } else {
            this.writeln("<link rel='stylesheet' href='?resource=monitoring.css' type='text/css'/>");
        }
        this.writeln("<link type='image/png' rel='shortcut icon' href='?resource=systemmonitor.png' />");
        this.writeln("<script type='text/javascript' src='?resource=resizable_tables.js'></script>");
        this.writeln("<script type='text/javascript' src='?resource=sorttable.js'></script>");
        this.writeln("<script type='text/javascript' src='?resource=prototype.js'></script>");
        this.writeln("<script type='text/javascript' src='?resource=effects.js'></script>");
        if (includeSlider) {
            this.writeln("<script type='text/javascript' src='?resource=slider.js'></script>");
        }
        this.writeJavaScript();
        this.writeln("</head><body>");
    }

    void writeHtmlFooter() throws IOException {
        String analyticsId = Parameters.getParameter(Parameter.ANALYTICS_ID);
        if (analyticsId != null) {
            this.writer.write(SCRIPT_BEGIN);
            this.writer.write("var gaJsHost = (('https:' == document.location.protocol) ? 'https://ssl.' : 'http://www.');\n");
            this.writer.write("document.write(unescape(\"%3Cscript src='\" + gaJsHost + \"google-analytics.com/ga.js' type='text/javascript'%3E%3C/script%3E\"));\n");
            this.writer.write(SCRIPT_END);
            this.writer.write(SCRIPT_BEGIN);
            this.writer.write(" try{\n");
            this.writer.write("var pageTracker = _gat._getTracker('" + analyticsId + "');\n");
            this.writer.write("pageTracker._trackPageview();\n");
            this.writer.write("} catch(err) {}\n");
            this.writer.write(SCRIPT_END);
            this.writer.write(10);
        }
        this.writeln("</body></html>");
    }

    private void writeJavaScript() throws IOException {
        this.writeln(SCRIPT_BEGIN);
        this.writeln("function showHide(id){");
        this.writeln("  if (document.getElementById(id).style.display=='none') {");
        this.writeln("    if (document.getElementById(id + 'Img') != null) {");
        this.writeln("      document.getElementById(id + 'Img').src='?resource=bullets/minus.png';");
        this.writeln("    }");
        this.writeln("    Effect.SlideDown(id, { duration: 0.5 });");
        this.writeln("  } else {");
        this.writeln("    if (document.getElementById(id + 'Img') != null) {");
        this.writeln("      document.getElementById(id + 'Img').src='?resource=bullets/plus.png';");
        this.writeln("    }");
        this.writeln("    Effect.SlideUp(id, { duration: 0.5 });");
        this.writeln("  }");
        this.writeln("}");
        this.writeln(SCRIPT_END);
    }

    void writeMessageIfNotNull(String message, String partToRedirectTo) throws IOException {
        this.htmlCoreReport.writeMessageIfNotNull(message, partToRedirectTo, null);
    }

    void writeRequestAndGraphDetail(String graphName) throws IOException {
        this.writeHtmlHeader(true, false);
        this.writeln("<div align='center'>");
        this.htmlCoreReport.writeRefreshAndPeriodLinks(graphName, "graph");
        this.writeln("</div>");
        new HtmlCounterReport.HtmlCounterRequestGraphReport(this.range, this.writer).writeRequestAndGraphDetail(this.collector, this.collectorServer, graphName);
        this.writeHtmlFooter();
    }

    void writeRequestUsages(String graphName) throws IOException {
        this.writeHtmlHeader(true, false);
        this.writeln("<div align='center'>");
        this.htmlCoreReport.writeRefreshAndPeriodLinks(graphName, "usages");
        this.writeln("</div>");
        new HtmlCounterReport.HtmlCounterRequestGraphReport(this.range, this.writer).writeRequestUsages(this.collector, graphName);
        this.writeHtmlFooter();
    }

    void writeSessions(List<SessionInformations> sessionsInformations, String message, String sessionsPart) throws IOException {
        assert (sessionsInformations != null);
        this.writeHtmlHeader();
        this.writeMessageIfNotNull(message, sessionsPart);
        new HtmlSessionInformationsReport(this.writer).toHtml(sessionsInformations);
        this.writeHtmlFooter();
    }

    void writeSessionDetail(String sessionId, SessionInformations sessionInformations) throws IOException {
        assert (sessionId != null);
        this.writeHtmlHeader();
        new HtmlSessionInformationsReport(this.writer).writeSessionDetails(sessionId, sessionInformations);
        this.writeHtmlFooter();
    }

    void writeHeapHistogram(HeapHistogram heapHistogram, String message, String heapHistoPart) throws IOException {
        assert (heapHistogram != null);
        this.writeHtmlHeader();
        this.writeMessageIfNotNull(message, heapHistoPart);
        new HtmlHeapHistogramReport(heapHistogram, this.writer).toHtml();
        this.writeHtmlFooter();
    }

    void writeProcesses(List<ProcessInformations> processInformationsList) throws IOException {
        assert (processInformationsList != null);
        this.writeHtmlHeader();
        new HtmlProcessInformationsReport(processInformationsList, this.writer).toHtml();
        this.writeHtmlFooter();
    }

    void writeDatabase(DatabaseInformations databaseInformations) throws IOException {
        assert (databaseInformations != null);
        this.writeHtmlHeader();
        new HtmlDatabaseInformationsReport(databaseInformations, this.writer).toHtml();
        this.writeHtmlFooter();
    }

    void writeConnections(List<ConnectionInformations> connectionInformationsList, boolean withoutHeaders) throws IOException {
        assert (connectionInformationsList != null);
        HtmlConnectionInformationsReport htmlConnectionInformationsReport = new HtmlConnectionInformationsReport(connectionInformationsList, this.writer);
        if (withoutHeaders) {
            htmlConnectionInformationsReport.writeConnections();
        } else {
            this.writeHtmlHeader();
            htmlConnectionInformationsReport.toHtml();
            this.writeHtmlFooter();
        }
    }

    void writeJndi(String path) throws IOException, NamingException {
        this.writeHtmlHeader();
        new HtmlJndiTreeReport(new InitialContext(), path, this.writer).toHtml();
        this.writeHtmlFooter();
    }

    void writeMBeans(boolean withoutHeaders) throws IOException, JMException {
        if (withoutHeaders) {
            new HtmlMBeansReport(this.writer).writeTree();
        } else {
            this.writeHtmlHeader();
            new HtmlMBeansReport(this.writer).toHtml();
            this.writeHtmlFooter();
        }
    }

    private void writeln(String html) throws IOException {
        I18N.writelnTo(html, this.writer);
    }
}

