/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import javax.faces.component.ActionSource2;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import net.bull.javamelody.Counter;
import net.bull.javamelody.LOG;
import net.bull.javamelody.MonitoringProxy;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;

public class JsfActionListener
implements ActionListener {
    private static final Counter JSF_COUNTER = MonitoringProxy.getJsfCounter();
    private static final boolean COUNTER_HIDDEN = Parameters.isCounterHidden(JSF_COUNTER.getName());
    private static final boolean DISABLED = Boolean.parseBoolean(Parameters.getParameter(Parameter.DISABLED));
    private final ActionListener delegateActionListener;

    public JsfActionListener(ActionListener delegateActionListener) {
        JSF_COUNTER.setDisplayed(!COUNTER_HIDDEN);
        JSF_COUNTER.setUsed(true);
        LOG.debug("jsf action listener initialized");
        this.delegateActionListener = delegateActionListener;
    }

    public void processAction(ActionEvent event) {
        if (DISABLED || !JSF_COUNTER.isDisplayed()) {
            this.delegateActionListener.processAction(event);
        }
        boolean systemError = false;
        try {
            String actionName = this.getRequestName(event);
            JSF_COUNTER.bindContextIncludingCpu(actionName);
            this.delegateActionListener.processAction(event);
        }
        catch (Error e) {
            systemError = true;
            throw e;
        }
        finally {
            JSF_COUNTER.addRequestForCurrentContext(systemError);
        }
    }

    protected String getRequestName(ActionEvent event) {
        ActionSource2 actionSource;
        String actionName = event.getComponent() instanceof ActionSource2 ? ((actionSource = (ActionSource2)event.getComponent()).getActionExpression() != null ? actionSource.getActionExpression().getExpressionString() : actionSource.getClass().getName()) : event.getComponent().getClass().getName();
        return actionName;
    }
}

