/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.io.IOException;
import java.util.Locale;
import net.bull.javamelody.I18N;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum PdfFonts {
    NORMAL(PdfFonts.getFont(8.0f, 0)),
    BOLD(PdfFonts.getFont(8.0f, 1)),
    PARAGRAPH_TITLE(PdfFonts.getFont(10.0f, 1)),
    TABLE_CELL(PdfFonts.getFont(5.5f, 0)),
    BOLD_CELL(PdfFonts.getFont(5.5f, 1)),
    BLUE(PdfFonts.getFont(5.5f, 0)),
    INFO_CELL(PdfFonts.getFont(5.5f, 0)),
    WARNING_CELL(PdfFonts.getFont(5.5f, 1)),
    SEVERE_CELL(PdfFonts.getFont(5.5f, 1)),
    TABLE_HEADER(PdfFonts.getFont(5.5f, 1));

    private final transient Font font;
    private transient Font chineseFont;

    private PdfFonts(Font font) {
        this.font = font;
    }

    Font getFont() {
        if (Locale.CHINESE.getLanguage().equals(I18N.getResourceBundle().getLocale().getLanguage())) {
            return this.getChineseFont();
        }
        return this.font;
    }

    private Font getChineseFont() {
        if (this.chineseFont == null) {
            try {
                BaseFont bfChinese = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
                this.chineseFont = new Font(bfChinese, this.font.getSize(), this.font.getStyle());
            }
            catch (DocumentException e) {
                throw new IllegalStateException(e);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.chineseFont;
    }

    private static Font getFont(float size, int style) {
        return FontFactory.getFont((String)"Helvetica", (float)size, (int)style);
    }

    static {
        PdfFonts.BLUE.font.setColor(Color.BLUE);
        PdfFonts.INFO_CELL.font.setColor(Color.GREEN);
        PdfFonts.WARNING_CELL.font.setColor(Color.ORANGE);
        PdfFonts.SEVERE_CELL.font.setColor(Color.RED);
    }
}

