/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterRequest;
import net.bull.javamelody.ThreadInformations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CounterRequestContext
implements CounterRequest.ICounterRequestContext,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Long ONE = 1L;
    private final transient Counter parentCounter;
    private final CounterRequestContext parentContext;
    private CounterRequestContext currentChildContext;
    private final String requestName;
    private final String completeRequestName;
    private final String remoteUser;
    private final long threadId;
    private final long startTime;
    private final long startCpuTime;
    private int childHits;
    private int childDurationsSum;
    private Map<String, Long> childRequestsExecutionsByRequestId;

    CounterRequestContext(Counter parentCounter, CounterRequestContext parentContext, String requestName, String completeRequestName, String remoteUser, long startCpuTime) {
        this(parentCounter, parentContext, requestName, completeRequestName, remoteUser, Thread.currentThread().getId(), System.currentTimeMillis(), startCpuTime);
        if (parentContext != null) {
            parentContext.setCurrentChildContext(this);
        }
    }

    private CounterRequestContext(Counter parentCounter, CounterRequestContext parentContext, String requestName, String completeRequestName, String remoteUser, long threadId, long startTime, long startCpuTime) {
        assert (parentCounter != null);
        assert (requestName != null);
        assert (completeRequestName != null);
        this.parentCounter = parentCounter;
        this.parentContext = parentContext;
        this.requestName = requestName;
        this.completeRequestName = completeRequestName;
        this.remoteUser = remoteUser;
        this.threadId = threadId;
        this.startTime = startTime;
        this.startCpuTime = startCpuTime;
    }

    Counter getParentCounter() {
        return this.parentCounter;
    }

    CounterRequestContext getParentContext() {
        return this.parentContext;
    }

    String getRequestName() {
        return this.requestName;
    }

    String getCompleteRequestName() {
        return this.completeRequestName;
    }

    String getRemoteUser() {
        return this.remoteUser;
    }

    long getThreadId() {
        return this.threadId;
    }

    int getDuration(long timeOfSnapshot) {
        return (int)Math.max(timeOfSnapshot - this.startTime, 0L);
    }

    int getCpuTime() {
        if (this.startCpuTime < 0L) {
            return -1;
        }
        int cpuTime = (int)(ThreadInformations.getThreadCpuTime(this.getThreadId()) - this.startCpuTime) / 1000000;
        return Math.max(cpuTime, 0);
    }

    @Override
    public int getChildHits() {
        return this.childHits;
    }

    @Override
    public int getChildDurationsSum() {
        return this.childDurationsSum;
    }

    @Override
    public Map<String, Long> getChildRequestsExecutionsByRequestId() {
        if (this.childRequestsExecutionsByRequestId == null) {
            return Collections.emptyMap();
        }
        return this.childRequestsExecutionsByRequestId;
    }

    int getTotalChildHits() {
        int result = this.getChildHits();
        for (CounterRequestContext childContext = this.getCurrentChildContext(); childContext != null; childContext = childContext.getCurrentChildContext()) {
            result += childContext.getChildHits();
        }
        return result;
    }

    int getTotalChildDurationsSum() {
        int result = this.getChildDurationsSum();
        for (CounterRequestContext childContext = this.getCurrentChildContext(); childContext != null; childContext = childContext.getCurrentChildContext()) {
            result += childContext.getChildDurationsSum();
        }
        return result;
    }

    List<CounterRequestContext> getChildContexts() {
        CounterRequestContext childContext = this.getCurrentChildContext();
        List childContexts = childContext == null ? Collections.emptyList() : new ArrayList(2);
        while (childContext != null) {
            childContexts.add(childContext);
            childContext = childContext.getCurrentChildContext();
        }
        return Collections.unmodifiableList(childContexts);
    }

    private CounterRequestContext getCurrentChildContext() {
        return this.currentChildContext;
    }

    private void setCurrentChildContext(CounterRequestContext currentChildContext) {
        this.currentChildContext = currentChildContext;
    }

    void addChildRequest(Counter childCounter, String request, String requestId, long duration, boolean systemError, int responseSize) {
        if (this.parentContext != null && this.parentCounter.getName().equals(this.parentContext.getParentCounter().getChildCounterName())) {
            ++this.childHits;
            this.childDurationsSum = (int)((long)this.childDurationsSum + duration);
        }
        if (this.parentContext == null) {
            this.addChildRequestForDrillDown(requestId);
        } else {
            this.parentContext.addChildRequestForDrillDown(requestId);
        }
    }

    private void addChildRequestForDrillDown(String requestId) {
        Long nbExecutions;
        if (this.childRequestsExecutionsByRequestId == null) {
            this.childRequestsExecutionsByRequestId = new LinkedHashMap<String, Long>();
        }
        nbExecutions = (nbExecutions = this.childRequestsExecutionsByRequestId.get(requestId)) == null ? ONE : Long.valueOf(nbExecutions + 1L);
        this.childRequestsExecutionsByRequestId.put(requestId, nbExecutions);
    }

    void closeChildContext() {
        CounterRequestContext childContext = this.getCurrentChildContext();
        this.childHits += childContext.getChildHits();
        this.childDurationsSum += childContext.getChildDurationsSum();
        this.setCurrentChildContext(null);
    }

    public CounterRequestContext clone() {
        assert (this.getParentContext() == null);
        return this.clone(null);
    }

    private CounterRequestContext clone(CounterRequestContext parentContextClone) {
        Counter counter = this.getParentCounter();
        CounterRequestContext clone = new CounterRequestContext(counter, parentContextClone, this.getRequestName(), this.getCompleteRequestName(), this.getRemoteUser(), this.getThreadId(), this.startTime, this.startCpuTime);
        clone.childHits = this.getChildHits();
        clone.childDurationsSum = this.getChildDurationsSum();
        CounterRequestContext childContext = this.getCurrentChildContext();
        if (childContext != null) {
            clone.currentChildContext = childContext.clone(clone);
        }
        if (this.childRequestsExecutionsByRequestId != null) {
            clone.childRequestsExecutionsByRequestId = new LinkedHashMap<String, Long>(this.childRequestsExecutionsByRequestId);
        }
        return clone;
    }

    private Object readResolve() {
        throw new IllegalStateException(this.getClass() + " must not be serialized");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[parentCounter=" + this.getParentCounter().getName() + ", completeRequestName=" + this.getCompleteRequestName() + ", threadId=" + this.getThreadId() + ", startTime=" + this.startTime + ", childHits=" + this.getChildHits() + ", childDurationsSum=" + this.getChildDurationsSum() + ", childContexts=" + this.getChildContexts() + ']';
    }
}

