/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.bull.javamelody.Collector;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterError;
import net.bull.javamelody.CounterServletResponseWrapper;
import net.bull.javamelody.FilterContext;
import net.bull.javamelody.GWTRequestWrapper;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.JspWrapper;
import net.bull.javamelody.LOG;
import net.bull.javamelody.MonitoringController;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.ThreadInformations;

public class MonitoringFilter
implements Filter {
    private static boolean instanceCreated;
    private static final List<String> CONTEXT_PATHS;
    private boolean instanceEnabled;
    private Counter httpCounter;
    private Counter errorCounter;
    private boolean monitoringDisabled;
    private boolean logEnabled;
    private Pattern urlExcludePattern;
    private Pattern allowedAddrPattern;
    private FilterContext filterContext;
    private FilterConfig filterConfig;
    private String monitoringUrl;

    public MonitoringFilter() {
        if (instanceCreated) {
            this.instanceEnabled = false;
        } else {
            this.instanceEnabled = true;
            MonitoringFilter.setInstanceCreated(true);
        }
    }

    private static void setInstanceCreated(boolean newInstanceCreated) {
        instanceCreated = newInstanceCreated;
    }

    public void init(FilterConfig config) throws ServletException {
        String contextPath = Parameters.getContextPath(config.getServletContext());
        if (!this.instanceEnabled) {
            if (!CONTEXT_PATHS.contains(contextPath)) {
                this.instanceEnabled = true;
            } else {
                return;
            }
        }
        CONTEXT_PATHS.add(contextPath);
        this.filterConfig = config;
        Parameters.initialize(config);
        this.monitoringDisabled = Boolean.parseBoolean(Parameters.getParameter(Parameter.DISABLED));
        if (this.monitoringDisabled) {
            return;
        }
        LOG.debug("JavaMelody filter init started");
        this.filterContext = new FilterContext();
        Collector collector = this.filterContext.getCollector();
        this.httpCounter = collector.getCounterByName("http");
        this.errorCounter = collector.getCounterByName("error");
        this.logEnabled = Boolean.parseBoolean(Parameters.getParameter(Parameter.LOG));
        if (Parameters.getParameter(Parameter.URL_EXCLUDE_PATTERN) != null) {
            this.urlExcludePattern = Pattern.compile(Parameters.getParameter(Parameter.URL_EXCLUDE_PATTERN));
        }
        if (Parameters.getParameter(Parameter.ALLOWED_ADDR_PATTERN) != null) {
            this.allowedAddrPattern = Pattern.compile(Parameters.getParameter(Parameter.ALLOWED_ADDR_PATTERN));
        }
        LOG.debug("JavaMelody filter init done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.monitoringDisabled || !this.instanceEnabled) {
            return;
        }
        try {
            if (this.filterContext != null) {
                this.filterContext.destroy();
            }
        }
        finally {
            this.httpCounter = null;
            this.errorCounter = null;
            this.urlExcludePattern = null;
            this.allowedAddrPattern = null;
            this.filterConfig = null;
            this.filterContext = null;
        }
        LOG.debug("JavaMelody filter destroy done");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse) || this.monitoringDisabled || !this.instanceEnabled) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (httpRequest.getRequestURI().equals(this.getMonitoringUrl(httpRequest))) {
            this.doMonitoring(httpRequest, httpResponse);
            return;
        }
        if (!this.httpCounter.isDisplayed() || this.isRequestExcluded((HttpServletRequest)request)) {
            chain.doFilter(request, response);
            return;
        }
        this.doFilter(chain, httpRequest, httpResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void doFilter(FilterChain chain, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        CounterServletResponseWrapper wrappedResponse = new CounterServletResponseWrapper(httpResponse);
        Object wrappedRequest = JspWrapper.createHttpRequestWrapper(httpRequest, (HttpServletResponse)wrappedResponse);
        if (httpRequest.getContentType() != null && httpRequest.getContentType().startsWith("text/x-gwt-rpc")) {
            wrappedRequest = new GWTRequestWrapper((HttpServletRequest)wrappedRequest);
        }
        long start = System.currentTimeMillis();
        long startCpuTime = ThreadInformations.getCurrentThreadCpuTime();
        boolean systemError = false;
        Throwable systemException = null;
        String requestName = this.getRequestName((HttpServletRequest)wrappedRequest);
        String completeRequestName = MonitoringFilter.getCompleteRequestName(wrappedRequest, true);
        try {
            try {
                JdbcWrapper.ACTIVE_THREAD_COUNT.incrementAndGet();
                this.httpCounter.bindContext(requestName, completeRequestName, httpRequest.getRemoteUser(), startCpuTime);
                httpRequest.setAttribute("javamelody.request", (Object)completeRequestName);
                CounterError.bindRequest(httpRequest);
                chain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)wrappedResponse);
                wrappedResponse.flushBuffer();
            }
            catch (Throwable t) {
                systemException = t;
                MonitoringFilter.throwException(t);
                Object var16_13 = null;
                try {}
                catch (Throwable throwable) {
                    Object var23_30 = null;
                    this.httpCounter.unbindContext();
                    CounterError.unbindRequest();
                    throw throwable;
                }
                long duration = Math.max(System.currentTimeMillis() - start, 0L);
                long cpuUsedMillis = (ThreadInformations.getCurrentThreadCpuTime() - startCpuTime) / 1000000L;
                JdbcWrapper.ACTIVE_THREAD_COUNT.decrementAndGet();
                this.putUserInfoInSession(httpRequest);
                if (systemException != null) {
                    systemError = true;
                    StringWriter stackTrace = new StringWriter(200);
                    systemException.printStackTrace(new PrintWriter(stackTrace));
                    this.errorCounter.addRequestForSystemError(systemException.toString(), duration, cpuUsedMillis, stackTrace.toString());
                } else if (wrappedResponse.getCurrentStatus() >= 400) {
                    systemError = true;
                    this.errorCounter.addRequestForSystemError("Error" + wrappedResponse.getCurrentStatus(), duration, cpuUsedMillis, null);
                }
                int responseSize = wrappedResponse.getDataLength();
                if (wrappedResponse.getCurrentStatus() == 404) {
                    requestName = "Error404";
                }
                this.httpCounter.addRequest(requestName, duration, cpuUsedMillis, systemError, responseSize);
                this.log(httpRequest, requestName, duration, systemError, responseSize);
                Object var23_29 = null;
                this.httpCounter.unbindContext();
                CounterError.unbindRequest();
                return;
            }
            Object var16_12 = null;
            try {
                long duration = Math.max(System.currentTimeMillis() - start, 0L);
                long cpuUsedMillis = (ThreadInformations.getCurrentThreadCpuTime() - startCpuTime) / 1000000L;
                JdbcWrapper.ACTIVE_THREAD_COUNT.decrementAndGet();
                this.putUserInfoInSession(httpRequest);
                if (systemException != null) {
                    systemError = true;
                    StringWriter stackTrace = new StringWriter(200);
                    systemException.printStackTrace(new PrintWriter(stackTrace));
                    this.errorCounter.addRequestForSystemError(systemException.toString(), duration, cpuUsedMillis, stackTrace.toString());
                } else if (wrappedResponse.getCurrentStatus() >= 400) {
                    systemError = true;
                    this.errorCounter.addRequestForSystemError("Error" + wrappedResponse.getCurrentStatus(), duration, cpuUsedMillis, null);
                }
                int responseSize = wrappedResponse.getDataLength();
                if (wrappedResponse.getCurrentStatus() == 404) {
                    requestName = "Error404";
                }
                this.httpCounter.addRequest(requestName, duration, cpuUsedMillis, systemError, responseSize);
                this.log(httpRequest, requestName, duration, systemError, responseSize);
                Object var23_27 = null;
                this.httpCounter.unbindContext();
                CounterError.unbindRequest();
                return;
            }
            catch (Throwable throwable) {
                Object var23_28 = null;
                this.httpCounter.unbindContext();
                CounterError.unbindRequest();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            Object var16_14 = null;
            try {}
            catch (Throwable throwable2) {
                Object var23_32 = null;
                this.httpCounter.unbindContext();
                CounterError.unbindRequest();
                throw throwable2;
            }
            long duration = Math.max(System.currentTimeMillis() - start, 0L);
            long cpuUsedMillis = (ThreadInformations.getCurrentThreadCpuTime() - startCpuTime) / 1000000L;
            JdbcWrapper.ACTIVE_THREAD_COUNT.decrementAndGet();
            this.putUserInfoInSession(httpRequest);
            if (systemException != null) {
                systemError = true;
                StringWriter stackTrace = new StringWriter(200);
                systemException.printStackTrace(new PrintWriter(stackTrace));
                this.errorCounter.addRequestForSystemError(systemException.toString(), duration, cpuUsedMillis, stackTrace.toString());
            } else if (wrappedResponse.getCurrentStatus() >= 400) {
                systemError = true;
                this.errorCounter.addRequestForSystemError("Error" + wrappedResponse.getCurrentStatus(), duration, cpuUsedMillis, null);
            }
            int responseSize = wrappedResponse.getDataLength();
            if (wrappedResponse.getCurrentStatus() == 404) {
                requestName = "Error404";
            }
            this.httpCounter.addRequest(requestName, duration, cpuUsedMillis, systemError, responseSize);
            this.log(httpRequest, requestName, duration, systemError, responseSize);
            Object var23_31 = null;
            this.httpCounter.unbindContext();
            CounterError.unbindRequest();
            throw throwable;
        }
    }

    protected String getRequestName(HttpServletRequest request) {
        return MonitoringFilter.getCompleteRequestName(request, false);
    }

    protected final String getMonitoringUrl(HttpServletRequest httpRequest) {
        if (this.monitoringUrl == null) {
            String parameterValue = Parameters.getParameter(Parameter.MONITORING_PATH);
            this.monitoringUrl = parameterValue == null ? httpRequest.getContextPath() + "/monitoring" : httpRequest.getContextPath() + parameterValue;
        }
        return this.monitoringUrl;
    }

    private void putUserInfoInSession(HttpServletRequest httpRequest) {
        String remoteUser;
        HttpSession session = httpRequest.getSession(false);
        if (session == null) {
            return;
        }
        if (session.getAttribute("javamelody.country") == null) {
            Locale locale = httpRequest.getLocale();
            if (locale.getCountry().length() > 0) {
                session.setAttribute("javamelody.country", (Object)locale.getCountry());
            } else {
                session.setAttribute("javamelody.country", (Object)locale.getLanguage());
            }
        }
        if (session.getAttribute("javamelody.remoteAddr") == null) {
            String forwardedFor = httpRequest.getHeader("X-Forwarded-For");
            String remoteAddr = forwardedFor == null ? httpRequest.getRemoteAddr() : httpRequest.getRemoteAddr() + " forwarded for " + forwardedFor;
            session.setAttribute("javamelody.remoteAddr", (Object)remoteAddr);
        }
        if (session.getAttribute("javamelody.remoteUser") == null && (remoteUser = httpRequest.getRemoteUser()) != null) {
            session.setAttribute("javamelody.remoteUser", (Object)remoteUser);
        }
    }

    private void doMonitoring(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        if (this.isRequestNotAllowed(httpRequest)) {
            LOG.debug("Forbidden access to monitoring from " + httpRequest.getRemoteAddr());
            httpResponse.sendError(403, "Forbidden access");
            return;
        }
        Collector collector = this.filterContext.getCollector();
        MonitoringController monitoringController = new MonitoringController(collector, null);
        monitoringController.executeActionIfNeeded(httpRequest);
        JavaInformations javaInformations = MonitoringController.isJavaInformationsNeeded(httpRequest) ? new JavaInformations(this.filterConfig.getServletContext(), true) : null;
        monitoringController.doReport(httpRequest, httpResponse, Collections.singletonList(javaInformations));
        if ("stop".equalsIgnoreCase(httpRequest.getParameter("collector"))) {
            for (Counter counter : collector.getCounters()) {
                counter.clear();
            }
            if (!collector.isStopped()) {
                LOG.debug("Stopping the javamelody thread in this webapp, because a collector server from " + httpRequest.getRemoteAddr() + " wants to collect the data itself");
                if (this.filterContext.getTimer() != null) {
                    this.filterContext.getTimer().cancel();
                }
                collector.stop();
            }
        }
    }

    private static String getCompleteRequestName(HttpServletRequest httpRequest, boolean includeQueryString) {
        String tmp = httpRequest.getRequestURI().substring(httpRequest.getContextPath().length());
        int lastIndexOfSemiColon = tmp.lastIndexOf(59);
        if (lastIndexOfSemiColon != -1) {
            tmp = tmp.substring(0, lastIndexOfSemiColon);
        }
        String method = "XMLHttpRequest".equals(httpRequest.getHeader("X-Requested-With")) ? "ajax " + httpRequest.getMethod() : httpRequest.getMethod();
        if (!includeQueryString) {
            if (httpRequest instanceof GWTRequestWrapper) {
                GWTRequestWrapper wrapper = (GWTRequestWrapper)httpRequest;
                return tmp + '.' + wrapper.getGwtRpcMethodName() + " GWT-RPC";
            }
            return tmp + ' ' + method;
        }
        String queryString = httpRequest.getQueryString();
        if (queryString == null) {
            return tmp + ' ' + method;
        }
        return tmp + '?' + queryString + ' ' + method;
    }

    private boolean isRequestExcluded(HttpServletRequest httpRequest) {
        return this.urlExcludePattern != null && this.urlExcludePattern.matcher(httpRequest.getRequestURI().substring(httpRequest.getContextPath().length())).matches();
    }

    private boolean isRequestNotAllowed(HttpServletRequest httpRequest) {
        return this.allowedAddrPattern != null && !this.allowedAddrPattern.matcher(httpRequest.getRemoteAddr()).matches();
    }

    protected void log(HttpServletRequest httpRequest, String requestName, long duration, boolean systemError, int responseSize) {
        if (!this.logEnabled) {
            return;
        }
        String filterName = this.filterConfig.getFilterName();
        LOG.logHttpRequest(httpRequest, requestName, duration, systemError, responseSize, filterName);
    }

    private static void throwException(Throwable t) throws IOException, ServletException {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof ServletException) {
            throw (ServletException)t;
        }
        throw new ServletException(t.getMessage(), t);
    }

    FilterContext getFilterContext() {
        return this.filterContext;
    }

    static {
        CONTEXT_PATHS = new ArrayList<String>();
    }
}

