/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.util.Arrays;
import java.util.List;
import net.bull.javamelody.DatabaseInformations;
import net.bull.javamelody.PdfDocumentFactory;
import net.bull.javamelody.PdfFonts;

class PdfDatabaseInformationsReport {
    private final DatabaseInformations databaseInformations;
    private final Document document;
    private final Font cellFont = PdfFonts.TABLE_CELL.getFont();
    private PdfPTable currentTable;

    PdfDatabaseInformationsReport(DatabaseInformations databaseInformations, Document document) {
        assert (databaseInformations != null);
        assert (document != null);
        this.databaseInformations = databaseInformations;
        this.document = document;
    }

    void toPdf() throws DocumentException {
        String[][] values = this.databaseInformations.getResult();
        String[] headerValues = values[0];
        this.writeTableHeaders(headerValues);
        int index = 0;
        PdfPCell defaultCell = this.getDefaultCell();
        boolean odd = false;
        for (String[] row : values) {
            if (index == 0) {
                ++index;
                continue;
            }
            if (odd) {
                defaultCell.setGrayFill(0.97f);
            } else {
                defaultCell.setGrayFill(1.0f);
            }
            odd = !odd;
            this.writeRow(row);
            ++index;
        }
        this.document.add((Element)this.currentTable);
    }

    private void writeTableHeaders(String[] headerValues) throws DocumentException {
        List<String> headers = Arrays.asList(headerValues);
        int[] relativeWidths = new int[headers.size()];
        Arrays.fill(relativeWidths, 0, headers.size(), 1);
        this.currentTable = PdfDocumentFactory.createPdfPTable(headers, relativeWidths);
    }

    private void writeRow(String[] row) {
        PdfPCell defaultCell = this.getDefaultCell();
        defaultCell.setVerticalAlignment(4);
        for (String value : row) {
            if (value == null || value.length() == 0) {
                this.addCell("");
                continue;
            }
            if (PdfDatabaseInformationsReport.isNumber(value)) {
                defaultCell.setHorizontalAlignment(2);
            } else {
                defaultCell.setHorizontalAlignment(0);
            }
            this.addCell(value);
        }
    }

    private static boolean isNumber(String text) {
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (Character.isDigit(c) || c == '.') continue;
            return false;
        }
        return true;
    }

    private PdfPCell getDefaultCell() {
        return this.currentTable.getDefaultCell();
    }

    private void addCell(String string) {
        this.currentTable.addCell(new Phrase(string, this.cellFont));
    }
}

