/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.bull.javamelody.Action;
import net.bull.javamelody.Collector;
import net.bull.javamelody.ConnectionInformations;
import net.bull.javamelody.Counter;
import net.bull.javamelody.DatabaseInformations;
import net.bull.javamelody.HeapHistogram;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.LabradorRetriever;
import net.bull.javamelody.ProcessInformations;
import net.bull.javamelody.SessionInformations;
import net.bull.javamelody.SessionListener;
import net.bull.javamelody.ThreadInformations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RemoteCollector {
    private final String application;
    private List<URL> urls;
    private Collector collector;
    private List<JavaInformations> javaInformationsList;
    private boolean aggregationDisabled;

    RemoteCollector(String application, List<URL> urls) {
        assert (application != null);
        assert (urls != null);
        this.application = application;
        this.urls = urls;
    }

    String collectData() throws IOException {
        return this.collectDataWithUrls(this.urls);
    }

    private String collectDataWithUrls(List<URL> urlsForCollect) throws IOException {
        ArrayList<JavaInformations> list = new ArrayList<JavaInformations>();
        StringBuilder sb = new StringBuilder();
        for (URL url : urlsForCollect) {
            List serialized = (List)new LabradorRetriever(url).call();
            ArrayList<Counter> counters = new ArrayList<Counter>();
            for (Serializable serializable : serialized) {
                if (serializable instanceof Counter) {
                    Counter counter = (Counter)serializable;
                    counter.setApplication(this.application);
                    counters.add(counter);
                    continue;
                }
                if (serializable instanceof JavaInformations) {
                    JavaInformations newJavaInformations = (JavaInformations)serializable;
                    list.add(newJavaInformations);
                    continue;
                }
                if (!(serializable instanceof String)) continue;
                sb.append(serializable).append('\n');
            }
            if (this.collector == null || this.aggregationDisabled) {
                this.collector = new Collector(this.application, counters);
                continue;
            }
            this.addRequestsAndErrors(counters);
        }
        this.javaInformationsList = list;
        String messageForReport = sb.length() == 0 ? null : sb.toString();
        return messageForReport;
    }

    String executeActionAndCollectData(Action action, String counterName, String sessionId, String threadId, String jobId) throws IOException {
        assert (action != null);
        ArrayList<URL> actionUrls = new ArrayList<URL>(this.urls.size());
        for (URL url : this.urls) {
            StringBuilder actionUrl = new StringBuilder(url.toString());
            actionUrl.append("&action=").append((Object)action);
            if (counterName != null) {
                actionUrl.append("&counter=").append(counterName);
            }
            if (sessionId != null) {
                actionUrl.append("&sessionId=").append(sessionId);
            }
            if (threadId != null) {
                actionUrl.append("&threadId=").append(threadId);
            }
            if (jobId != null) {
                actionUrl.append("&jobId=").append(jobId);
            }
            actionUrls.add(new URL(actionUrl.toString()));
        }
        return this.collectDataWithUrls(actionUrls);
    }

    List<SessionInformations> collectSessionInformations(String sessionId) throws IOException {
        if (sessionId == null) {
            ArrayList<SessionInformations> sessionsInformations = new ArrayList<SessionInformations>();
            for (URL url : this.urls) {
                URL sessionsUrl = new URL(url.toString() + '&' + "part" + '=' + "sessions");
                LabradorRetriever labradorRetriever = new LabradorRetriever(sessionsUrl);
                List sessions = (List)labradorRetriever.call();
                sessionsInformations.addAll(sessions);
            }
            SessionListener.sortSessions(sessionsInformations);
            return sessionsInformations;
        }
        SessionInformations found = null;
        for (URL url : this.urls) {
            URL sessionsUrl = new URL(url.toString() + '&' + "part" + '=' + "sessions" + '&' + "sessionId" + '=' + sessionId);
            LabradorRetriever labradorRetriever = new LabradorRetriever(sessionsUrl);
            SessionInformations session = (SessionInformations)labradorRetriever.call();
            if (session == null) continue;
            found = session;
            break;
        }
        if (found == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(found);
    }

    HeapHistogram collectHeapHistogram() throws IOException {
        HeapHistogram heapHistoTotal = null;
        for (URL url : this.urls) {
            URL heapHistoUrl = new URL(url.toString() + '&' + "part" + '=' + "heaphisto");
            LabradorRetriever labradorRetriever = new LabradorRetriever(heapHistoUrl);
            HeapHistogram heapHisto = (HeapHistogram)labradorRetriever.call();
            if (heapHistoTotal == null) {
                heapHistoTotal = heapHisto;
                continue;
            }
            heapHistoTotal.add(heapHisto);
        }
        return heapHistoTotal;
    }

    DatabaseInformations collectDatabaseInformations(int requestIndex) throws IOException {
        URL url = this.urls.get(0);
        URL databaseUrl = new URL(url.toString() + '&' + "part" + '=' + "database" + '&' + "request" + '=' + requestIndex);
        return (DatabaseInformations)new LabradorRetriever(databaseUrl).call();
    }

    List<List<ConnectionInformations>> collectConnectionInformations() throws IOException {
        ArrayList<List<ConnectionInformations>> connectionInformations = new ArrayList<List<ConnectionInformations>>();
        for (URL url : this.urls) {
            URL connectionsUrl = new URL(url.toString() + '&' + "part" + '=' + "connections");
            LabradorRetriever labradorRetriever = new LabradorRetriever(connectionsUrl);
            List connections = (List)labradorRetriever.call();
            connectionInformations.add(connections);
        }
        return connectionInformations;
    }

    Map<String, List<ProcessInformations>> collectProcessInformations() throws IOException {
        String title = I18N.getString("Processus");
        LinkedHashMap<String, List<ProcessInformations>> processesByTitle = new LinkedHashMap<String, List<ProcessInformations>>();
        for (URL url : this.urls) {
            URL processUrl = new URL(url.toString() + '&' + "part" + '=' + "processes");
            LabradorRetriever labradorRetriever = new LabradorRetriever(processUrl);
            List processList = (List)labradorRetriever.call();
            processesByTitle.put(title + " (" + RemoteCollector.getHostAndPort(url) + ')', processList);
        }
        return processesByTitle;
    }

    List<List<ThreadInformations>> getThreadInformationsLists() {
        ArrayList<List<ThreadInformations>> result = new ArrayList<List<ThreadInformations>>();
        for (JavaInformations javaInformations : this.javaInformationsList) {
            result.add(new ArrayList<ThreadInformations>(javaInformations.getThreadInformationsList()));
        }
        return result;
    }

    Map<String, byte[]> collectJRobins(int width, int height) throws IOException {
        URL url = this.urls.get(0);
        URL jrobinNamesUrl = new URL(url.toString() + '&' + "part" + '=' + "jrobins" + '&' + "width" + '=' + width + '&' + "height" + '=' + height);
        LabradorRetriever labradorRetriever = new LabradorRetriever(jrobinNamesUrl);
        return (Map)labradorRetriever.call();
    }

    Map<String, byte[]> collectOtherJRobins(int width, int height) throws IOException {
        URL url = this.urls.get(0);
        URL otherJRobinNamesUrl = new URL(url.toString() + '&' + "part" + '=' + "otherJRobins" + '&' + "width" + '=' + width + '&' + "height" + '=' + height);
        LabradorRetriever labradorRetriever = new LabradorRetriever(otherJRobinNamesUrl);
        return (Map)labradorRetriever.call();
    }

    byte[] collectJRobin(String graphName, int width, int height) throws IOException {
        URL url = this.urls.get(0);
        URL jrobinUrl = new URL(url.toString() + '&' + "graph" + '=' + graphName + '&' + "part" + '=' + "jrobins" + '&' + "width" + '=' + width + '&' + "height" + '=' + height);
        LabradorRetriever labradorRetriever = new LabradorRetriever(jrobinUrl);
        return (byte[])labradorRetriever.call();
    }

    String collectSqlRequestExplainPlan(String sqlRequest) throws IOException {
        URL url = this.urls.get(0);
        URL explainPlanUrl = new URL(url.toString() + '&' + "part" + '=' + "explainPlan");
        Map<String, String> headers = Collections.singletonMap("request", sqlRequest);
        LabradorRetriever labradorRetriever = new LabradorRetriever(explainPlanUrl, headers);
        return (String)labradorRetriever.call();
    }

    private void addRequestsAndErrors(List<Counter> counters) {
        for (Counter newCounter : counters) {
            Counter counter = this.collector.getCounterByName(newCounter.getName());
            counter.setDisplayed(newCounter.isDisplayed());
            counter.addRequestsAndErrors(newCounter);
        }
    }

    static String getHostAndPort(URL url) {
        if (url.getPort() != -1) {
            return url.getHost() + ':' + url.getPort();
        }
        return url.getHost();
    }

    String getApplication() {
        return this.application;
    }

    List<URL> getURLs() {
        return this.urls;
    }

    void setURLs(List<URL> newURLs) {
        assert (this.urls != null);
        this.urls = newURLs;
    }

    Collector getCollector() {
        return this.collector;
    }

    List<JavaInformations> getJavaInformationsList() {
        return this.javaInformationsList;
    }

    void disableAggregation() {
        this.aggregationDisabled = true;
    }
}

