/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Writer;
import net.bull.javamelody.DatabaseInformations;
import net.bull.javamelody.HtmlCoreReport;
import net.bull.javamelody.I18N;

class HtmlDatabaseInformationsReport {
    private static final boolean PDF_ENABLED = HtmlCoreReport.isPdfEnabled();
    private final DatabaseInformations databaseInformations;
    private final Writer writer;

    HtmlDatabaseInformationsReport(DatabaseInformations databaseInformations, Writer writer) {
        assert (databaseInformations != null);
        assert (writer != null);
        this.databaseInformations = databaseInformations;
        this.writer = writer;
    }

    void toHtml() throws IOException {
        this.writeLinks();
        this.writeln("<br/>");
        this.writeln("<img src='?resource=db.png' width='24' height='24' alt='#database#' />&nbsp;");
        String selectedRequestName = this.databaseInformations.getSelectedRequestName();
        this.writeln("<b>#database# : #" + selectedRequestName + "#</b>");
        String[][] values = this.databaseInformations.getResult();
        int nbColumns = this.databaseInformations.getNbColumns();
        new TableReport(this.writer).toHtml(values, nbColumns);
    }

    private void writeLinks() throws IOException {
        this.writeln("<div class='noPrint'>");
        this.writeln("<a href='javascript:history.back()'><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>");
        String separator = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<a href='?part=database&amp;request=" + this.databaseInformations.getSelectedRequestIndex() + "'><img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#</a>");
        if (PDF_ENABLED) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?part=database&amp;request=" + this.databaseInformations.getSelectedRequestIndex() + "&amp;format=pdf' title='#afficher_PDF#'>");
            this.write("<img src='?resource=pdf.png' alt='#PDF#'/> #PDF#</a>");
        }
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<select name='request' onchange=\"location.href='?part=database&amp;request='+options.selectedIndex;\">");
        int index = 0;
        for (String request : this.databaseInformations.getRequestNames()) {
            this.write("<option value='");
            this.write(String.valueOf(index));
            this.write("'");
            if (index == this.databaseInformations.getSelectedRequestIndex()) {
                this.write(" selected='selected'");
            }
            this.write(">");
            this.write(I18N.getString(request));
            this.write("</option>");
            ++index;
        }
        this.writeln("</select>");
        this.writeln("</div>");
    }

    private void write(String html) throws IOException {
        I18N.writeTo(html, this.writer);
    }

    private void writeln(String html) throws IOException {
        I18N.writelnTo(html, this.writer);
    }

    static class TableReport {
        private final Writer writer;

        TableReport(Writer writer) {
            assert (writer != null);
            this.writer = writer;
        }

        void toHtml(String[][] values, int nbColumns) throws IOException {
            int rowsByColumn;
            if (nbColumns > 1) {
                rowsByColumn = values.length / nbColumns + 1;
                this.writeln("<table width='100%' cellspacing='0' cellpadding='2' summary=''><tr><td valign='top'>");
            } else {
                rowsByColumn = -1;
            }
            String[] headerValues = values[0];
            this.writeTableHeaders(headerValues);
            int index = 0;
            boolean odd = false;
            for (String[] row : values) {
                if (index == 0) {
                    ++index;
                    continue;
                }
                if (odd) {
                    this.write("<tr class='odd' onmouseover=\"this.className='highlight'\" onmouseout=\"this.className='odd'\">");
                } else {
                    this.write("<tr onmouseover=\"this.className='highlight'\" onmouseout=\"this.className=''\">");
                }
                odd = !odd;
                this.writeRow(row);
                this.writeln("</tr>");
                if (rowsByColumn <= 0 || (++index - 1) % rowsByColumn != 0) continue;
                this.writeln("</tbody></table></td><td valign='top'>");
                this.writeTableHeaders(headerValues);
            }
            this.writeln("</tbody></table>");
            if (nbColumns > 1) {
                this.writeln("</td></tr></table>");
            }
        }

        private void writeTableHeaders(String[] headerValues) throws IOException {
            this.writeln("<table class='sortable' width='100%' border='1' cellspacing='0' cellpadding='2' summary='#database#'>");
            this.write("<thead><tr>");
            for (String value : headerValues) {
                this.write("<th>");
                this.writer.write(value.replace("\n", "<br/>"));
                this.write("</th>");
            }
            this.writeln("</tr></thead><tbody>");
        }

        private void writeRow(String[] row) throws IOException {
            for (String value : row) {
                if (value == null || value.length() == 0) {
                    this.write("<td>&nbsp;</td>");
                    continue;
                }
                if (TableReport.isNumber(value)) {
                    this.write("<td align='right' valign='top'>");
                    this.writer.write(value);
                } else {
                    this.write("<td valign='top'>");
                    this.writer.write(value.replace("\n", "<br/>"));
                }
                this.write("</td>");
            }
        }

        private static boolean isNumber(String text) {
            int length = text.length();
            for (int i = 0; i < length; ++i) {
                char c = text.charAt(i);
                if (Character.isDigit(c) || c == '.') continue;
                return false;
            }
            return true;
        }

        private void write(String html) throws IOException {
            I18N.writeTo(html, this.writer);
        }

        private void writeln(String html) throws IOException {
            I18N.writelnTo(html, this.writer);
        }
    }
}

