/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import net.bull.javamelody.HtmlCoreReport;
import net.bull.javamelody.I18N;
import net.bull.javamelody.MBeanNode;
import net.bull.javamelody.PID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HtmlMBeansReport {
    private static final boolean PDF_ENABLED = HtmlCoreReport.isPdfEnabled();
    private static final String BR = "<br/>";
    private final List<MBeanNode> mbeans;
    private final Writer writer;
    private final String pid = PID.getPID();
    private int sequence;

    HtmlMBeansReport(List<MBeanNode> mbeans, Writer writer) {
        assert (mbeans != null);
        assert (writer != null);
        this.mbeans = mbeans;
        this.writer = writer;
    }

    void toHtml() throws IOException {
        this.writeLinks();
        this.writeln(BR);
        this.writeln("<img src='?resource=mbeans.png' width='24' height='24' alt='#MBeans#' />&nbsp;");
        this.writeln("<b>#MBeans#</b>");
        this.writeln("<br/><br/>");
        this.writeTree();
    }

    void writeTree() throws IOException {
        if (this.mbeans.isEmpty()) {
            return;
        }
        String endDiv = "</div>";
        MBeanNode platformNode = this.mbeans.get(0);
        this.writeln("<div style='margin-left: 20px'>");
        this.writeTree(platformNode.getChildren());
        this.writeln("</div>");
        for (MBeanNode node : this.mbeans) {
            if (node == platformNode) continue;
            this.writer.write("<br/><b>" + HtmlMBeansReport.htmlEncode(node.getName()) + "</b>");
            this.writeln("<div style='margin-left: 20px'><br/>");
            this.writeTree(node.getChildren());
            this.writeln("</div>");
        }
    }

    private void writeTree(List<MBeanNode> nodes) throws IOException {
        boolean first = true;
        for (MBeanNode node : nodes) {
            String name = node.getName();
            if (first) {
                first = false;
            } else {
                this.write(BR);
            }
            List<MBeanNode> children = node.getChildren();
            if (children != null) {
                String id = this.getNextId();
                this.writeShowHideLink(id, HtmlMBeansReport.htmlEncode(name));
                this.writeln("<div id='" + id + "' style='display: none; margin-left: 20px;'><div>");
                this.writeTree(children);
                this.writeln("</div></div>");
                continue;
            }
            this.writeMBeanNode(node);
        }
    }

    private void writeMBeanNode(MBeanNode mbean) throws IOException {
        String mbeanName = mbean.getName();
        String mbeanId = this.getNextId();
        int indexOfComma = mbeanName.indexOf(44);
        if (indexOfComma != -1) {
            mbeanName = mbeanName.substring(indexOfComma + 1);
            this.writeShowHideLink(mbeanId, HtmlMBeansReport.htmlEncode(mbeanName));
            this.writeln("<div id='" + mbeanId + "' style='display: none; margin-left: 20px;'>");
            this.writeAttributes(mbean);
            this.writeln("</div>");
        } else {
            this.writeAttributes(mbean);
        }
    }

    private void writeAttributes(MBeanNode mbean) throws IOException {
        String description = mbean.getDescription();
        List<MBeanNode.MBeanAttribute> attributes = mbean.getAttributes();
        if (description != null || !attributes.isEmpty()) {
            this.writeln("<table border='0' cellspacing='0' cellpadding='3' summary=''>");
            if (description != null) {
                this.write("<tr><td colspan='3'>(");
                this.writer.write(HtmlMBeansReport.htmlEncode(description));
                this.write(")</td></tr>");
            }
            for (MBeanNode.MBeanAttribute attribute : attributes) {
                this.writeAttribute(mbean, attribute);
            }
            this.writeln("</table>");
        }
    }

    private void writeAttribute(MBeanNode mbean, MBeanNode.MBeanAttribute attribute) throws IOException {
        String attributeName = attribute.getName();
        String formattedValue = attribute.getFormattedValue();
        String description = attribute.getDescription();
        this.write("<tr valign='top'><td>");
        this.writer.write("<a href='?jmxValue=" + mbean.getName().replace(" ", "%20").replace("'", "%27") + '.' + attributeName + "' ");
        this.writeln("title=\"#Lien_valeur_mbeans#\">-</a>&nbsp;");
        this.writer.write(HtmlMBeansReport.htmlEncode(attributeName));
        this.write("</td><td>");
        this.writer.write(HtmlMBeansReport.htmlEncode(formattedValue));
        this.write("</td><td>");
        if (description != null) {
            this.write("(");
            this.writer.write(HtmlMBeansReport.htmlEncode(description));
            this.write(")");
        } else {
            this.write("&nbsp;");
        }
        this.write("</td></tr>");
    }

    private String getNextId() {
        return 'x' + this.pid + '_' + this.sequence++;
    }

    void writeLinks() throws IOException {
        this.writeln("<div class='noPrint'>");
        this.writeln("<a href='javascript:history.back()'><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<a href='?part=mbeans'><img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#</a>");
        if (PDF_ENABLED) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?part=mbeans&amp;format=pdf' title='#afficher_PDF#'>");
            this.write("<img src='?resource=pdf.png' alt='#PDF#'/> #PDF#</a>");
        }
        this.writeln("</div>");
    }

    private void writeShowHideLink(String idToShow, String label) throws IOException {
        this.writer.write("<a href=\"javascript:showHide('" + idToShow + "');\"><img id='" + idToShow + "Img' src='?resource=bullets/plus.png' alt=''/> " + label + "</a>");
    }

    private static String htmlEncode(String text) {
        return I18N.htmlEncode(text, false);
    }

    private void write(String html) throws IOException {
        I18N.writeTo(html, this.writer);
    }

    private void writeln(String html) throws IOException {
        I18N.writelnTo(html, this.writer);
    }
}

