/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.bull.javamelody.Collector;
import net.bull.javamelody.ConnectionInformations;
import net.bull.javamelody.DatabaseInformations;
import net.bull.javamelody.HeapHistogram;
import net.bull.javamelody.JRobin;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.JndiBinding;
import net.bull.javamelody.LOG;
import net.bull.javamelody.MBeanNode;
import net.bull.javamelody.MailReport;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.Period;
import net.bull.javamelody.ProcessInformations;
import net.bull.javamelody.RemoteCollector;
import net.bull.javamelody.SessionInformations;
import net.bull.javamelody.ThreadInformations;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CollectorServer {
    private static final Logger LOGGER = Logger.getLogger((String)"javamelody");
    private final Map<String, RemoteCollector> remoteCollectorsByApplication = new LinkedHashMap<String, RemoteCollector>();
    private final Map<String, Throwable> lastCollectExceptionsByApplication = new LinkedHashMap<String, Throwable>();
    private final Timer timer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CollectorServer() throws IOException {
        boolean initOk = false;
        this.timer = new Timer("collector", true);
        try {
            LOGGER.info((Object)("reading applications list from: " + Parameters.getCollectorApplicationsFile()));
            Map<String, List<URL>> urlsByApplication = Parameters.getCollectorUrlsByApplications();
            LOGGER.info((Object)("monitored applications: " + urlsByApplication.keySet()));
            LOGGER.info((Object)("urls of monitored applications: " + urlsByApplication));
            int periodMillis = Parameters.getResolutionSeconds() * 1000;
            LOGGER.info((Object)("resolution of the monitoring in seconds: " + Parameters.getResolutionSeconds()));
            TimerTask collectTask = new TimerTask(){

                public void run() {
                    CollectorServer.this.collectWithoutErrors();
                }
            };
            this.timer.schedule(collectTask, 100L, (long)periodMillis);
            JRobin.setJRobinThreadName("jrobin");
            initOk = true;
        }
        finally {
            if (!initOk) {
                this.timer.cancel();
            }
        }
    }

    void collectWithoutErrors() {
        LinkedHashMap<String, List<URL>> clone;
        try {
            clone = new LinkedHashMap<String, List<URL>>(Parameters.getCollectorUrlsByApplications());
        }
        catch (IOException e) {
            LOGGER.warn((Object)e.getMessage(), (Throwable)e);
            return;
        }
        for (Map.Entry entry : clone.entrySet()) {
            String application = (String)entry.getKey();
            List urls = (List)entry.getValue();
            try {
                this.collectForApplication(application, urls);
                this.lastCollectExceptionsByApplication.remove(application);
            }
            catch (Throwable e) {
                LOGGER.warn((Object)e.getMessage(), e);
                this.lastCollectExceptionsByApplication.put(application, e);
            }
        }
    }

    String collectForApplicationForAction(String application, List<URL> urls) throws IOException {
        return this.collectForApplication(new RemoteCollector(application, urls));
    }

    String collectForApplication(String application, List<URL> urls) throws IOException {
        boolean remoteCollectorAvailable = this.isApplicationDataAvailable(application);
        RemoteCollector remoteCollector = !remoteCollectorAvailable ? new RemoteCollector(application, urls) : this.getRemoteCollectorByApplication(application);
        String messageForReport = this.collectForApplication(remoteCollector);
        if (!remoteCollectorAvailable) {
            this.remoteCollectorsByApplication.put(application, remoteCollector);
            if (Parameters.getParameter(Parameter.MAIL_SESSION) != null && Parameters.getParameter(Parameter.ADMIN_EMAILS) != null) {
                this.scheduleReportMailForCollectorServer(application);
                LOGGER.info((Object)("Periodic report scheduled for the application " + application + " to " + Parameters.getParameter(Parameter.ADMIN_EMAILS)));
            }
        }
        return messageForReport;
    }

    private String collectForApplication(RemoteCollector remoteCollector) throws IOException {
        String application = remoteCollector.getApplication();
        List<URL> urls = remoteCollector.getURLs();
        LOGGER.info((Object)("collect for the application " + application + " on " + urls));
        assert (application != null);
        assert (urls != null);
        long start = System.currentTimeMillis();
        String messageForReport = remoteCollector.collectData();
        List<JavaInformations> javaInformationsList = remoteCollector.getJavaInformationsList();
        Collector collector = remoteCollector.getCollector();
        collector.collectWithoutErrors(javaInformationsList);
        LOGGER.info((Object)("collect for the application " + application + " done in " + (System.currentTimeMillis() - start) + "ms"));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("counters " + application + " : " + collector.getCounters()));
            LOGGER.debug((Object)("javaInformations " + application + " : " + javaInformationsList));
            if (messageForReport != null) {
                LOGGER.debug((Object)("message " + application + " : " + messageForReport.replace("\n", ", ")));
            }
        }
        return messageForReport;
    }

    List<SessionInformations> collectSessionInformations(String application, String sessionId) throws IOException {
        return this.getRemoteCollectorByApplication(application).collectSessionInformations(sessionId);
    }

    HeapHistogram collectHeapHistogram(String application) throws IOException {
        return this.getRemoteCollectorByApplication(application).collectHeapHistogram();
    }

    DatabaseInformations collectDatabaseInformations(String application, int requestIndex) throws IOException {
        return this.getRemoteCollectorByApplication(application).collectDatabaseInformations(requestIndex);
    }

    List<List<ConnectionInformations>> collectConnectionInformations(String application) throws IOException {
        return this.getRemoteCollectorByApplication(application).collectConnectionInformations();
    }

    String collectSqlRequestExplainPlan(String application, String sqlRequest) throws IOException {
        return this.getRemoteCollectorByApplication(application).collectSqlRequestExplainPlan(sqlRequest);
    }

    Map<String, List<ProcessInformations>> collectProcessInformations(String application) throws IOException {
        return this.getRemoteCollectorByApplication(application).collectProcessInformations();
    }

    List<JndiBinding> collectJndiBindings(String application, String path) throws IOException {
        return this.getRemoteCollectorByApplication(application).collectJndiBindings(path);
    }

    Map<String, List<MBeanNode>> collectMBeans(String application) throws IOException {
        return this.getRemoteCollectorByApplication(application).collectMBeans();
    }

    List<List<ThreadInformations>> getThreadInformationsLists(String application) {
        return this.getRemoteCollectorByApplication(application).getThreadInformationsLists();
    }

    void addCollectorApplication(String application, List<URL> urls) throws IOException {
        Map<String, List<URL>> collectorUrlsByApplications = Parameters.getCollectorUrlsByApplications();
        for (URL addedUrl : urls) {
            String addedUrlInExternalForm = addedUrl.toExternalForm();
            for (Map.Entry<String, List<URL>> entry : collectorUrlsByApplications.entrySet()) {
                for (URL existingUrl : entry.getValue()) {
                    if (!existingUrl.toExternalForm().equals(addedUrlInExternalForm)) continue;
                    throw new IOException("The URL " + addedUrlInExternalForm.substring(0, addedUrlInExternalForm.lastIndexOf(47)) + " has already been added in the application " + entry.getKey() + ". You can't monitor an application instance twice.");
                }
            }
        }
        this.collectForApplication(application, urls);
        Parameters.addCollectorApplication(application, urls);
    }

    void removeCollectorApplication(String application) throws IOException {
        Parameters.removeCollectorApplication(application);
        this.remoteCollectorsByApplication.remove(application);
    }

    Collector getCollectorByApplication(String application) {
        RemoteCollector remoteCollector = this.remoteCollectorsByApplication.get(application);
        if (remoteCollector == null) {
            return null;
        }
        return remoteCollector.getCollector();
    }

    List<JavaInformations> getJavaInformationsByApplication(String application) {
        RemoteCollector remoteCollector = this.remoteCollectorsByApplication.get(application);
        if (remoteCollector == null) {
            return null;
        }
        return remoteCollector.getJavaInformationsList();
    }

    private RemoteCollector getRemoteCollectorByApplication(String application) {
        assert (application != null);
        RemoteCollector remoteCollector = this.remoteCollectorsByApplication.get(application);
        assert (remoteCollector != null);
        return remoteCollector;
    }

    boolean isApplicationDataAvailable(String application) {
        assert (application != null);
        return this.remoteCollectorsByApplication.containsKey(application);
    }

    String getFirstApplication() {
        if (this.remoteCollectorsByApplication.isEmpty()) {
            return null;
        }
        return this.remoteCollectorsByApplication.keySet().iterator().next();
    }

    Map<String, Throwable> getLastCollectExceptionsByApplication() {
        return Collections.unmodifiableMap(this.lastCollectExceptionsByApplication);
    }

    void scheduleReportMailForCollectorServer(String application) {
        assert (application != null);
        for (Period period : MailReport.getMailPeriods()) {
            this.scheduleReportMailForCollectorServer(application, period);
        }
    }

    void scheduleReportMailForCollectorServer(final String application, final Period period) {
        assert (application != null);
        assert (period != null);
        TimerTask task = new TimerTask(){

            public void run() {
                try {
                    Collector collector = CollectorServer.this.getCollectorByApplication(application);
                    List<JavaInformations> javaInformationsList = CollectorServer.this.getJavaInformationsByApplication(application);
                    new MailReport().sendReportMail(collector, true, javaInformationsList, period);
                }
                catch (Throwable t) {
                    LOG.warn("sending mail report failed", t);
                }
                CollectorServer.this.scheduleReportMailForCollectorServer(application, period);
            }
        };
        this.timer.schedule(task, MailReport.getNextExecutionDate(period));
    }

    void stop() {
        this.timer.cancel();
        for (RemoteCollector remoteCollector : this.remoteCollectorsByApplication.values()) {
            remoteCollector.getCollector().stop();
        }
        this.remoteCollectorsByApplication.clear();
    }

    static List<URL> getUrlsByApplication(String application) throws IOException {
        assert (application != null);
        return Parameters.getCollectorUrlsByApplications().get(application);
    }
}

