/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import net.bull.javamelody.HtmlAbstractReport;
import net.bull.javamelody.I18N;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.SessionInformations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HtmlSessionInformationsReport
extends HtmlAbstractReport {
    private static final String A_HREF_PART_SESSIONS = "<a href='?part=sessions";
    private final List<SessionInformations> sessionsInformations;
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();
    private final DateFormat durationFormat = I18N.createDurationFormat();
    private final DateFormat expiryFormat = I18N.createDateAndTimeFormat();

    HtmlSessionInformationsReport(List<SessionInformations> sessionsInformations, Writer writer) {
        super(writer);
        this.sessionsInformations = sessionsInformations;
    }

    @Override
    void toHtml() throws IOException {
        this.writeBackAndRefreshLinks();
        this.writeln("<br/>");
        assert (this.sessionsInformations != null);
        if (this.sessionsInformations.isEmpty()) {
            this.writeln("#Aucune_session#");
            return;
        }
        this.writeln("<img width='24' height='24' src='?resource=system-users.png' alt='#Sessions#' />&nbsp;");
        this.writeln("<b>#Sessions#</b>");
        this.writeSessions(this.sessionsInformations);
        long totalSerializedSize = 0L;
        int nbSerializableSessions = 0;
        for (SessionInformations sessionInformations : this.sessionsInformations) {
            int size = sessionInformations.getSerializedSize();
            if (size < 0) continue;
            totalSerializedSize += (long)size;
            ++nbSerializableSessions;
        }
        long meanSerializedSize = nbSerializableSessions > 0 ? totalSerializedSize / (long)nbSerializableSessions : -1L;
        this.writeln("<div align='right'>" + HtmlSessionInformationsReport.getFormattedString("nb_sessions", this.sessionsInformations.size()) + "<br/><br/>" + HtmlSessionInformationsReport.getFormattedString("taille_moyenne_sessions", meanSerializedSize) + "</div>");
    }

    private void writeSessions(List<SessionInformations> sessions) throws IOException {
        boolean displayUser = false;
        for (SessionInformations sessionInformations : sessions) {
            if (sessionInformations.getRemoteUser() == null) continue;
            displayUser = true;
            break;
        }
        this.writeln("<table class='sortable' width='100%' border='1' cellspacing='0' cellpadding='2' summary='#Sessions#'>");
        this.write("<thead><tr><th>#Session_id#</th><th class='sorttable_numeric'>#Dernier_acces#</th>");
        this.write("<th class='sorttable_numeric'>#Age#</th><th class='sorttable_date'>#Expiration#</th>");
        this.write("<th class='sorttable_numeric'>#Nb_attributs#</th><th>#Serialisable#</th><th>#Taille_serialisee#</th>");
        this.write("<th class='sorttable_numeric'>#Adresse_IP#</th><th>#Pays#</th>");
        if (displayUser) {
            this.write("<th>#Utilisateur#</th>");
        }
        this.write("<th class='noPrint'>#Invalider#</th>");
        this.writeln("</tr></thead><tbody>");
        boolean odd = false;
        for (SessionInformations session : sessions) {
            if (odd) {
                this.write("<tr class='odd' onmouseover=\"this.className='highlight'\" onmouseout=\"this.className='odd'\">");
            } else {
                this.write("<tr onmouseover=\"this.className='highlight'\" onmouseout=\"this.className=''\">");
            }
            odd = !odd;
            this.writeSession(session, displayUser);
            this.writeln("</tr>");
        }
        this.writeln("</tbody></table>");
    }

    private void writeBackAndRefreshLinks() throws IOException {
        this.writeln("<div class='noPrint'>");
        this.writeln("<a href='javascript:history.back()'>");
        this.writeln("<img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>");
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<a href='?part=sessions'>");
        this.writeln("<img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#</a>");
        if (HtmlSessionInformationsReport.isPdfEnabled()) {
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.write("<a href='?part=sessions&amp;format=pdf' title='#afficher_PDF#'>");
            this.write("<img src='?resource=pdf.png' alt='#PDF#'/> #PDF#</a>");
        }
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<a href='?part=sessions&amp;action=invalidate_sessions' onclick=\"javascript:return confirm('" + HtmlSessionInformationsReport.getStringForJavascript("confirm_invalidate_sessions") + "');\">");
        this.writeln("<img width='16' height='16' src='?resource=user-trash.png' alt='#invalidate_sessions#' title='#invalidate_sessions#' /> #invalidate_sessions#</a>");
        this.writeln("</div>");
    }

    private void writeBackAndRefreshLinksForSession(String sessionId) throws IOException {
        this.writeln("<div class='noPrint'>");
        this.writeln("<a href='javascript:history.back()'><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<a href='?part=sessions&amp;sessionId=" + HtmlSessionInformationsReport.urlEncode(sessionId) + "'>");
        this.writeln("<img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#</a>");
        this.writeln("</div>");
    }

    private void writeSession(SessionInformations session, boolean displayUser) throws IOException {
        String nextColumnAlignRight = "</td><td align='right'>";
        String nextColumnAlignCenter = "</td><td align='center'>";
        this.write("<td><a href='?part=sessions&amp;sessionId=");
        this.write(HtmlSessionInformationsReport.htmlEncodeButNotSpace(session.getId()));
        this.write("'>");
        this.write(HtmlSessionInformationsReport.htmlEncodeButNotSpace(session.getId()));
        this.write("</a>");
        this.write("</td><td align='right'>");
        this.write(this.durationFormat.format(session.getLastAccess()));
        this.write("</td><td align='right'>");
        this.write(this.durationFormat.format(session.getAge()));
        this.write("</td><td align='right'>");
        this.write(this.expiryFormat.format(session.getExpirationDate()));
        this.write("</td><td align='right'>");
        this.write(this.integerFormat.format(session.getAttributeCount()));
        this.write("</td><td align='center'>");
        if (session.isSerializable()) {
            this.write("#oui#");
        } else {
            this.write("<span class='severe'>#non#</span>");
        }
        this.write("</td><td align='right'>");
        this.write(this.integerFormat.format(session.getSerializedSize()));
        String nextColumn = "</td><td>";
        this.write("</td><td>");
        String remoteAddr = session.getRemoteAddr();
        if (remoteAddr == null) {
            this.write("&nbsp;");
        } else {
            this.write(remoteAddr);
        }
        this.write("</td><td align='center'>");
        this.writeCountry(session);
        if (displayUser) {
            this.write("</td><td>");
            String remoteUser = session.getRemoteUser();
            if (remoteUser == null) {
                this.write("&nbsp;");
            } else {
                this.writeDirectly(HtmlSessionInformationsReport.htmlEncodeButNotSpace(remoteUser));
            }
        }
        this.write("</td><td align='center' class='noPrint'>");
        this.write(A_HREF_PART_SESSIONS);
        this.write("&amp;action=invalidate_session&amp;sessionId=");
        this.write(HtmlSessionInformationsReport.urlEncode(session.getId()));
        this.write("' onclick=\"javascript:return confirm('" + HtmlSessionInformationsReport.getStringForJavascript("confirm_invalidate_session") + "');\">");
        this.write("<img width='16' height='16' src='?resource=user-trash.png' alt='#invalidate_session#' title='#invalidate_session#' />");
        this.write("</a>");
        this.write("</td>");
    }

    private void writeCountry(SessionInformations session) throws IOException {
        String country = session.getCountry();
        if (country == null) {
            this.write("&nbsp;");
        } else {
            String fileName = "flags/" + country + ".gif";
            if (this.getClass().getResource(Parameters.getResourcePath(fileName)) == null) {
                this.write(country);
            } else {
                this.write("<img src='?resource=");
                this.write(fileName);
                this.write("' alt='");
                this.write(country);
                this.write("' title='");
                this.write(session.getCountryDisplay());
                this.write("' />");
            }
        }
    }

    void writeSessionDetails(String sessionId, SessionInformations sessionInformations) throws IOException {
        this.writeBackAndRefreshLinksForSession(sessionId);
        this.writeln("<br/>");
        if (sessionInformations == null) {
            this.writeln(HtmlSessionInformationsReport.getFormattedString("session_invalidee", HtmlSessionInformationsReport.htmlEncodeButNotSpace(sessionId)));
            return;
        }
        this.writeln("<img width='24' height='24' src='?resource=system-users.png' alt='#Sessions#' />&nbsp;");
        this.writeln("<b>" + HtmlSessionInformationsReport.getFormattedString("Details_session", HtmlSessionInformationsReport.htmlEncodeButNotSpace(sessionId)) + "</b>");
        this.writeSessions(Collections.singletonList(sessionInformations));
        this.writeln("<br/><b>#Attributs#</b>");
        this.writeSessionAttributes(sessionInformations);
    }

    private void writeSessionAttributes(SessionInformations sessionInformations) throws IOException {
        this.writeln("<table class='sortable' width='100%' border='1' cellspacing='0' cellpadding='2' summary='#Attributs#'>");
        this.write("<thead><tr><th>#Nom#</th><th>Type</th><th>#Serialisable#</th><th>#Taille_serialisee#</th><th>#Contenu#</th>");
        this.writeln("</tr></thead><tbody>");
        boolean odd = false;
        for (SessionInformations.SessionAttribute sessionAttribute : sessionInformations.getAttributes()) {
            if (odd) {
                this.write("<tr class='odd' onmouseover=\"this.className='highlight'\" onmouseout=\"this.className='odd'\">");
            } else {
                this.write("<tr onmouseover=\"this.className='highlight'\" onmouseout=\"this.className=''\">");
            }
            odd = !odd;
            this.writeAttribute(sessionAttribute);
            this.writeln("</tr>");
        }
        this.writeln("</tbody></table>");
    }

    private void writeAttribute(SessionInformations.SessionAttribute sessionAttribute) throws IOException {
        this.write("<td>");
        this.writeDirectly(HtmlSessionInformationsReport.htmlEncodeButNotSpace(sessionAttribute.getName()));
        this.write("</td><td>");
        this.write(String.valueOf(sessionAttribute.getType()));
        this.write("</td><td align='center'>");
        if (sessionAttribute.isSerializable()) {
            this.write("#oui#");
        } else {
            this.write("<span class='severe'>#non#</span>");
        }
        this.write("</td><td align='right'>");
        this.write(this.integerFormat.format(sessionAttribute.getSerializedSize()));
        this.write("</td><td>");
        this.writeDirectly(HtmlSessionInformationsReport.htmlEncodeButNotSpace(String.valueOf(sessionAttribute.getContent())));
        this.write("</td>");
    }
}

