/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import net.bull.javamelody.CounterRequest;
import net.bull.javamelody.I18N;
import net.bull.javamelody.LOG;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.Range;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdDbPool;
import org.jrobin.core.RrdDef;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdNioBackend;
import org.jrobin.core.Sample;
import org.jrobin.core.Util;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JRobin {
    static final int SMALL_HEIGHT = 50;
    private static final Color LIGHT_RED = Color.RED.brighter().brighter();
    private static final Paint SMALL_GRADIENT = new GradientPaint(0.0f, 0.0f, LIGHT_RED, 0.0f, 50.0f, Color.GREEN, false);
    private static final int HOUR = 3600;
    private static final int DAY = 86400;
    private final RrdDbPool rrdPool = JRobin.getRrdDbPool();
    private final String application;
    private final String name;
    private final String rrdFileName;
    private final int step;
    private final String requestName;

    private JRobin(String application, String name, File rrdFile, int step, String requestName) throws RrdException, IOException {
        assert (application != null);
        assert (name != null);
        assert (rrdFile != null);
        assert (step > 0);
        this.application = application;
        this.name = name;
        this.rrdFileName = rrdFile.getPath();
        this.step = step;
        this.requestName = requestName;
        this.init();
    }

    static void stop() throws IOException {
        JRobin.getJRobinFileSyncTimer().cancel();
    }

    static void setJRobinThreadName(final String jrobinThreadName) throws IOException {
        TimerTask threadNameTask = new TimerTask(){

            public void run() {
                Thread.currentThread().setName(jrobinThreadName);
            }
        };
        JRobin.getJRobinFileSyncTimer().schedule(threadNameTask, 0L);
    }

    static Timer getJRobinFileSyncTimer() throws IOException {
        try {
            Field field = RrdNioBackend.class.getDeclaredField("fileSyncTimer");
            JRobin.setFieldAccessible(field);
            return (Timer)field.get(null);
        }
        catch (NoSuchFieldException e) {
            throw JRobin.createIOException(e);
        }
        catch (IllegalAccessException e) {
            throw JRobin.createIOException(e);
        }
    }

    private static void setFieldAccessible(final Field field) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                field.setAccessible(true);
                return null;
            }
        });
    }

    static JRobin createInstance(String application, String name, String requestName) throws IOException {
        File dir = Parameters.getStorageDirectory(application);
        File rrdFile = new File(dir, name + ".rrd");
        int step = Parameters.getResolutionSeconds();
        try {
            return new JRobin(application, name, rrdFile, step, requestName);
        }
        catch (RrdException e) {
            throw JRobin.createIOException((Exception)((Object)e));
        }
    }

    private void init() throws IOException, RrdException {
        File rrdFile = new File(this.rrdFileName);
        File rrdDirectory = rrdFile.getParentFile();
        if (!rrdDirectory.mkdirs() && !rrdDirectory.exists()) {
            throw new IOException("JavaMelody directory can't be created: " + rrdDirectory.getPath());
        }
        if (!rrdFile.exists() || rrdFile.length() == 0L) {
            RrdDef rrdDef = new RrdDef(this.rrdFileName, (long)this.step);
            rrdDef.setStartTime(Util.getTime() - (long)this.step);
            String dsType = "GAUGE";
            int heartbeat = this.step * 2;
            rrdDef.addDatasource(this.getDataSourceName(), "GAUGE", (long)heartbeat, 0.0, Double.NaN);
            String average = "AVERAGE";
            String max = "MAX";
            rrdDef.addArchive("AVERAGE", 0.25, 1, 86400 / this.step);
            rrdDef.addArchive("MAX", 0.25, 1, 86400 / this.step);
            rrdDef.addArchive("AVERAGE", 0.25, 3600 / this.step, 168);
            rrdDef.addArchive("MAX", 0.25, 3600 / this.step, 168);
            rrdDef.addArchive("AVERAGE", 0.25, 21600 / this.step, 124);
            rrdDef.addArchive("MAX", 0.25, 21600 / this.step, 124);
            rrdDef.addArchive("AVERAGE", 0.25, 172800 / this.step, 360);
            rrdDef.addArchive("MAX", 0.25, 172800 / this.step, 360);
            RrdDb rrdDb = this.rrdPool.requestRrdDb(rrdDef);
            this.rrdPool.release(rrdDb);
        }
    }

    private void resetFile() throws IOException {
        this.deleteFile();
        try {
            this.init();
        }
        catch (RrdException e) {
            throw JRobin.createIOException((Exception)((Object)e));
        }
    }

    byte[] graph(Range range, int width, int height) throws IOException {
        try {
            RrdGraphDef graphDef = new RrdGraphDef();
            if (Locale.CHINESE.getLanguage().equals(I18N.getResourceBundle().getLocale().getLanguage())) {
                graphDef.setSmallFont(new Font("Monospaced", 0, 10));
                graphDef.setLargeFont(new Font("Monospaced", 1, 12));
            }
            this.initGraphSource(graphDef, height);
            this.initGraphPeriodAndSize(range, width, height, graphDef);
            graphDef.setImageFormat("png");
            graphDef.setFilename("-");
            graphDef.setPoolUsed(true);
            return new RrdGraph(graphDef).getRrdGraphInfo().getBytes();
        }
        catch (RrdException e) {
            throw JRobin.createIOException((Exception)((Object)e));
        }
    }

    private void initGraphPeriodAndSize(Range range, int width, int height, RrdGraphDef graphDef) {
        String titleEnd;
        long startTime;
        long endTime;
        if (range.getPeriod() == null) {
            endTime = Math.min(range.getEndDate().getTime() / 1000L, Util.getTime());
            startTime = range.getStartDate().getTime() / 1000L;
        } else {
            endTime = Util.getTime();
            startTime = endTime - (long)range.getPeriod().getDurationSeconds();
        }
        String label = this.getLabel();
        String titleStart = label.length() > 31 && width <= 200 ? label : label + " - " + range.getLabel();
        if (width > 400) {
            titleEnd = range.getPeriod() == null ? " - " + I18N.getFormattedString("sur", this.getApplication()) : " - " + I18N.getCurrentDate() + ' ' + I18N.getFormattedString("sur", this.getApplication());
        } else {
            titleEnd = "";
            if (range.getPeriod() == null) {
                graphDef.setLargeFont(graphDef.getLargeFont().deriveFont(graphDef.getLargeFont().getSize2D() - 2.0f));
            }
        }
        graphDef.setStartTime(startTime);
        graphDef.setEndTime(endTime);
        graphDef.setTitle(titleStart + titleEnd);
        graphDef.setFirstDayOfWeek(Calendar.getInstance(I18N.getCurrentLocale()).getFirstDayOfWeek());
        graphDef.setWidth(width);
        graphDef.setHeight(height);
        if (width <= 100) {
            graphDef.setNoLegend(true);
            graphDef.setUnitsLength(0);
            graphDef.setShowSignature(false);
            graphDef.setTitle(null);
        }
    }

    private void initGraphSource(RrdGraphDef graphDef, int height) {
        String average = "average";
        String max = "max";
        String dataSourceName = this.getDataSourceName();
        graphDef.datasource("average", this.rrdFileName, dataSourceName, "AVERAGE");
        graphDef.datasource("max", this.rrdFileName, dataSourceName, "MAX");
        graphDef.setMinValue(0.0);
        String moyenneLabel = I18N.getString("Moyenne");
        String maximumLabel = I18N.getString("Maximum");
        graphDef.area("average", JRobin.getPaint(height), moyenneLabel);
        graphDef.line("max", (Paint)Color.BLUE, maximumLabel);
        graphDef.gprint("average", "AVERAGE", moyenneLabel + ": %9.0f %S\\r");
        graphDef.gprint("max", "MAX", maximumLabel + ": %9.0f %S\\r");
    }

    private static Paint getPaint(int height) {
        if (height == 50) {
            return SMALL_GRADIENT;
        }
        return new GradientPaint(0.0f, 0.0f, LIGHT_RED, 0.0f, height, Color.GREEN, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addValue(double value) throws IOException {
        try {
            RrdDb rrdDb;
            RrdDb rrdDb2 = rrdDb = this.rrdPool.requestRrdDb(this.rrdFileName);
            synchronized (rrdDb2) {
                try {
                    Sample sample = rrdDb.createSample();
                    if (sample.getTime() > rrdDb.getLastUpdateTime()) {
                        sample.setValue(this.getDataSourceName(), value);
                        sample.update();
                    }
                }
                finally {
                    this.rrdPool.release(rrdDb);
                }
            }
        }
        catch (FileNotFoundException e) {
            if (e.getMessage() != null && e.getMessage().endsWith("[non existent]")) {
                LOG.debug("A JRobin file was deleted and created again: " + new File(this.rrdFileName).getPath());
                this.resetFile();
                this.addValue(value);
            }
        }
        catch (RrdException e) {
            if (e.getMessage() != null && e.getMessage().startsWith("Invalid file header")) {
                LOG.debug("A JRobin file was found corrupted and was reset: " + new File(this.rrdFileName).getPath());
                this.resetFile();
                this.addValue(value);
            }
            throw JRobin.createIOException((Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    double getLastValue() throws IOException {
        double d;
        RrdDb rrdDb = this.rrdPool.requestRrdDb(this.rrdFileName);
        try {
            d = rrdDb.getLastDatasourceValue(this.getDataSourceName());
        }
        catch (Throwable throwable) {
            try {
                this.rrdPool.release(rrdDb);
                throw throwable;
            }
            catch (RrdException e) {
                throw JRobin.createIOException((Exception)((Object)e));
            }
        }
        this.rrdPool.release(rrdDb);
        return d;
    }

    boolean deleteFile() {
        return new File(this.rrdFileName).delete();
    }

    private String getApplication() {
        return this.application;
    }

    String getName() {
        return this.name;
    }

    private String getDataSourceName() {
        return this.name.substring(0, Math.min(20, this.name.length()));
    }

    String getLabel() {
        if (this.requestName == null) {
            return I18N.getString(this.getName());
        }
        String shortRequestName = this.requestName.substring(0, Math.min(30, this.requestName.length()));
        return I18N.getFormattedString("Temps_moyens_de", shortRequestName);
    }

    private static IOException createIOException(Exception e) {
        IOException ex = new IOException(e.getMessage());
        ex.initCause(e);
        return ex;
    }

    static long deleteObsoleteJRobinFiles(String application) throws IOException {
        Calendar nowMinusThreeMonthsAndADay = Calendar.getInstance();
        nowMinusThreeMonthsAndADay.add(2, -3);
        nowMinusThreeMonthsAndADay.add(6, -1);
        long timestamp = Util.getTimestamp((Calendar)nowMinusThreeMonthsAndADay);
        RrdDbPool rrdPool = JRobin.getRrdDbPool();
        int counterRequestIdLength = new CounterRequest("", "").getId().length();
        long diskUsage = 0L;
        for (File file : JRobin.listRrdFiles(application)) {
            if (file.getName().length() > counterRequestIdLength && file.lastModified() < nowMinusThreeMonthsAndADay.getTimeInMillis()) {
                try {
                    RrdDb rrdDb = rrdPool.requestRrdDb(file.getPath());
                    boolean obsolete = rrdDb.getLastUpdateTime() < timestamp;
                    rrdPool.release(rrdDb);
                    boolean deleted = false;
                    if (obsolete) {
                        deleted = file.delete();
                    }
                    if (deleted) continue;
                    diskUsage += file.length();
                }
                catch (IOException e) {
                }
                catch (RrdException e) {}
                continue;
            }
            diskUsage += file.length();
        }
        return diskUsage;
    }

    private static List<File> listRrdFiles(String application) {
        FilenameFilter filenameFilter;
        File storageDir = Parameters.getStorageDirectory(application);
        File[] files = storageDir.listFiles(filenameFilter = new FilenameFilter(){

            public boolean accept(File dir, String fileName) {
                return fileName.endsWith(".rrd");
            }
        });
        if (files == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(files);
    }

    private static RrdDbPool getRrdDbPool() throws IOException {
        try {
            return RrdDbPool.getInstance();
        }
        catch (RrdException e) {
            throw JRobin.createIOException((Exception)((Object)e));
        }
    }
}

