/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.bull.javamelody.Collector;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterRequest;
import net.bull.javamelody.CounterRequestAggregation;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JRobin;
import net.bull.javamelody.PdfAbstractReport;
import net.bull.javamelody.PdfCounterErrorReport;
import net.bull.javamelody.PdfDocumentFactory;
import net.bull.javamelody.PdfFonts;
import net.bull.javamelody.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PdfCounterReport
extends PdfAbstractReport {
    private final Collector collector;
    private final Counter counter;
    private final Range range;
    private final boolean includeGraph;
    private final CounterRequestAggregation counterRequestAggregation;
    private final DecimalFormat systemErrorFormat = I18N.createPercentFormat();
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();
    private final Font cellFont = PdfFonts.TABLE_CELL.getFont();
    private final Font infoCellFont = PdfFonts.INFO_CELL.getFont();
    private final Font warningCellFont = PdfFonts.WARNING_CELL.getFont();
    private final Font severeCellFont = PdfFonts.SEVERE_CELL.getFont();
    private final Font normalFont = PdfFonts.NORMAL.getFont();
    private PdfPTable currentTable;

    PdfCounterReport(Collector collector, Counter counter, Range range, boolean includeGraph, Document document) {
        super(document);
        assert (collector != null);
        assert (counter != null);
        assert (range != null);
        this.collector = collector;
        this.counter = counter;
        this.range = range;
        this.includeGraph = includeGraph;
        this.counterRequestAggregation = new CounterRequestAggregation(counter);
    }

    @Override
    void toPdf() throws DocumentException, IOException {
        List<CounterRequest> requests = this.counterRequestAggregation.getRequests();
        if (requests.isEmpty()) {
            this.writeNoRequests();
        } else if (this.isErrorAndNotJobCounter()) {
            assert (!requests.isEmpty());
            List<CounterRequest> summaryRequest = Collections.singletonList(requests.get(0));
            this.writeRequests(this.counter.getChildCounterName(), summaryRequest);
        } else {
            CounterRequest globalRequest = this.counterRequestAggregation.getGlobalRequest();
            List<CounterRequest> summaryRequests = Arrays.asList(globalRequest, this.counterRequestAggregation.getWarningRequest(), this.counterRequestAggregation.getSevereRequest());
            this.writeRequests(this.counter.getChildCounterName(), summaryRequests);
        }
    }

    String getCounterName() {
        return this.counter.getName();
    }

    String getCounterIconName() {
        return this.counter.getIconName();
    }

    boolean isErrorCounter() {
        return this.counter.isErrorCounter();
    }

    private boolean isJobCounter() {
        return this.counter.isJobCounter();
    }

    private boolean isErrorAndNotJobCounter() {
        return this.isErrorCounter() && !this.isJobCounter();
    }

    void writeRequestDetails() throws DocumentException, IOException {
        List<CounterRequest> requests = this.counterRequestAggregation.getRequests();
        if (requests.isEmpty()) {
            this.writeNoRequests();
        } else {
            this.writeRequests(this.counter.getChildCounterName(), requests);
        }
    }

    private void writeNoRequests() throws DocumentException {
        String msg = this.isJobCounter() ? "Aucun_job" : (this.isErrorCounter() ? "Aucune_erreur" : "Aucune_requete");
        this.addToDocument((Element)new Phrase(PdfCounterReport.getString(msg), this.normalFont));
    }

    void writeErrorDetails() throws DocumentException {
        new PdfCounterErrorReport(this.counter, this.getDocument()).toPdf();
    }

    void writeRequests(String childCounterName, List<CounterRequest> requestList) throws DocumentException, IOException {
        assert (requestList != null);
        this.writeHeader(childCounterName);
        PdfPCell defaultCell = this.getDefaultCell();
        boolean odd = false;
        for (CounterRequest request : requestList) {
            if (odd) {
                defaultCell.setGrayFill(0.97f);
            } else {
                defaultCell.setGrayFill(1.0f);
            }
            odd = !odd;
            this.writeRequest(request);
        }
        this.addToDocument((Element)this.currentTable);
        this.writeFooter();
    }

    private void writeHeader(String childCounterName) throws DocumentException {
        List<String> headers = this.createHeaders(childCounterName);
        int[] relativeWidths = new int[headers.size()];
        Arrays.fill(relativeWidths, 0, headers.size(), 1);
        relativeWidths[0] = 10;
        if (this.includeGraph) {
            relativeWidths[0] = 8;
            relativeWidths[1] = 2;
        }
        this.currentTable = PdfDocumentFactory.createPdfPTable(headers, relativeWidths);
    }

    private List<String> createHeaders(String childCounterName) {
        ArrayList<String> headers = new ArrayList<String>();
        if (this.isJobCounter()) {
            headers.add(PdfCounterReport.getString("Job"));
        } else if (this.isErrorCounter()) {
            headers.add(PdfCounterReport.getString("Erreur"));
        } else {
            headers.add(PdfCounterReport.getString("Requete"));
        }
        if (this.includeGraph) {
            headers.add(PdfCounterReport.getString("Evolution"));
        }
        if (this.counterRequestAggregation.isTimesDisplayed()) {
            headers.add(PdfCounterReport.getString("temps_cumule"));
            headers.add(PdfCounterReport.getString("Hits"));
            headers.add(PdfCounterReport.getString("Temps_moyen"));
            headers.add(PdfCounterReport.getString("Temps_max"));
            headers.add(PdfCounterReport.getString("Ecart_type"));
        } else {
            headers.add(PdfCounterReport.getString("Hits"));
        }
        if (this.counterRequestAggregation.isCpuTimesDisplayed()) {
            headers.add(PdfCounterReport.getString("temps_cpu_cumule"));
            headers.add(PdfCounterReport.getString("Temps_cpu_moyen"));
        }
        if (!this.isErrorAndNotJobCounter()) {
            headers.add(PdfCounterReport.getString("erreur_systeme"));
        }
        if (this.counterRequestAggregation.isResponseSizeDisplayed()) {
            headers.add(PdfCounterReport.getString("Taille_moyenne"));
        }
        if (this.counterRequestAggregation.isChildHitsDisplayed()) {
            headers.add(PdfCounterReport.getFormattedString("hits_fils_moyens", childCounterName));
            headers.add(PdfCounterReport.getFormattedString("temps_fils_moyen", childCounterName));
        }
        return headers;
    }

    private void writeFooter() throws DocumentException {
        List<CounterRequest> requests = this.counterRequestAggregation.getRequests();
        CounterRequest globalRequest = this.counterRequestAggregation.getGlobalRequest();
        long deltaMillis = Math.max(System.currentTimeMillis() - this.counter.getStartDate().getTime(), 1L);
        long hitsParMinute = 60000L * globalRequest.getHits() / deltaMillis;
        String key = this.isJobCounter() ? "nb_jobs" : (this.isErrorCounter() ? "nb_erreurs" : "nb_requetes");
        Paragraph footer = new Paragraph(PdfCounterReport.getFormattedString(key, this.integerFormat.format(hitsParMinute), this.integerFormat.format(requests.size())), this.normalFont);
        footer.setAlignment(2);
        this.addToDocument((Element)footer);
    }

    private void writeRequest(CounterRequest request) throws BadElementException, IOException {
        this.getDefaultCell().setHorizontalAlignment(0);
        String name = request.getName();
        if (name.length() > 1000) {
            this.addCell(name.substring(0, 1000) + "...");
        } else {
            this.addCell(name);
        }
        if (this.includeGraph) {
            this.writeRequestGraph(request);
        }
        this.getDefaultCell().setHorizontalAlignment(2);
        CounterRequest globalRequest = this.counterRequestAggregation.getGlobalRequest();
        if (this.counterRequestAggregation.isTimesDisplayed()) {
            this.addPercentageCell(request.getDurationsSum(), globalRequest.getDurationsSum());
            this.addCell(this.integerFormat.format(request.getHits()));
            int mean = request.getMean();
            this.currentTable.addCell(new Phrase(this.integerFormat.format(mean), this.getSlaFont(mean)));
            this.addCell(this.integerFormat.format(request.getMaximum()));
            this.addCell(this.integerFormat.format(request.getStandardDeviation()));
        } else {
            this.addCell(this.integerFormat.format(request.getHits()));
        }
        if (this.counterRequestAggregation.isCpuTimesDisplayed()) {
            this.addPercentageCell(request.getCpuTimeSum(), globalRequest.getCpuTimeSum());
            int cpuTimeMean = request.getCpuTimeMean();
            this.currentTable.addCell(new Phrase(this.integerFormat.format(cpuTimeMean), this.getSlaFont(cpuTimeMean)));
        }
        if (!this.isErrorAndNotJobCounter()) {
            this.addCell(this.systemErrorFormat.format(request.getSystemErrorPercentage()));
        }
        if (this.counterRequestAggregation.isResponseSizeDisplayed()) {
            this.addCell(this.integerFormat.format(request.getResponseSizeMean() / 1024));
        }
        if (this.counterRequestAggregation.isChildHitsDisplayed()) {
            this.addCell(this.integerFormat.format(request.getChildHitsMean()));
            this.addCell(this.integerFormat.format(request.getChildDurationsMean()));
        }
    }

    private void writeRequestGraph(CounterRequest request) throws BadElementException, IOException {
        JRobin jrobin = this.collector.getJRobin(request.getId());
        if (jrobin == null) {
            this.addCell("");
        } else {
            byte[] img = jrobin.graph(this.range, 100, 50);
            Image image = Image.getInstance((byte[])img);
            image.scalePercent(50.0f);
            this.currentTable.addCell(image);
        }
    }

    Font getSlaFont(int mean) {
        Font font = mean < this.counterRequestAggregation.getWarningThreshold() || mean == 0 ? this.infoCellFont : (mean < this.counterRequestAggregation.getSevereThreshold() ? this.warningCellFont : this.severeCellFont);
        return font;
    }

    private PdfPCell getDefaultCell() {
        return this.currentTable.getDefaultCell();
    }

    private void addPercentageCell(long dividende, long diviseur) {
        if (diviseur == 0L) {
            this.addCell("0");
        } else {
            this.addCell(this.integerFormat.format(100L * dividende / diviseur));
        }
    }

    private void addCell(String string) {
        this.currentTable.addCell(new Phrase(string, this.cellFont));
    }
}

