/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.bull.javamelody.Action;
import net.bull.javamelody.Collector;
import net.bull.javamelody.ConnectionInformations;
import net.bull.javamelody.Counter;
import net.bull.javamelody.CounterRequestContext;
import net.bull.javamelody.DatabaseInformations;
import net.bull.javamelody.HeapHistogram;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.JndiBinding;
import net.bull.javamelody.LabradorRetriever;
import net.bull.javamelody.MBeanNode;
import net.bull.javamelody.ProcessInformations;
import net.bull.javamelody.SessionInformations;
import net.bull.javamelody.SessionListener;
import net.bull.javamelody.ThreadInformations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RemoteCollector {
    private final String application;
    private List<URL> urls;
    private Collector collector;
    private List<JavaInformations> javaInformationsList;
    private Map<JavaInformations, List<CounterRequestContext>> currentRequests;
    private String cookies;
    private boolean aggregationDisabled;

    RemoteCollector(String application, List<URL> urls) {
        assert (application != null);
        assert (urls != null);
        this.application = application;
        this.urls = urls;
    }

    String collectData() throws IOException {
        return this.collectDataWithUrls(this.urls);
    }

    String collectDataIncludingCurrentRequests() throws IOException {
        ArrayList<URL> urlsWithCurrentRequests = new ArrayList<URL>();
        for (URL url : this.urls) {
            urlsWithCurrentRequests.add(new URL(url.toString() + '&' + "part" + '=' + "defaultWithCurrentRequests"));
        }
        return this.collectDataWithUrls(urlsWithCurrentRequests);
    }

    private String collectDataWithUrls(List<URL> urlsForCollect) throws IOException {
        ArrayList<JavaInformations> javaInfosList = new ArrayList<JavaInformations>();
        HashMap<JavaInformations, List<CounterRequestContext>> counterRequestContextsByJavaInformations = new HashMap<JavaInformations, List<CounterRequestContext>>();
        StringBuilder sb = new StringBuilder();
        for (URL url : urlsForCollect) {
            ArrayList<Counter> counters = new ArrayList<Counter>();
            List serialized = (List)this.collectForUrl(url);
            this.dispatchSerializables(serialized, counters, javaInfosList, counterRequestContextsByJavaInformations, sb);
            if (this.collector == null || this.aggregationDisabled) {
                this.collector = new Collector(this.application, counters);
                continue;
            }
            this.addRequestsAndErrors(counters);
        }
        this.javaInformationsList = javaInfosList;
        this.currentRequests = counterRequestContextsByJavaInformations;
        String messageForReport = sb.length() == 0 ? null : sb.toString();
        return messageForReport;
    }

    private void dispatchSerializables(List<Serializable> serialized, List<Counter> counters, List<JavaInformations> javaInfosList, Map<JavaInformations, List<CounterRequestContext>> counterRequestContextsByJavaInformations, StringBuilder sb) {
        JavaInformations latestJavaInformations = null;
        ArrayList<CounterRequestContext> counterRequestContextsList = new ArrayList<CounterRequestContext>();
        for (Serializable serializable : serialized) {
            if (serializable instanceof Counter) {
                Counter counter = (Counter)serializable;
                counter.setApplication(this.application);
                counters.add(counter);
                continue;
            }
            if (serializable instanceof JavaInformations) {
                JavaInformations newJavaInformations;
                latestJavaInformations = newJavaInformations = (JavaInformations)serializable;
                javaInfosList.add(newJavaInformations);
                continue;
            }
            if (serializable instanceof String) {
                sb.append(serializable).append('\n');
                continue;
            }
            if (!(serializable instanceof CounterRequestContext)) continue;
            CounterRequestContext counterRequestContext = (CounterRequestContext)serializable;
            counterRequestContextsList.add(counterRequestContext);
        }
        if (!counterRequestContextsList.isEmpty()) {
            counterRequestContextsByJavaInformations.put(latestJavaInformations, counterRequestContextsList);
        }
    }

    String executeActionAndCollectData(Action action, String counterName, String sessionId, String threadId, String jobId, String cacheId) throws IOException {
        assert (action != null);
        ArrayList<URL> actionUrls = new ArrayList<URL>(this.urls.size());
        for (URL url : this.urls) {
            StringBuilder actionUrl = new StringBuilder(url.toString());
            actionUrl.append("&action=").append((Object)action);
            if (counterName != null) {
                actionUrl.append("&counter=").append(counterName);
            }
            if (sessionId != null) {
                actionUrl.append("&sessionId=").append(sessionId);
            }
            if (threadId != null) {
                actionUrl.append("&threadId=").append(threadId);
            }
            if (jobId != null) {
                actionUrl.append("&jobId=").append(jobId);
            }
            if (cacheId != null) {
                actionUrl.append("&cacheId=").append(cacheId);
            }
            actionUrls.add(new URL(actionUrl.toString()));
        }
        return this.collectDataWithUrls(actionUrls);
    }

    List<SessionInformations> collectSessionInformations(String sessionId) throws IOException {
        if (sessionId == null) {
            ArrayList<SessionInformations> sessionsInformations = new ArrayList<SessionInformations>();
            for (URL url : this.urls) {
                URL sessionsUrl = new URL(url.toString() + '&' + "part" + '=' + "sessions");
                List sessions = (List)this.collectForUrl(sessionsUrl);
                sessionsInformations.addAll(sessions);
            }
            SessionListener.sortSessions(sessionsInformations);
            return sessionsInformations;
        }
        SessionInformations found = null;
        for (URL url : this.urls) {
            URL sessionsUrl = new URL(url.toString() + '&' + "part" + '=' + "sessions" + '&' + "sessionId" + '=' + sessionId);
            SessionInformations session = (SessionInformations)this.collectForUrl(sessionsUrl);
            if (session == null) continue;
            found = session;
            break;
        }
        if (found == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(found);
    }

    HeapHistogram collectHeapHistogram() throws IOException {
        HeapHistogram heapHistoTotal = null;
        for (URL url : this.urls) {
            URL heapHistoUrl = new URL(url.toString() + '&' + "part" + '=' + "heaphisto");
            HeapHistogram heapHisto = (HeapHistogram)this.collectForUrl(heapHistoUrl);
            if (heapHistoTotal == null) {
                heapHistoTotal = heapHisto;
                continue;
            }
            heapHistoTotal.add(heapHisto);
        }
        return heapHistoTotal;
    }

    DatabaseInformations collectDatabaseInformations(int requestIndex) throws IOException {
        URL url = this.urls.get(0);
        URL databaseUrl = new URL(url.toString() + '&' + "part" + '=' + "database" + '&' + "request" + '=' + requestIndex);
        return (DatabaseInformations)this.collectForUrl(databaseUrl);
    }

    List<List<ConnectionInformations>> collectConnectionInformations() throws IOException {
        ArrayList<List<ConnectionInformations>> connectionInformations = new ArrayList<List<ConnectionInformations>>();
        for (URL url : this.urls) {
            List connections;
            URL connectionsUrl = new URL(url.toString() + '&' + "part" + '=' + "connections");
            Object result = this.collectForUrl(connectionsUrl);
            if (result instanceof List && !((List)result).isEmpty() && ((List)result).get(0) instanceof List) {
                connections = (List)result;
                connectionInformations.addAll(connections);
                continue;
            }
            connections = (List)result;
            connectionInformations.add(connections);
        }
        return connectionInformations;
    }

    Map<String, List<ProcessInformations>> collectProcessInformations() throws IOException {
        String title = I18N.getString("Processus");
        LinkedHashMap<String, List<ProcessInformations>> processesByTitle = new LinkedHashMap<String, List<ProcessInformations>>();
        for (URL url : this.urls) {
            URL processUrl = new URL(url.toString() + '&' + "part" + '=' + "processes");
            Object result = this.collectForUrl(processUrl);
            if (result instanceof Map) {
                Map processByTitle = (Map)result;
                for (Map.Entry entry : processByTitle.entrySet()) {
                    String node = (String)entry.getKey();
                    if (!node.startsWith(title)) {
                        node = title + " (" + (String)entry.getKey() + ')';
                    }
                    List processList = (List)entry.getValue();
                    processesByTitle.put(node, processList);
                }
                continue;
            }
            List processList = (List)result;
            processesByTitle.put(title + " (" + RemoteCollector.getHostAndPort(url) + ')', processList);
        }
        return processesByTitle;
    }

    List<JndiBinding> collectJndiBindings(String path) throws IOException {
        URL url = this.urls.get(0);
        URL jndiUrl = new URL(url.toString() + '&' + "part" + '=' + "jndi" + (path != null ? "&path=" + path : ""));
        return (List)this.collectForUrl(jndiUrl);
    }

    Map<String, List<MBeanNode>> collectMBeans() throws IOException {
        String title = I18N.getString("MBeans");
        LinkedHashMap<String, List<MBeanNode>> mbeansByTitle = new LinkedHashMap<String, List<MBeanNode>>();
        for (URL url : this.urls) {
            URL mbeansUrl = new URL(url.toString() + '&' + "part" + '=' + "mbeans");
            Object result = this.collectForUrl(mbeansUrl);
            if (result instanceof Map) {
                Map mbeansByNodeName = (Map)result;
                for (Map.Entry entry : mbeansByNodeName.entrySet()) {
                    String node = (String)entry.getKey();
                    if (!node.startsWith(title)) {
                        node = title + " (" + (String)entry.getKey() + ')';
                    }
                    List mbeans = (List)entry.getValue();
                    mbeansByTitle.put(node, mbeans);
                }
                continue;
            }
            List mbeans = (List)result;
            mbeansByTitle.put(title + " (" + RemoteCollector.getHostAndPort(url) + ')', mbeans);
        }
        return mbeansByTitle;
    }

    Map<JavaInformations, List<CounterRequestContext>> collectCurrentRequests() throws IOException {
        LinkedHashMap<JavaInformations, List<CounterRequestContext>> requests = new LinkedHashMap<JavaInformations, List<CounterRequestContext>>();
        for (URL url : this.urls) {
            URL currentRequestsUrl = new URL(url.toString() + '&' + "part" + '=' + "currentRequests");
            Map result = (Map)this.collectForUrl(currentRequestsUrl);
            requests.putAll(result);
        }
        return requests;
    }

    List<List<ThreadInformations>> getThreadInformationsLists() {
        ArrayList<List<ThreadInformations>> result = new ArrayList<List<ThreadInformations>>();
        for (JavaInformations javaInformations : this.javaInformationsList) {
            result.add(new ArrayList<ThreadInformations>(javaInformations.getThreadInformationsList()));
        }
        return result;
    }

    Map<String, byte[]> collectJRobins(int width, int height) throws IOException {
        URL url = this.urls.get(0);
        URL jrobinNamesUrl = new URL(url.toString() + '&' + "part" + '=' + "jrobins" + '&' + "width" + '=' + width + '&' + "height" + '=' + height);
        return (Map)this.collectForUrl(jrobinNamesUrl);
    }

    Map<String, byte[]> collectOtherJRobins(int width, int height) throws IOException {
        URL url = this.urls.get(0);
        URL otherJRobinNamesUrl = new URL(url.toString() + '&' + "part" + '=' + "otherJRobins" + '&' + "width" + '=' + width + '&' + "height" + '=' + height);
        return (Map)this.collectForUrl(otherJRobinNamesUrl);
    }

    byte[] collectJRobin(String graphName, int width, int height) throws IOException {
        URL url = this.urls.get(0);
        URL jrobinUrl = new URL(url.toString() + '&' + "graph" + '=' + graphName + '&' + "part" + '=' + "jrobins" + '&' + "width" + '=' + width + '&' + "height" + '=' + height);
        return (byte[])this.collectForUrl(jrobinUrl);
    }

    String collectSqlRequestExplainPlan(String sqlRequest) throws IOException {
        URL url = this.urls.get(0);
        URL explainPlanUrl = new URL(url.toString() + '&' + "part" + '=' + "explainPlan");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("request", sqlRequest);
        if (this.cookies != null) {
            headers.put("Cookie", this.cookies);
        }
        LabradorRetriever labradorRetriever = new LabradorRetriever(explainPlanUrl, headers);
        return (String)labradorRetriever.call();
    }

    private void addRequestsAndErrors(List<Counter> counters) {
        for (Counter newCounter : counters) {
            Counter counter = this.collector.getCounterByName(newCounter.getName());
            counter.setDisplayed(newCounter.isDisplayed());
            counter.addRequestsAndErrors(newCounter);
        }
    }

    private <T> T collectForUrl(URL url) throws IOException {
        LabradorRetriever labradorRetriever;
        if (this.cookies != null) {
            Map<String, String> headers = Collections.singletonMap("Cookie", this.cookies);
            labradorRetriever = new LabradorRetriever(url, headers);
        } else {
            labradorRetriever = new LabradorRetriever(url);
        }
        return labradorRetriever.call();
    }

    static String getHostAndPort(URL url) {
        if (url.getPort() != -1) {
            return url.getHost() + ':' + url.getPort();
        }
        return url.getHost();
    }

    String getApplication() {
        return this.application;
    }

    List<URL> getURLs() {
        return this.urls;
    }

    Collector getCollector() {
        return this.collector;
    }

    List<JavaInformations> getJavaInformationsList() {
        return this.javaInformationsList;
    }

    Map<JavaInformations, List<CounterRequestContext>> getCurrentRequests() {
        return this.currentRequests;
    }

    void setURLs(List<URL> newURLs) {
        assert (this.urls != null);
        this.urls = newURLs;
    }

    void setCookies(String cookies) {
        this.cookies = cookies;
    }

    void disableAggregation() {
        this.aggregationDisabled = true;
    }
}

