/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.bull.javamelody.LOG;
import net.bull.javamelody.PluginMonitoringFilter;

public class JiraMonitoringFilter
extends PluginMonitoringFilter {
    private static final boolean PLUGIN_AUTHENTICATION_DISABLED = Boolean.parseBoolean(System.getProperty("javamelody.plugin-authentication-disabled"));
    private static final int SYSTEM_ADMIN = 44;
    private static final String LOGGED_IN_KEY = "seraph_defaultauthenticator_user";
    private static final List<String> JIRA_USER_CLASSES = Arrays.asList("com.atlassian.jira.user.ApplicationUser", "com.atlassian.crowd.embedded.api.User", "com.opensymphony.user.User");
    private final boolean jira = JiraMonitoringFilter.isJira();
    private final boolean confluence = JiraMonitoringFilter.isConfluence();
    private final boolean bamboo = JiraMonitoringFilter.isBamboo();

    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        if (this.jira) {
            LOG.debug("JavaMelody is monitoring JIRA");
        } else if (this.confluence) {
            LOG.debug("JavaMelody is monitoring Confluence");
        } else if (this.bamboo) {
            LOG.debug("JavaMelody is monitoring Bamboo");
        } else {
            LOG.debug("JavaMelody is monitoring unknown, access to monitoring reports is not secured by JavaMelody");
        }
        if (PLUGIN_AUTHENTICATION_DISABLED) {
            LOG.debug("Authentication for monitoring reports has been disabled");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            super.doFilter(request, response, chain);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (httpRequest.getRequestURI().equals(this.getMonitoringUrl(httpRequest)) && this.hasNotPermission(httpRequest, httpResponse)) {
            return;
        }
        super.doFilter(request, response, chain);
    }

    private boolean hasNotPermission(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        return !PLUGIN_AUTHENTICATION_DISABLED && (this.jira && !this.checkJiraAdminPermission(httpRequest, httpResponse) || this.confluence && !this.checkConfluenceAdminPermission(httpRequest, httpResponse) || this.bamboo && !this.checkBambooAdminPermission(httpRequest, httpResponse));
    }

    private boolean checkJiraAdminPermission(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        Object user = JiraMonitoringFilter.getUser(httpRequest);
        if (user == null) {
            String destination = this.getMonitoringUrl(httpRequest).substring(httpRequest.getContextPath().length());
            httpResponse.sendRedirect("login.jsp?os_destination=" + destination);
            return false;
        }
        if (!JiraMonitoringFilter.hasJiraSystemAdminPermission(user)) {
            httpResponse.sendError(403, "Forbidden access");
            return false;
        }
        return true;
    }

    private boolean checkConfluenceAdminPermission(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        Object user = JiraMonitoringFilter.getUser(httpRequest);
        if (user == null) {
            String destination = this.getMonitoringUrl(httpRequest).substring(httpRequest.getContextPath().length());
            httpResponse.sendRedirect("login.action?os_destination=" + destination);
            return false;
        }
        if (!JiraMonitoringFilter.hasConfluenceAdminPermission(user)) {
            httpResponse.sendError(403, "Forbidden access");
            return false;
        }
        return true;
    }

    private boolean checkBambooAdminPermission(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        Object user = JiraMonitoringFilter.getUser(httpRequest);
        if (user == null) {
            String destination = this.getMonitoringUrl(httpRequest).substring(httpRequest.getContextPath().length());
            httpResponse.sendRedirect("userlogin!default.action?os_destination=" + destination);
            return false;
        }
        if (!JiraMonitoringFilter.hasBambooAdminPermission(user)) {
            httpResponse.sendError(403, "Forbidden access");
            return false;
        }
        return true;
    }

    private static boolean hasJiraSystemAdminPermission(Object user) {
        try {
            Class<?> managerFactoryClass = Class.forName("com.atlassian.jira.ManagerFactory");
            Object permissionManager = managerFactoryClass.getMethod("getPermissionManager", new Class[0]).invoke(null, new Object[0]);
            Exception firstException = null;
            for (String className : JIRA_USER_CLASSES) {
                try {
                    Class<?> userClass = Class.forName(className);
                    Boolean result = (Boolean)permissionManager.getClass().getMethod("hasPermission", Integer.TYPE, userClass).invoke(permissionManager, 44, user);
                    return result;
                }
                catch (Exception e) {
                    if (firstException != null) continue;
                    firstException = e;
                }
            }
            throw firstException;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static boolean hasConfluenceAdminPermission(Object user) {
        try {
            Class<?> containerManagerClass = Class.forName("com.atlassian.spring.container.ContainerManager");
            Class<?> userClass = Class.forName("com.atlassian.user.User");
            Object permissionManager = containerManagerClass.getMethod("getComponent", String.class).invoke(null, "permissionManager");
            Boolean result = (Boolean)permissionManager.getClass().getMethod("isConfluenceAdministrator", userClass).invoke(permissionManager, user);
            return result;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static boolean hasBambooAdminPermission(Object user) {
        try {
            Boolean result;
            Class<?> containerManagerClass = Class.forName("com.atlassian.spring.container.ContainerManager");
            Object bambooPermissionManager = containerManagerClass.getMethod("getComponent", String.class).invoke(null, "bambooPermissionManager");
            try {
                result = (Boolean)bambooPermissionManager.getClass().getMethod("isSystemAdmin", String.class).invoke(bambooPermissionManager, user.toString());
            }
            catch (NoSuchMethodException e) {
                Class<?> globalApplicationSecureObjectClass = Class.forName("com.atlassian.bamboo.security.GlobalApplicationSecureObject");
                Object globalApplicationSecureObject = globalApplicationSecureObjectClass.getField("INSTANCE").get(null);
                result = (Boolean)bambooPermissionManager.getClass().getMethod("hasPermission", String.class, String.class, Object.class).invoke(bambooPermissionManager, user.toString(), "ADMIN", globalApplicationSecureObject);
            }
            return result;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static Object getUser(HttpServletRequest httpRequest) {
        HttpSession session = httpRequest.getSession(false);
        if (session == null) {
            return null;
        }
        Object result = session.getAttribute(LOGGED_IN_KEY);
        if (result != null && "com.atlassian.confluence.user.SessionSafePrincipal".equals(result.getClass().getName())) {
            String userName = result.toString();
            try {
                Class<?> containerManagerClass = Class.forName("com.atlassian.spring.container.ContainerManager");
                Object userAccessor = containerManagerClass.getMethod("getComponent", String.class).invoke(null, "userAccessor");
                result = userAccessor.getClass().getMethod("getUser", String.class).invoke(userAccessor, userName);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return result;
    }

    private static boolean isJira() {
        try {
            Class.forName("com.atlassian.jira.ManagerFactory");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean isConfluence() {
        try {
            Class.forName("com.atlassian.confluence.security.PermissionManager");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean isBamboo() {
        try {
            Class.forName("com.atlassian.bamboo.security.BambooPermissionManager");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

