/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpSession;
import net.bull.javamelody.I18N;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SessionInformations
implements Serializable {
    static final String SESSION_COUNTRY_KEY = "javamelody.country";
    static final String SESSION_REMOTE_ADDR = "javamelody.remoteAddr";
    static final String SESSION_REMOTE_USER = "javamelody.remoteUser";
    private static final long serialVersionUID = -2689338895804445093L;
    private static final ByteArrayOutputStream TEMP_OUTPUT = new ByteArrayOutputStream(8192);
    private final String id;
    private final Date lastAccess;
    private final Date age;
    private final Date expirationDate;
    private final int attributeCount;
    private final boolean serializable;
    private final String country;
    private final String remoteAddr;
    private final String remoteUser;
    private final int serializedSize;
    private final List<SessionAttribute> attributes;

    SessionInformations(HttpSession session, boolean includeAttributes) {
        assert (session != null);
        this.id = session.getId();
        long now = System.currentTimeMillis();
        this.lastAccess = new Date(now - session.getLastAccessedTime());
        this.age = new Date(now - session.getCreationTime());
        this.expirationDate = new Date(session.getLastAccessedTime() + (long)session.getMaxInactiveInterval() * 1000L);
        ArrayList<String> attributeNames = Collections.list(session.getAttributeNames());
        this.attributeCount = attributeNames.size();
        this.serializable = this.computeSerializable(session, attributeNames);
        Object countryCode = session.getAttribute(SESSION_COUNTRY_KEY);
        this.country = countryCode == null ? null : countryCode.toString().toLowerCase(Locale.getDefault());
        Object addr = session.getAttribute(SESSION_REMOTE_ADDR);
        this.remoteAddr = addr == null ? null : addr.toString();
        Object user = session.getAttribute(SESSION_REMOTE_USER);
        if (user == null && (user = session.getAttribute("ACEGI_SECURITY_LAST_USERNAME")) == null) {
            user = session.getAttribute("SPRING_SECURITY_LAST_USERNAME");
        }
        this.remoteUser = user == null ? null : user.toString();
        this.serializedSize = this.computeSerializedSize(session, attributeNames);
        if (includeAttributes) {
            this.attributes = new ArrayList<SessionAttribute>(this.attributeCount);
            for (String attributeName : attributeNames) {
                this.attributes.add(new SessionAttribute(session, attributeName));
            }
        } else {
            this.attributes = null;
        }
    }

    private boolean computeSerializable(HttpSession session, List<String> attributeNames) {
        for (String attributeName : attributeNames) {
            Object attributeValue = session.getAttribute(attributeName);
            if (attributeValue == null || attributeValue instanceof Serializable) continue;
            return false;
        }
        return true;
    }

    private int computeSerializedSize(HttpSession session, List<String> attributeNames) {
        if (!this.serializable) {
            return -1;
        }
        ArrayList<Serializable> serializableAttributes = new ArrayList<Serializable>(attributeNames.size());
        for (String attributeName : attributeNames) {
            Object attributeValue = session.getAttribute(attributeName);
            serializableAttributes.add((Serializable)attributeValue);
        }
        return SessionInformations.getObjectSize(serializableAttributes);
    }

    String getId() {
        return this.id;
    }

    Date getLastAccess() {
        return this.lastAccess;
    }

    Date getAge() {
        return this.age;
    }

    Date getExpirationDate() {
        return this.expirationDate;
    }

    int getAttributeCount() {
        return this.attributeCount;
    }

    boolean isSerializable() {
        return this.serializable;
    }

    String getCountry() {
        return this.country;
    }

    String getCountryDisplay() {
        String myCountry = this.getCountry();
        if (myCountry == null) {
            return null;
        }
        return new Locale("fr", myCountry).getDisplayCountry(I18N.getCurrentLocale());
    }

    String getRemoteAddr() {
        return this.remoteAddr;
    }

    String getRemoteUser() {
        return this.remoteUser;
    }

    int getSerializedSize() {
        return this.serializedSize;
    }

    List<SessionAttribute> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.getId() + ", remoteAddr=" + this.getRemoteAddr() + ", serializedSize=" + this.getSerializedSize() + ']';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getObjectSize(Object object) {
        if (!(object instanceof Serializable)) {
            return -1;
        }
        Serializable serializable = (Serializable)object;
        ByteArrayOutputStream byteArrayOutputStream = TEMP_OUTPUT;
        synchronized (byteArrayOutputStream) {
            TEMP_OUTPUT.reset();
            try {
                ObjectOutputStream out = new ObjectOutputStream(TEMP_OUTPUT);
                try {
                    out.writeObject(serializable);
                }
                finally {
                    out.close();
                }
                return TEMP_OUTPUT.size();
            }
            catch (Throwable e) {
                return -1;
            }
        }
    }

    static class SessionAttribute
    implements Serializable {
        private static final long serialVersionUID = 4786854834871331127L;
        private final String name;
        private final String type;
        private final String content;
        private final boolean serializable;
        private final int serializedSize;

        SessionAttribute(HttpSession session, String attributeName) {
            assert (session != null);
            assert (attributeName != null);
            this.name = attributeName;
            Object value = session.getAttribute(attributeName);
            this.serializable = value == null || value instanceof Serializable;
            this.serializedSize = SessionInformations.getObjectSize(value);
            if (value == null) {
                this.content = null;
                this.type = null;
            } else {
                String tmp;
                try {
                    tmp = String.valueOf(value);
                }
                catch (Exception e) {
                    tmp = e.toString();
                }
                this.content = tmp;
                this.type = value.getClass().getName();
            }
        }

        String getName() {
            return this.name;
        }

        String getType() {
            return this.type;
        }

        String getContent() {
            return this.content;
        }

        boolean isSerializable() {
            return this.serializable;
        }

        int getSerializedSize() {
            return this.serializedSize;
        }
    }
}

