/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.ProviderUtil;
import net.bull.javamelody.Counter;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.JpaOverridePersistenceXmlClassLoader;
import net.bull.javamelody.JpaWrapper;
import net.bull.javamelody.LOG;
import net.bull.javamelody.MonitoringProxy;
import net.bull.javamelody.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaPersistence
implements PersistenceProvider {
    private static final Counter JPA_COUNTER = MonitoringProxy.getJpaCounter();
    private static final boolean COUNTER_HIDDEN = Parameters.isCounterHidden(JPA_COUNTER.getName());
    private static final String OWN_PACKAGE = JpaPersistence.class.getName().substring(0, JpaPersistence.class.getName().lastIndexOf(46));
    private static final String DELEGATE_PROVIDER_KEY = OWN_PACKAGE + ".jpa.provider";
    private static final String[] PROVIDERS = new String[]{"org.apache.openjpa.persistence.PersistenceProviderImpl", "org.hibernate.jpa.HibernatePersistenceProvider", "org.hibernate.ejb.HibernatePersistence", "org.eclipse.persistence.jpa.PersistenceProvider", "oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider", "oracle.toplink.essentials.PersistenceProvider", "me.prettyprint.hom.CassandraPersistenceProvider", "org.datanucleus.jpa.PersistenceProviderImpl", "com.orientechnologies.orient.core.db.object.jpa.OJPAPersistenceProvider", "com.orientechnologies.orient.object.jpa.OJPAPersistenceProvider", "com.spaceprogram.simplejpa.PersistenceProviderImpl"};
    private volatile PersistenceProvider delegate;

    private void initJpaCounter() {
        JPA_COUNTER.setDisplayed(!COUNTER_HIDDEN);
        JPA_COUNTER.setUsed(true);
        LOG.debug("jpa persistence initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityManagerFactory createEntityManagerFactory(String unit, Map map) {
        this.initJpaCounter();
        final PersistenceProvider persistenceProvider = this.findDelegate(map);
        final ClassLoader tccl = JpaPersistence.tccl();
        ClassLoader hack = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return new JpaOverridePersistenceXmlClassLoader(tccl, persistenceProvider.getClass().getName());
            }
        });
        Thread.currentThread().setContextClassLoader(hack);
        try {
            EntityManagerFactory entityManagerFactory = persistenceProvider.createEntityManagerFactory(unit, map);
            if (entityManagerFactory == null) {
                EntityManagerFactory entityManagerFactory2 = null;
                return entityManagerFactory2;
            }
            EntityManagerFactory entityManagerFactory3 = JpaWrapper.createEntityManagerFactoryProxy(entityManagerFactory);
            return entityManagerFactory3;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map map) {
        this.initJpaCounter();
        PersistenceProvider persistenceProvider = this.findDelegate(map);
        PersistenceUnitInfo proxiedInfo = this.createPersistentUnitInfoProxy(info, persistenceProvider);
        EntityManagerFactory entityManagerFactory = persistenceProvider.createContainerEntityManagerFactory(proxiedInfo, map);
        if (entityManagerFactory == null) {
            return null;
        }
        return JpaWrapper.createEntityManagerFactoryProxy(entityManagerFactory);
    }

    private PersistenceUnitInfo createPersistentUnitInfoProxy(PersistenceUnitInfo info, PersistenceProvider persistenceProvider) {
        ProviderAwareHandler invocationHandler = new ProviderAwareHandler(persistenceProvider.getClass().getName(), info);
        return JdbcWrapper.createProxy(info, invocationHandler);
    }

    public ProviderUtil getProviderUtil() {
        return this.loadOrGuessDelegate(null).getProviderUtil();
    }

    private PersistenceProvider findDelegate(Map<?, ?> map) {
        if (map == null) {
            return this.loadOrGuessDelegate(null);
        }
        return this.loadOrGuessDelegate((String)String.class.cast(map.get(DELEGATE_PROVIDER_KEY)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PersistenceProvider loadOrGuessDelegate(String name) {
        if (this.delegate == null) {
            JpaPersistence jpaPersistence = this;
            synchronized (jpaPersistence) {
                if (this.delegate == null) {
                    if (name == null) {
                        this.guessDelegate();
                    } else {
                        try {
                            this.delegate = JpaPersistence.newPersistence(name);
                        }
                        catch (Exception e) {
                            throw new IllegalStateException(new ClassNotFoundException("Can't instantiate '" + name + "'", e));
                        }
                    }
                }
            }
        }
        if (name != null && !this.delegate.getClass().getName().equals(name)) {
            try {
                return JpaPersistence.newPersistence(name);
            }
            catch (Exception e) {
                throw new IllegalStateException(new ClassNotFoundException("Can't instantiate '" + name + "'", e));
            }
        }
        return this.delegate;
    }

    private void guessDelegate() {
        for (String provider : PROVIDERS) {
            try {
                this.delegate = JpaPersistence.newPersistence(provider);
            }
            catch (Throwable th2) {
                // empty catch block
            }
        }
        if (this.delegate == null) {
            throw new IllegalStateException(new ClassNotFoundException("Can't find a delegate"));
        }
    }

    private static ClassLoader tccl() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static PersistenceProvider newPersistence(String name) throws Exception {
        return (PersistenceProvider)PersistenceProvider.class.cast(JpaPersistence.tccl().loadClass(name).newInstance());
    }

    private static class ProviderAwareHandler
    implements InvocationHandler {
        private final String provider;
        private final PersistenceUnitInfo info;

        ProviderAwareHandler(String provider, PersistenceUnitInfo info) {
            this.provider = provider;
            this.info = info;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if ("getPersistenceProviderClassName".equals(method.getName())) {
                return this.provider;
            }
            return method.invoke((Object)this.info, args);
        }
    }
}

