/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Set;
import javax.sql.DataSource;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.LOG;
import net.bull.javamelody.Parameters;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.PriorityOrdered;
import org.springframework.jndi.JndiObjectFactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringDataSourceBeanPostProcessor
implements BeanPostProcessor,
PriorityOrdered {
    private Set<String> excludedDatasources;
    private int order = Integer.MAX_VALUE;

    public void setExcludedDatasources(Set<String> excludedDatasources) {
        this.excludedDatasources = excludedDatasources;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    private boolean isExcludedDataSource(String beanName) {
        if (this.excludedDatasources != null && this.excludedDatasources.contains(beanName)) {
            LOG.debug("Spring datasource excluded: " + beanName);
            return true;
        }
        return false;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof DataSource) {
            if (this.isExcludedDataSource(beanName) || Parameters.isNoDatabase()) {
                return bean;
            }
            DataSource dataSource = (DataSource)bean;
            JdbcWrapper.registerSpringDataSource(beanName, dataSource);
            DataSource result = JdbcWrapper.SINGLETON.createDataSourceProxy(beanName, dataSource);
            LOG.debug("Spring datasource wrapped: " + beanName);
            return result;
        }
        if (bean instanceof JndiObjectFactoryBean) {
            if (this.isExcludedDataSource(beanName) || Parameters.isNoDatabase()) {
                return bean;
            }
            Object result = this.createProxy(bean, beanName);
            LOG.debug("Spring JNDI factory wrapped: " + beanName);
            return result;
        }
        return bean;
    }

    private Object createProxy(final Object bean, final String beanName) {
        InvocationHandler invocationHandler = new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object result = method.invoke(bean, args);
                if (result instanceof DataSource) {
                    result = JdbcWrapper.SINGLETON.createDataSourceProxy(beanName, (DataSource)result);
                }
                return result;
            }
        };
        return JdbcWrapper.createProxy(bean, invocationHandler);
    }
}

