/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.Writer;
import net.bull.javamelody.I18N;

abstract class HtmlAbstractReport {
    private static final boolean PDF_ENABLED = HtmlAbstractReport.computePdfEnabled();
    private final Writer writer;

    HtmlAbstractReport(Writer writer) {
        assert (writer != null);
        this.writer = writer;
    }

    abstract void toHtml() throws IOException;

    Writer getWriter() {
        return this.writer;
    }

    void writeDirectly(String html) throws IOException {
        this.writer.write(html);
    }

    void write(String html) throws IOException {
        I18N.writeTo(html, this.writer);
    }

    void writeln(String html) throws IOException {
        I18N.writelnTo(html, this.writer);
    }

    void writeTitle(String imageFileName, String title) throws IOException {
        this.writeDirectly("<span class='chapterTitle'><img src='?resource=");
        this.writeDirectly(imageFileName);
        this.writeDirectly("' alt=\"");
        this.writeDirectly(title);
        this.writeDirectly("\" />&nbsp;");
        this.writeDirectly("<b>");
        this.writeDirectly(title);
        this.writeDirectly("</b></span><br/>\n");
    }

    void writeShowHideLink(String idToShow, String label) throws IOException {
        this.writeln("<a href=\"javascript:showHide('" + idToShow + "');\" class='noPrint'><img id='" + idToShow + "Img' src='?resource=bullets/plus.png' alt=''/> " + label + "</a>");
    }

    static String getString(String key) {
        return I18N.getString(key);
    }

    static String getStringForJavascript(String key) {
        return I18N.getStringForJavascript(key);
    }

    static String getFormattedString(String key, Object ... arguments) {
        return I18N.getFormattedString(key, arguments);
    }

    static String javascriptEncode(String text) {
        return I18N.javascriptEncode(text);
    }

    static String urlEncode(String text) {
        return I18N.urlEncode(text);
    }

    static String htmlEncode(String text) {
        return I18N.htmlEncode(text, true);
    }

    static String htmlEncodeButNotSpace(String text) {
        return I18N.htmlEncode(text, false);
    }

    static boolean isPdfEnabled() {
        return PDF_ENABLED;
    }

    private static boolean computePdfEnabled() {
        try {
            Class.forName("com.lowagie.text.Document");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    class HtmlTable {
        private boolean firstRow = true;
        private boolean oddRow;

        HtmlTable() {
        }

        void beginTable(String summary) throws IOException {
            HtmlAbstractReport.this.writeDirectly("<table class='sortable' width='100%' border='1' summary='");
            HtmlAbstractReport.this.writeDirectly(summary);
            HtmlAbstractReport.this.writeDirectly("'>\n");
            HtmlAbstractReport.this.writeDirectly("<thead><tr>");
        }

        void nextRow() throws IOException {
            HtmlAbstractReport.this.writeDirectly("</tr>");
            if (this.firstRow) {
                this.firstRow = false;
                HtmlAbstractReport.this.writeDirectly("</thead><tbody>\n");
            }
            if (this.oddRow) {
                HtmlAbstractReport.this.writeDirectly("<tr class='odd' onmouseover=\"this.className='highlight'\" onmouseout=\"this.className='odd'\">\n");
            } else {
                HtmlAbstractReport.this.writeDirectly("<tr onmouseover=\"this.className='highlight'\" onmouseout=\"this.className=''\">\n");
            }
            this.oddRow = !this.oddRow;
        }

        void endTable() throws IOException {
            HtmlAbstractReport.this.writeDirectly("</tr>");
            if (this.firstRow) {
                this.firstRow = false;
                HtmlAbstractReport.this.writeDirectly("</thead><tbody>\n");
            }
            HtmlAbstractReport.this.writeDirectly("</tbody></table>\n");
        }
    }
}

