/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import javax.sql.DataSource;
import net.bull.javamelody.JdbcWrapper;
import net.bull.javamelody.LOG;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class SpringDataSourceFactoryBean
extends AbstractFactoryBean {
    private String targetName;

    public void setTargetName(String targetName) {
        assert (targetName != null);
        this.targetName = targetName;
    }

    protected DataSource createInstance() {
        if (this.targetName == null) {
            throw new IllegalStateException("targetName must not be null");
        }
        DataSource dataSource = (DataSource)this.getBeanFactory().getBean(this.targetName, DataSource.class);
        JdbcWrapper.registerSpringDataSource(this.targetName, dataSource);
        DataSource result = JdbcWrapper.SINGLETON.createDataSourceProxy(this.targetName, dataSource);
        LOG.debug("Spring target datasource wrapped: " + this.targetName);
        return result;
    }

    public Class<?> getObjectType() {
        return DataSource.class;
    }
}

