/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import net.bull.javamelody.HtmlAbstractReport;
import net.bull.javamelody.JavaHTMLizer;
import net.bull.javamelody.LabradorRetriever;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;

class HtmlSourceReport
extends HtmlAbstractReport {
    private static final String MAVEN_CENTRAL = "http://repo1.maven.org/maven2";
    private static final File LOCAL_REPO = new File(System.getProperty("user.home") + "/.m2/repository");
    private static final File JDK_SRC_FILE = HtmlSourceReport.getJdkSrcFile();
    private final String source;

    HtmlSourceReport(String className, Writer writer) throws IOException {
        super(writer);
        this.source = className.indexOf(36) == -1 ? this.getSource(className) : this.getSource(className.substring(0, className.indexOf(36)));
    }

    private String getSource(String className) throws IOException {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        if (clazz.getName().startsWith("java.") || clazz.getName().startsWith("javax.") && clazz.getProtectionDomain().getCodeSource() == null) {
            if (JDK_SRC_FILE != null) {
                return this.getSourceFromJar(clazz, JDK_SRC_FILE);
            }
            return null;
        }
        return this.getSourceFromMavenRepo(clazz);
    }

    private static File getJdkSrcFile() {
        File srcZipFile;
        File file = new File(System.getProperty("java.home"));
        if ("jre".equalsIgnoreCase(file.getName())) {
            file = file.getParentFile();
        }
        if ((srcZipFile = new File(file, "src.zip")).exists()) {
            return srcZipFile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSourceFromJar(Class<?> clazz, File srcJarFile) throws ZipException, IOException {
        ZipFile zipFile = new ZipFile(srcJarFile);
        try {
            ZipEntry entry = zipFile.getEntry(clazz.getName().replace('.', '/') + ".java");
            if (entry == null) {
                String string = null;
                return string;
            }
            StringWriter writer = new StringWriter();
            InputStream inputStream = zipFile.getInputStream(entry);
            try {
                InputStreamReader reader = new InputStreamReader(inputStream, Charset.forName("UTF-8"));
                try {
                    char[] chars = new char[1024];
                    int read = reader.read(chars);
                    while (read != -1) {
                        writer.write(chars, 0, read);
                        read = reader.read(chars);
                    }
                }
                finally {
                    ((Reader)reader).close();
                }
            }
            finally {
                inputStream.close();
            }
            String string = writer.toString();
            return string;
        }
        finally {
            zipFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSourceFromMavenRepo(Class<?> clazz) throws IOException {
        Map<String, String> mavenCoordinates = this.getMavenCoordinates(clazz);
        if (mavenCoordinates == null) {
            return null;
        }
        String groupId = mavenCoordinates.get("groupId");
        String artifactId = mavenCoordinates.get("artifactId");
        String version = mavenCoordinates.get("version");
        File storageDirectory = Parameters.getStorageDirectory(Parameters.getCurrentApplication());
        File srcJarFile = new File(storageDirectory, "sources/" + artifactId + '-' + version + "-sources.jar");
        if (!srcJarFile.exists() || srcJarFile.length() == 0L) {
            for (String mavenRepository : this.getMavenRepositories()) {
                String url = mavenRepository + '/' + groupId.replace('.', '/') + '/' + artifactId + '/' + version + '/' + artifactId + '-' + version + "-sources.jar";
                if (!url.startsWith("http")) {
                    if (!new File(url).exists()) continue;
                    return this.getSourceFromJar(clazz, new File(url));
                }
                this.mkdirs(srcJarFile);
                FileOutputStream output = new FileOutputStream(srcJarFile);
                try {
                    URL sourceUrl = new URL(url);
                    LabradorRetriever labradorRetriever = new LabradorRetriever(sourceUrl);
                    labradorRetriever.downloadTo(output);
                    break;
                }
                catch (IOException e) {
                    ((OutputStream)output).close();
                    this.delete(srcJarFile);
                }
                finally {
                    ((OutputStream)output).close();
                }
            }
        }
        if (srcJarFile.exists()) {
            return this.getSourceFromJar(clazz, srcJarFile);
        }
        return null;
    }

    private void mkdirs(File directory) {
        if (!directory.getParentFile().exists() && !directory.getParentFile().mkdirs()) {
            throw new IllegalStateException("Can't create directory " + directory.getParentFile().getPath());
        }
    }

    private boolean delete(File file) {
        return file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getMavenCoordinates(Class<?> clazz) throws IOException {
        CodeSource codeSource = clazz.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            return null;
        }
        URL location = codeSource.getLocation();
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(location.openStream(), 4096));
        try {
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                if (entry.getName().startsWith("META-INF/") && entry.getName().endsWith("/pom.properties")) {
                    Properties properties = new Properties();
                    properties.load(zipInputStream);
                    HashMap<Object, Object> hashMap = new HashMap<Object, Object>(properties);
                    return hashMap;
                }
                zipInputStream.closeEntry();
                entry = zipInputStream.getNextEntry();
            }
        }
        finally {
            zipInputStream.close();
        }
        return null;
    }

    private List<String> getMavenRepositories() {
        String parameter = Parameters.getParameter(Parameter.MAVEN_REPOSITORIES);
        if (parameter != null) {
            ArrayList<String> result = new ArrayList<String>();
            for (String repo : parameter.split(",")) {
                result.add(repo.trim());
            }
            return result;
        }
        return Arrays.asList(LOCAL_REPO.getPath(), MAVEN_CENTRAL);
    }

    @Override
    void toHtml() throws IOException {
        if (this.source != null) {
            String html = JavaHTMLizer.htmlize(this.source);
            html = JavaHTMLizer.addLineNumbers(html);
            this.writeDirectly("<code>");
            this.writeDirectly(html);
            this.writeDirectly("</code>");
        } else {
            this.write("#source_not_found#");
        }
    }

    static String htmlEncodeStackTraceElement(String element) {
        if (element.endsWith(")") && !element.endsWith("(Native Method)") && !element.endsWith("(Unknown Source)")) {
            int index0;
            int index3 = element.lastIndexOf(58);
            int index2 = element.lastIndexOf(40);
            int index1 = element.lastIndexOf(46, index2);
            if (index1 > (index0 = element.lastIndexOf(32, index1)) && index2 != -1 && index3 > index2) {
                String classNameEncoded = HtmlSourceReport.urlEncode(element.substring(index0 + 1, index1));
                return HtmlSourceReport.htmlEncodeButNotSpace(element.substring(0, index2 + 1)) + "<a href='?part=" + "source" + "&amp;class=" + classNameEncoded + '#' + HtmlSourceReport.urlEncode(element.substring(index3 + 1, element.length() - 1)) + "' class='lightwindow' type='external' title='" + classNameEncoded + "'>" + HtmlSourceReport.htmlEncode(element.substring(index2 + 1, element.length() - 1)) + "</a>)";
            }
        }
        return HtmlSourceReport.htmlEncodeButNotSpace(element);
    }

    static String addLinkToClassName(String className) {
        String cleanClassName = className;
        if (cleanClassName.endsWith("[]")) {
            cleanClassName = cleanClassName.substring(0, cleanClassName.length() - 2);
        }
        return "<a href='?part=source&amp;class=" + cleanClassName + "' class='lightwindow' type='external' title='" + cleanClassName + "'>" + className + "</a>";
    }
}

