/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.Serializable;

class CounterRequestRumData
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 745110095604593659L;
    private static final long ABERRANT_VALUE = 300000L;
    private long hits;
    private long networkTimeSum;
    private long domProcessingSum;
    private long pageRenderingSum;

    CounterRequestRumData() {
    }

    long getHits() {
        return this.hits;
    }

    int getNetworkTimeMean() {
        if (this.hits > 0L) {
            return (int)(this.networkTimeSum / this.hits);
        }
        return -1;
    }

    int getDomProcessingMean() {
        if (this.hits > 0L) {
            return (int)(this.domProcessingSum / this.hits);
        }
        return -1;
    }

    int getPageRenderingMean() {
        if (this.hits > 0L) {
            return (int)(this.pageRenderingSum / this.hits);
        }
        return -1;
    }

    void addHit(long networkTime, long domProcessing, long pageRendering) {
        if (networkTime < 0L || networkTime > 300000L || domProcessing < 0L || domProcessing > 300000L || pageRendering < 0L || pageRendering > 300000L) {
            return;
        }
        this.networkTimeSum += networkTime;
        this.domProcessingSum += domProcessing;
        this.pageRenderingSum += pageRendering;
        ++this.hits;
    }

    void addHits(CounterRequestRumData rumData) {
        if (rumData.hits != 0L) {
            this.hits += rumData.hits;
            this.networkTimeSum += rumData.networkTimeSum;
            this.domProcessingSum += rumData.domProcessingSum;
            this.pageRenderingSum += rumData.pageRenderingSum;
        }
    }

    void removeHits(CounterRequestRumData rumData) {
        if (rumData.hits != 0L) {
            this.hits -= rumData.hits;
            this.networkTimeSum -= rumData.networkTimeSum;
            this.domProcessingSum -= rumData.domProcessingSum;
            this.pageRenderingSum -= rumData.pageRenderingSum;
        }
    }

    public CounterRequestRumData clone() {
        try {
            return (CounterRequestRumData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[hits=" + this.hits + ']';
    }
}

