/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.FilterServletOutputStream;

class HtmlInjectorResponseStream
extends FilterServletOutputStream {
    private final HttpServletResponse response;
    private final HtmlToInject htmlToInject;
    private final byte[] beforeTag;
    private boolean injectionCanceled;

    HtmlInjectorResponseStream(HttpServletResponse response, HtmlToInject htmlToInject) throws IOException {
        super(response.getOutputStream());
        this.response = response;
        this.htmlToInject = htmlToInject;
        this.beforeTag = htmlToInject.getBeforeTag().getBytes(response.getCharacterEncoding());
    }

    void cancelInjection() {
        this.injectionCanceled = true;
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        if (this.injectionCanceled) {
            super.write(bytes, off, len);
        } else {
            int index = HtmlInjectorResponseStream.indexOf(bytes, this.beforeTag, off, len);
            if (index == -1) {
                super.write(bytes, off, len);
            } else {
                super.write(bytes, off, index);
                String content = this.htmlToInject.getContent();
                super.write(content.getBytes(this.response.getCharacterEncoding()));
                super.write(bytes, off + index, len - index);
            }
        }
    }

    private static int indexOf(byte[] sourceBytes, byte[] targetBytes, int sourceOffset, int sourceLength) {
        byte first = targetBytes[0];
        int max = sourceOffset + sourceLength - targetBytes.length;
        for (int i = sourceOffset; i <= max; ++i) {
            while (i <= max && sourceBytes[i] != first) {
                ++i;
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetBytes.length - 1;
            int k = 1;
            while (j < end && sourceBytes[j] == targetBytes[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    static interface HtmlToInject {
        public String getContent();

        public String getBeforeTag();
    }
}

