/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.Base64Coder;
import net.bull.javamelody.Counter;
import net.bull.javamelody.DatabaseInformations;
import net.bull.javamelody.HeapHistogram;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.TransportFormat;
import org.apache.log4j.Logger;

class LabradorRetriever {
    private static final Logger LOGGER = Logger.getLogger((String)"javamelody");
    private static final int CONNECTION_TIMEOUT = 20000;
    private static final int READ_TIMEOUT = 60000;
    private final URL url;
    private final Map<String, String> headers;

    LabradorRetriever(URL url) {
        this(url, null);
    }

    LabradorRetriever(URL url, Map<String, String> headers) {
        assert (url != null);
        this.url = url;
        this.headers = headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T call() throws IOException {
        if (LabradorRetriever.shouldMock()) {
            return this.createMockResultOfCall();
        }
        long start = System.currentTimeMillis();
        int dataLength = -1;
        try {
            Serializable result;
            URLConnection connection = LabradorRetriever.openConnection(this.url, this.headers);
            connection.setRequestProperty("Accept-Language", I18N.getCurrentLocale().getLanguage());
            if (this.url.getUserInfo() != null) {
                String authorization = Base64Coder.encodeString(this.url.getUserInfo());
                connection.setRequestProperty("Authorization", "Basic " + authorization);
            }
            connection.connect();
            CounterInputStream counterInputStream = new CounterInputStream(connection.getInputStream());
            try {
                Serializable tmp;
                result = tmp = LabradorRetriever.read(connection, counterInputStream);
            }
            finally {
                counterInputStream.close();
                dataLength = counterInputStream.getDataLength();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("read on " + this.url + " : " + result));
            }
            if (result instanceof RuntimeException) {
                throw (RuntimeException)result;
            }
            if (result instanceof Error) {
                throw (Error)result;
            }
            if (result instanceof IOException) {
                throw (IOException)result;
            }
            if (result instanceof Exception) {
                throw LabradorRetriever.createIOException((Exception)result);
            }
            Serializable serializable = result;
            return (T)serializable;
        }
        catch (ClassNotFoundException e) {
            throw LabradorRetriever.createIOException(e);
        }
        finally {
            LOGGER.info((Object)("http call done in " + (System.currentTimeMillis() - start) + " ms with " + dataLength / 1024 + " KB read for " + this.url));
        }
    }

    private static IOException createIOException(Exception e) {
        return new IOException(e.getMessage(), e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyTo(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        if (LabradorRetriever.shouldMock()) {
            return;
        }
        assert (httpRequest != null);
        assert (httpResponse != null);
        long start = System.currentTimeMillis();
        int dataLength = -1;
        try {
            URLConnection connection = LabradorRetriever.openConnection(this.url, this.headers);
            connection.setRequestProperty("Accept-Language", httpRequest.getHeader("Accept-Language"));
            if (this.url.getUserInfo() != null) {
                String authorization = Base64Coder.encodeString(this.url.getUserInfo());
                connection.setRequestProperty("Authorization", "Basic " + authorization);
            }
            connection.connect();
            httpResponse.setContentType(connection.getContentType());
            ServletOutputStream output = httpResponse.getOutputStream();
            dataLength = this.pump((OutputStream)output, connection);
        }
        finally {
            LOGGER.info((Object)("http call done in " + (System.currentTimeMillis() - start) + " ms with " + dataLength / 1024 + " KB read for " + this.url));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void downloadTo(OutputStream output) throws IOException {
        if (LabradorRetriever.shouldMock()) {
            return;
        }
        assert (output != null);
        long start = System.currentTimeMillis();
        int dataLength = -1;
        try {
            URLConnection connection = LabradorRetriever.openConnection(this.url, this.headers);
            if (this.url.getUserInfo() != null) {
                String authorization = Base64Coder.encodeString(this.url.getUserInfo());
                connection.setRequestProperty("Authorization", "Basic " + authorization);
            }
            connection.connect();
            dataLength = this.pump(output, connection);
        }
        finally {
            LOGGER.info((Object)("http call done in " + (System.currentTimeMillis() - start) + " ms with " + dataLength / 1024 + " KB read for " + this.url));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int pump(OutputStream output, URLConnection connection) throws IOException {
        int dataLength;
        CounterInputStream counterInputStream = new CounterInputStream(connection.getInputStream());
        InputStream input = counterInputStream;
        try {
            if ("gzip".equals(connection.getContentEncoding())) {
                input = new GZIPInputStream(input);
            }
            TransportFormat.pump(input, output);
        }
        finally {
            try {
                input.close();
            }
            finally {
                LabradorRetriever.close(connection);
                dataLength = counterInputStream.getDataLength();
            }
        }
        return dataLength;
    }

    private static URLConnection openConnection(URL url, Map<String, String> headers) throws IOException {
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        connection.setConnectTimeout(20000);
        connection.setReadTimeout(60000);
        connection.setRequestProperty("Accept-Encoding", "gzip");
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Serializable read(URLConnection connection, InputStream inputStream) throws IOException, ClassNotFoundException {
        InputStream input = inputStream;
        try {
            TransportFormat transportFormat;
            String contentType;
            if ("gzip".equals(connection.getContentEncoding())) {
                input = new GZIPInputStream(input);
            }
            if ((contentType = connection.getContentType()) != null) {
                if (contentType.startsWith("text/xml")) {
                    transportFormat = TransportFormat.XML;
                } else {
                    if (contentType.startsWith("text/html")) {
                        throw new IllegalStateException("Unexpected html content type, maybe not authentified");
                    }
                    transportFormat = TransportFormat.SERIALIZED;
                }
            } else {
                transportFormat = TransportFormat.SERIALIZED;
            }
            Serializable serializable = transportFormat.readSerializableFrom(input);
            return serializable;
        }
        finally {
            try {
                input.close();
            }
            finally {
                LabradorRetriever.close(connection);
            }
        }
    }

    private static void close(URLConnection connection) throws IOException {
        InputStream error;
        connection.getInputStream().close();
        if (connection instanceof HttpURLConnection && (error = ((HttpURLConnection)connection).getErrorStream()) != null) {
            error.close();
        }
    }

    private static boolean shouldMock() {
        return Boolean.parseBoolean(System.getProperty("javamelody.mockLabradorRetriever"));
    }

    private <T> T createMockResultOfCall() throws IOException {
        List<Serializable> result;
        String request = this.url.toString();
        if (!request.contains("part=") && !request.contains("jmxValue") || request.contains("defaultWithCurrentRequests")) {
            String message = request.contains("/test2") ? null : "ceci est message pour le rapport";
            result = Arrays.asList(new Counter("http", null), new Counter("services", null), new Counter("error", null), new JavaInformations(null, true), message);
        } else {
            result = LabradorMock.createMockResultOfPartCall(request);
        }
        return (T)result;
    }

    private static class LabradorMock {
        private LabradorMock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static Object createMockResultOfPartCall(String request) throws IOException {
            Object result;
            if (request.contains("sessions") && request.contains("sessionId")) {
                result = null;
            } else if (request.contains("sessions") || request.contains("processes") || request.contains("jndi") || request.contains("connections") || request.contains("mbeans") || request.contains("hotspots")) {
                result = Collections.emptyList();
            } else if (request.contains("currentRequests") || request.contains("webappVersions") || request.contains("dependencies")) {
                result = Collections.emptyMap();
            } else if (request.contains("database")) {
                try {
                    result = new DatabaseInformations(0);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            } else if (request.contains("heaphisto")) {
                InputStream input = LabradorMock.class.getResourceAsStream("/heaphisto.txt");
                try {
                    result = new HeapHistogram(input, false);
                }
                finally {
                    input.close();
                }
            } else {
                result = request.contains("lastValue") ? Double.valueOf(-1.0) : (request.contains("jmxValue") ? "-1" : (request.contains("jvm") ? Collections.singletonList(new JavaInformations(Parameters.getServletContext(), false)) : null));
            }
            return result;
        }
    }

    private static class CounterInputStream
    extends InputStream {
        private final InputStream inputStream;
        private int dataLength;

        CounterInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        int getDataLength() {
            return this.dataLength;
        }

        @Override
        public int read() throws IOException {
            int result = this.inputStream.read();
            if (result != -1) {
                ++this.dataLength;
            }
            return result;
        }

        @Override
        public int read(byte[] bytes) throws IOException {
            int result = this.inputStream.read(bytes);
            if (result != -1) {
                this.dataLength += result;
            }
            return result;
        }

        @Override
        public int read(byte[] bytes, int off, int len) throws IOException {
            int result = this.inputStream.read(bytes, off, len);
            if (result != -1) {
                this.dataLength += result;
            }
            return result;
        }

        @Override
        public long skip(long n) throws IOException {
            return this.inputStream.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.inputStream.available();
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
        }

        @Override
        public boolean markSupported() {
            return false;
        }
    }
}

