/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import net.bull.javamelody.internal.model.Counter;
import net.bull.javamelody.internal.model.CounterRequest;
import net.bull.javamelody.internal.model.CounterRequestAggregation;

public interface CounterRequestMXBean {
    public CounterRequestAggregationData getCounterRequestAggregation();

    public static class CounterRequestMXBeanImpl
    implements CounterRequestMXBean {
        private final Counter counter;

        CounterRequestMXBeanImpl(Counter counter) {
            this.counter = counter;
        }

        @Override
        public CounterRequestAggregationData getCounterRequestAggregation() {
            return new CounterRequestAggregationData(new CounterRequestAggregation(this.counter));
        }
    }

    public static class CounterRequestData {
        private final CounterRequest request;

        CounterRequestData(CounterRequest request) {
            this.request = request;
        }

        public String getName() {
            return this.request.getName();
        }

        public long getHits() {
            return this.request.getHits();
        }

        public int getMean() {
            return this.request.getMean();
        }

        public int getStandardDeviation() {
            return this.request.getStandardDeviation();
        }

        public long getMaximum() {
            return this.request.getMaximum();
        }

        public int getCpuTimeMean() {
            return this.request.getCpuTimeMean();
        }

        public float getSystemErrorPercentage() {
            return this.request.getSystemErrorPercentage();
        }

        public int getResponseSizeMean() {
            return this.request.getResponseSizeMean();
        }
    }

    public static class CounterRequestAggregationData {
        private final CounterRequestData globalRequest;
        private final CounterRequestData warningRequest;
        private final CounterRequestData severeRequest;
        private final int warningThreshold;
        private final int severeThreshold;
        private final SortedMap<String, CounterRequestData> requests;

        CounterRequestAggregationData(CounterRequestAggregation aggregation) {
            this.globalRequest = new CounterRequestData(aggregation.getGlobalRequest());
            this.warningRequest = new CounterRequestData(aggregation.getWarningRequest());
            this.severeRequest = new CounterRequestData(aggregation.getSevereRequest());
            this.warningThreshold = aggregation.getWarningThreshold();
            this.severeThreshold = aggregation.getSevereThreshold();
            this.requests = new TreeMap<String, CounterRequestData>();
            List<CounterRequest> requestList = aggregation.getRequests();
            for (CounterRequest request : requestList) {
                this.requests.put(request.getName(), new CounterRequestData(request));
            }
        }

        public CounterRequestData getGlobalRequest() {
            return this.globalRequest;
        }

        public CounterRequestData getWarningRequest() {
            return this.warningRequest;
        }

        public CounterRequestData getSevereRequest() {
            return this.severeRequest;
        }

        public int getWarningThreshold() {
            return this.warningThreshold;
        }

        public int getSevereThreshold() {
            return this.severeThreshold;
        }

        public SortedMap<String, CounterRequestData> getRequests() {
            return this.requests;
        }
    }
}

