/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.Pointcut;

public class MonitoredSpringAsyncAndScheduledPointcut
implements Pointcut {
    public ClassFilter getClassFilter() {
        return ClassFilter.TRUE;
    }

    public MethodMatcher getMethodMatcher() {
        return MonitoredMethodMatcher.INSTANCE;
    }

    private static enum MonitoredMethodMatcher implements MethodMatcher
    {
        INSTANCE;

        private static final Class<? extends Annotation> ASYNC_CLASS;
        private static final Class<? extends Annotation> SCHEDULED_CLASS;
        private static final Class<? extends Annotation> SCHEDULES_CLASS;

        private static <T> Class<T> getClass(String className) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public boolean matches(Method method, Class targetClass) {
            return this.matchesAsync(method, targetClass) || this.matchesScheduled(method);
        }

        private boolean matchesAsync(Method method, Class targetClass) {
            return ASYNC_CLASS != null && (targetClass.isAnnotationPresent(ASYNC_CLASS) || method.getDeclaringClass().isAnnotationPresent(ASYNC_CLASS) || method.isAnnotationPresent(ASYNC_CLASS));
        }

        private boolean matchesScheduled(Method method) {
            return SCHEDULED_CLASS != null && method.isAnnotationPresent(SCHEDULED_CLASS) || SCHEDULES_CLASS != null && method.isAnnotationPresent(SCHEDULES_CLASS);
        }

        public boolean isRuntime() {
            return false;
        }

        public boolean matches(Method method, Class targetClass, Object[] args) {
            throw new UnsupportedOperationException("This is not a runtime method matcher");
        }

        static {
            ASYNC_CLASS = MonitoredMethodMatcher.getClass("org.springframework.scheduling.annotation.Async");
            SCHEDULED_CLASS = MonitoredMethodMatcher.getClass("org.springframework.scheduling.annotation.Scheduled");
            SCHEDULES_CLASS = MonitoredMethodMatcher.getClass("org.springframework.scheduling.annotation.Schedules");
        }
    }
}

