/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.model.Base64Coder;
import net.bull.javamelody.internal.model.MetricsPublisher;
import net.bull.javamelody.internal.model.TransportFormat;

class InfluxDB
extends MetricsPublisher {
    private static final char SEPARATOR = ' ';
    private final URL influxDbUrl;
    private final String prefix;
    private final String tags;
    private final DecimalFormat decimalFormat = new DecimalFormat("0.00", DecimalFormatSymbols.getInstance(Locale.US));
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final Writer bufferWriter = new OutputStreamWriter((OutputStream)this.buffer, Charset.forName("UTF-8"));
    private long lastTime;
    private String lastTimestamp;

    InfluxDB(URL influxDbUrl, String prefix, String tags) {
        assert (influxDbUrl != null);
        assert (prefix != null);
        assert (tags != null);
        this.influxDbUrl = influxDbUrl;
        this.prefix = prefix;
        this.tags = tags;
    }

    static InfluxDB getInstance(String contextPath, String hostName) {
        String influxDbUrl = Parameter.INFLUXDB_URL.getValue();
        if (influxDbUrl != null) {
            assert (contextPath != null);
            assert (hostName != null);
            String prefix = "javamelody.";
            String tags = (",application=" + contextPath + ",host=" + hostName).replace(' ', '_');
            try {
                return new InfluxDB(new URL(influxDbUrl + "&precision=s"), "javamelody.", tags);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return null;
    }

    @Override
    synchronized void addValue(String metric, double value) throws IOException {
        long timeInSeconds = System.currentTimeMillis() / 1000L;
        if (this.lastTime != timeInSeconds) {
            this.lastTimestamp = String.valueOf(timeInSeconds);
            this.lastTime = timeInSeconds;
        }
        this.bufferWriter.append(this.prefix).append(metric).append(this.tags).append(' ');
        this.bufferWriter.append("value=").append(this.decimalFormat.format(value)).append(' ');
        this.bufferWriter.append(this.lastTimestamp).append('\n');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void send() throws IOException {
        try {
            this.bufferWriter.flush();
            HttpURLConnection connection = (HttpURLConnection)this.influxDbUrl.openConnection();
            connection.setConnectTimeout(20000);
            connection.setReadTimeout(60000);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "plain/text");
            connection.setDoOutput(true);
            if (this.influxDbUrl.getUserInfo() != null) {
                String authorization = Base64Coder.encodeString(this.influxDbUrl.getUserInfo());
                connection.setRequestProperty("Authorization", "Basic " + authorization);
            }
            OutputStream outputStream = connection.getOutputStream();
            this.buffer.writeTo(outputStream);
            outputStream.flush();
            int status = connection.getResponseCode();
            if (status >= 400) {
                ByteArrayOutputStream errorOutputStream = new ByteArrayOutputStream();
                TransportFormat.pump(connection.getErrorStream(), errorOutputStream);
                String msg = "Error connecting to InfluxDB (" + status + "): " + errorOutputStream.toString("UTF-8");
                LOG.warn(msg, new IOException(msg));
            }
            connection.disconnect();
        }
        catch (Exception e) {
            LOG.warn(e.toString(), e);
        }
        finally {
            this.buffer.reset();
        }
    }

    @Override
    void stop() {
    }
}

