/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.internal.web.FilterServletOutputStream;

public class CounterResponseStream
extends FilterServletOutputStream {
    private int dataLength;

    CounterResponseStream(HttpServletResponse response) throws IOException {
        super(response.getOutputStream());
    }

    public CounterResponseStream(OutputStream output) {
        super(output);
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void reset() {
        this.dataLength = 0;
    }

    @Override
    public void write(int i) throws IOException {
        super.write(i);
        ++this.dataLength;
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        super.write(bytes);
        this.dataLength += bytes.length;
    }

    @Override
    public void write(byte[] bytes, int off, int len) throws IOException {
        super.write(bytes, off, len);
        this.dataLength += len;
    }
}

