/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.model.Counter;
import net.bull.javamelody.internal.model.CounterRequest;

public class CounterRequestAggregation {
    private final Counter counter;
    private final List<CounterRequest> requests;
    private final CounterRequest globalRequest;
    private final int warningThreshold;
    private final int severeThreshold;
    private final boolean responseSizeDisplayed;
    private final boolean childHitsDisplayed;
    private final boolean timesDisplayed;
    private final boolean cpuTimesDisplayed;
    private final CounterRequest warningRequest;
    private final CounterRequest severeRequest;

    public CounterRequestAggregation(Counter counter) {
        assert (counter != null);
        this.counter = counter;
        this.requests = counter.isErrorCounter() ? counter.getOrderedByHitsRequests() : counter.getOrderedRequests();
        assert (this.requests != null);
        String counterName = counter.getName();
        this.globalRequest = new CounterRequest(counterName + " global", counterName);
        for (CounterRequest request : this.requests) {
            this.globalRequest.addHits(request);
        }
        this.responseSizeDisplayed = this.globalRequest.getResponseSizeMean() >= 0;
        this.childHitsDisplayed = this.globalRequest.hasChildHits();
        this.timesDisplayed = this.globalRequest.getMean() >= 0;
        this.cpuTimesDisplayed = this.globalRequest.getCpuTimeMean() >= 0;
        int globalMean = this.globalRequest.getMean();
        int globalStandardDeviation = this.globalRequest.getStandardDeviation();
        this.warningThreshold = CounterRequestAggregation.getThreshold(Parameter.WARNING_THRESHOLD_MILLIS, globalMean + globalStandardDeviation);
        this.severeThreshold = CounterRequestAggregation.getThreshold(Parameter.SEVERE_THRESHOLD_MILLIS, globalMean + 2 * globalStandardDeviation);
        this.warningRequest = new CounterRequest(counterName + " warning", counterName);
        this.severeRequest = new CounterRequest(counterName + " severe", counterName);
        for (CounterRequest request : this.requests) {
            int mean = request.getMean();
            if (mean > this.severeThreshold) {
                this.severeRequest.addHits(request);
                continue;
            }
            if (mean <= this.warningThreshold) continue;
            this.warningRequest.addHits(request);
        }
    }

    private static int getThreshold(Parameter parameter, int defaultValue) {
        String param = parameter.getValue();
        if (param == null) {
            return defaultValue;
        }
        int threshold = Integer.parseInt(param);
        if (threshold <= 0) {
            throw new IllegalStateException("Le param\u00e8tre " + parameter.getCode() + " doit \u00eatre > 0");
        }
        return threshold;
    }

    public List<CounterRequest> getRequests() {
        return this.requests;
    }

    public CounterRequest getGlobalRequest() {
        return this.globalRequest;
    }

    public CounterRequest getWarningRequest() {
        return this.warningRequest;
    }

    public CounterRequest getSevereRequest() {
        return this.severeRequest;
    }

    public int getWarningThreshold() {
        return this.warningThreshold;
    }

    public int getSevereThreshold() {
        return this.severeThreshold;
    }

    public boolean isResponseSizeDisplayed() {
        return this.responseSizeDisplayed;
    }

    public boolean isChildHitsDisplayed() {
        return this.childHitsDisplayed;
    }

    public boolean isTimesDisplayed() {
        return this.timesDisplayed;
    }

    public boolean isCpuTimesDisplayed() {
        return this.cpuTimesDisplayed;
    }

    public List<CounterRequest> getRequestsAggregatedOrFilteredByClassName(String requestId) {
        List<CounterRequest> requestList;
        List<CounterRequest> requestsAggregatedByClassName = this.getRequestsAggregatedByClassName();
        if (requestId == null) {
            requestList = requestsAggregatedByClassName;
        } else {
            requestList = new ArrayList<CounterRequest>();
            for (CounterRequest requestAggregated : requestsAggregatedByClassName) {
                if (!requestId.equals(requestAggregated.getId())) continue;
                String className = requestAggregated.getName();
                requestList.addAll(this.getRequestsFilteredByClassName(className));
                break;
            }
        }
        return Collections.unmodifiableList(requestList);
    }

    private List<CounterRequest> getRequestsAggregatedByClassName() {
        assert (this.counter.isBusinessFacadeCounter());
        HashMap<String, CounterRequest> requestMap = new HashMap<String, CounterRequest>();
        String counterName = this.counter.getName();
        for (CounterRequest request : this.getRequests()) {
            String className = CounterRequestAggregation.getClassNameFromRequest(request);
            CounterRequest global = (CounterRequest)requestMap.get(className);
            if (global == null) {
                global = new CounterRequest(className, counterName);
                requestMap.put(className, global);
            }
            global.addHits(request);
        }
        ArrayList<CounterRequest> requestList = new ArrayList<CounterRequest>(requestMap.values());
        if (requestList.size() > 1) {
            Collections.sort(requestList, Collections.reverseOrder(new Counter.CounterRequestComparator()));
        }
        return requestList;
    }

    private List<CounterRequest> getRequestsFilteredByClassName(String className) {
        assert (this.counter.isBusinessFacadeCounter());
        assert (className != null);
        ArrayList<CounterRequest> requestList = new ArrayList<CounterRequest>();
        for (CounterRequest request : this.getRequests()) {
            String requestClassName = CounterRequestAggregation.getClassNameFromRequest(request);
            if (!className.equals(requestClassName)) continue;
            requestList.add(request);
        }
        if (requestList.size() > 1) {
            Collections.sort(requestList, Collections.reverseOrder(new Counter.CounterRequestComparator()));
        }
        return requestList;
    }

    private static String getClassNameFromRequest(CounterRequest request) {
        int lastIndexOf = request.getName().lastIndexOf(46);
        if (lastIndexOf != -1) {
            return request.getName().substring(0, lastIndexOf);
        }
        return request.getName();
    }
}

