/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.publish;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.internal.common.LOG;
import net.bull.javamelody.internal.model.LabradorRetriever;
import net.bull.javamelody.internal.publish.MetricsPublisher;

class Datadog
extends MetricsPublisher {
    private static final String BEGIN_SERIES = "{ \"series\" : [";
    private static final String END_SERIES = "\n]}";
    private final URL datadogUrl;
    private final String prefix;
    private final String hostAndTags;
    private final Map<String, String> httpHeaders = Collections.singletonMap("Content-Type", "application/json");
    private final DecimalFormat decimalFormat = new DecimalFormat("0.00", DecimalFormatSymbols.getInstance(Locale.US));
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final Writer bufferWriter = new OutputStreamWriter((OutputStream)this.buffer, Charset.forName("UTF-8"));
    private long lastTime;
    private String lastTimestamp;
    private boolean beginSeries;

    Datadog(String datadogApiKey, String prefix, String hostAndTags) {
        assert (datadogApiKey != null);
        assert (prefix != null);
        assert (hostAndTags != null);
        try {
            this.datadogUrl = new URL("https://app.datadoghq.com/api/v1/series?api_key=" + datadogApiKey);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        this.prefix = prefix;
        this.hostAndTags = hostAndTags;
        try {
            this.bufferWriter.append(BEGIN_SERIES);
            this.beginSeries = true;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    static Datadog getInstance(String contextPath, String hostName) {
        String datadogApiKey = Parameter.DATADOG_API_KEY.getValue();
        if (datadogApiKey != null) {
            assert (contextPath != null);
            assert (hostName != null);
            String prefix = "javamelody.";
            String hostAndTags = "\"host\":\"" + hostName + "\",\"tags\":[\"application:" + contextPath + "\"]";
            return new Datadog(datadogApiKey, "javamelody.", hostAndTags);
        }
        return null;
    }

    @Override
    public synchronized void addValue(String metric, double value) throws IOException {
        long timeInSeconds = System.currentTimeMillis() / 1000L;
        if (this.lastTime != timeInSeconds) {
            this.lastTimestamp = String.valueOf(timeInSeconds);
            this.lastTime = timeInSeconds;
        }
        if (this.beginSeries) {
            this.beginSeries = false;
        } else {
            this.bufferWriter.append(',');
        }
        this.bufferWriter.append("\n{\"metric\":\"").append(this.prefix).append(metric).append("\",");
        this.bufferWriter.append("\"points\":[[").append(this.lastTimestamp).append(',').append(this.decimalFormat.format(value)).append("]],");
        this.bufferWriter.append(this.hostAndTags);
        this.bufferWriter.append('}');
    }

    @Override
    public synchronized void send() throws IOException {
        try {
            this.bufferWriter.append(END_SERIES);
            this.bufferWriter.flush();
            new LabradorRetriever(this.datadogUrl, this.httpHeaders).post(this.buffer);
        }
        catch (Exception e) {
            LOG.warn(e.toString(), e);
        }
        finally {
            this.buffer.reset();
            this.bufferWriter.append(BEGIN_SERIES);
            this.beginSeries = true;
        }
    }

    @Override
    public void stop() {
    }
}

