/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.html;

import java.io.IOException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.model.Range;
import net.bull.javamelody.internal.web.html.HtmlAbstractReport;

class HtmlForms
extends HtmlAbstractReport {
    HtmlForms(Writer writer) {
        super(writer);
    }

    void writeCustomPeriodLinks(Map<String, Date> datesByWebappVersions, Range currentRange, String graphName, String part) throws IOException {
        this.writeln("<a href=\"javascript:showHide('customPeriod');document.customPeriodForm.startDate.focus();\" ");
        this.writeln("title='" + HtmlForms.getFormattedString("Choisir_periode", HtmlForms.getString("personnalisee")) + "'>");
        this.writeln("<img src='?resource=calendar.png' alt='#personnalisee#' /> #personnalisee#</a>");
        if (!datesByWebappVersions.isEmpty()) {
            this.writeln("&nbsp;<a href=\"javascript:showHide('deploymentPeriod');\" ");
            this.writeln("title='" + HtmlForms.getFormattedString("Choisir_periode", HtmlForms.getString("par_deploiement")) + "'>");
            this.writeln("<img src='?resource=calendar.png' alt='#par_deploiement#' /> #par_deploiement#</a>");
        }
        this.writeCustomPeriodDiv(currentRange, graphName, part);
        if (!datesByWebappVersions.isEmpty()) {
            this.writeDeploymentPeriodDiv(datesByWebappVersions, currentRange, graphName, part);
        }
    }

    private void writeCustomPeriodDiv(Range currentRange, String graphName, String part) throws IOException {
        String dateFormatPattern;
        this.writeln("<div id='customPeriod' style='display: none;'>");
        this.writeln("<script type='text/javascript'>");
        this.writeln("function validateCustomPeriodForm() {");
        this.writeln("   periodForm = document.customPeriodForm;");
        this.writelnCheckMandatory("periodForm.startDate", "dates_mandatory");
        this.writelnCheckMandatory("periodForm.endDate", "dates_mandatory");
        this.writeln("   periodForm.period.value=periodForm.startDate.value + '|' + periodForm.endDate.value;");
        this.writeln("   return true;");
        this.writeln("}");
        this.writeln("</script>");
        this.writeln("<br/>");
        DateFormat dateFormat = I18N.createDateFormat();
        if (HtmlForms.getString("dateFormatPattern").isEmpty()) {
            String pattern = ((SimpleDateFormat)dateFormat).toPattern();
            dateFormatPattern = pattern.toLowerCase(I18N.getCurrentLocale());
        } else {
            dateFormatPattern = HtmlForms.getString("dateFormatPattern");
        }
        this.writeln("<form name='customPeriodForm' method='get' action='' onsubmit='return validateCustomPeriodForm();'>");
        this.writeln("<br/><b>#startDate#</b>&nbsp;&nbsp;<input type='text' size='10' name='startDate' ");
        if (currentRange.getStartDate() != null) {
            this.writeln("value='" + dateFormat.format(currentRange.getStartDate()) + '\'');
        }
        this.writeln("/>&nbsp;&nbsp;<b>#endDate#</b>&nbsp;&nbsp;<input type='text' size='10' name='endDate' ");
        if (currentRange.getEndDate() != null) {
            this.writeln("value='" + dateFormat.format(currentRange.getEndDate()) + '\'');
        }
        this.writeln("/>&nbsp;&nbsp;");
        this.writeDirectly('(' + dateFormatPattern + ')');
        this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type='submit' value='#ok#'/><br/><br/>");
        this.writeln("<input type='hidden' name='period' value=''/>");
        if (graphName != null) {
            this.writeln("<input type='hidden' name='part' value='" + part + "'/>");
            this.writeln("<input type='hidden' name='graph' value='" + HtmlForms.urlEncode(graphName) + "'/>");
        }
        this.writeln("</form><br/>");
        this.writeln("</div>");
    }

    private void writeDeploymentPeriodDiv(Map<String, Date> datesByWebappVersions, Range currentRange, String graphName, String part) throws IOException {
        this.writeln("<div id='deploymentPeriod' style='display: none;'>");
        this.writeln("<br/>");
        DateFormat dateFormat = I18N.createDateFormat();
        String currentRangeValue = currentRange.getValue();
        String startDateLabel = I18N.getString("startDate").toLowerCase(I18N.getCurrentLocale());
        String endDateLabel = I18N.getString("endDate");
        this.writeln("<form name='deploymentPeriodForm' method='get' action=''>");
        this.writeln("<br/><b>#Version#</b>&nbsp;&nbsp;");
        this.writeln("<select name='period' onchange='document.deploymentPeriodForm.submit();'>");
        this.writeDirectly("<option>&nbsp;</option>");
        String previousDate = null;
        for (Map.Entry<String, Date> entry : datesByWebappVersions.entrySet()) {
            String label;
            String version = entry.getKey();
            String date = dateFormat.format(entry.getValue());
            if (previousDate == null) {
                previousDate = dateFormat.format(new Date());
                label = version + ' ' + startDateLabel + ' ' + date;
            } else {
                label = version + ' ' + startDateLabel + ' ' + date + ' ' + endDateLabel + ' ' + previousDate;
            }
            String rangeValue = date + '|' + previousDate;
            this.writeDirectly("<option value='" + rangeValue + "'");
            if (rangeValue.equals(currentRangeValue)) {
                this.writeDirectly(" selected='selected'");
            }
            this.writeDirectly(">");
            this.writeDirectly(HtmlForms.htmlEncodeButNotSpace(label));
            this.writeDirectly("</option>");
            previousDate = date;
        }
        this.writeln("</select><br/><br/>");
        if (graphName != null) {
            this.writeln("<input type='hidden' name='part' value='" + part + "'/>");
            this.writeln("<input type='hidden' name='graph' value='" + HtmlForms.urlEncode(graphName) + "'/>");
        }
        this.writeln("</form><br/>");
        this.writeln("</div>");
    }

    void writeAddAndRemoveApplicationLinks(String currentApplication) throws IOException {
        if (currentApplication == null) {
            this.writeln("<div align='center'><h3>#add_application#</h3>");
            this.writeln("#collect_server_intro#");
        } else {
            String separator = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.writeln("<a href=\"javascript:showHide('addApplication');document.appForm.appName.focus();\"");
            this.writeln(" class='noPrint'><img src='?resource=action_add.png' alt='#add_application#'/> #add_application#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
            this.writeln("<a href='?action=remove_application&amp;application=" + currentApplication + HtmlForms.getCsrfTokenUrlPart() + "' class='noPrint' ");
            String messageConfirmation = HtmlForms.getFormattedString("confirm_remove_application", currentApplication);
            this.writeln("onclick=\"javascript:return confirm('" + HtmlForms.javascriptEncode(messageConfirmation) + "');\">");
            String removeApplicationLabel = HtmlForms.getFormattedString("remove_application", currentApplication);
            this.writeln("<img src='?resource=action_delete.png' alt=\"" + removeApplicationLabel + "\"/> " + removeApplicationLabel + "</a>");
            this.writeln("<div id='addApplication' style='display: none;'>");
        }
        this.writeln("<script type='text/javascript'>");
        this.writeln("function validateAppForm() {");
        this.writelnCheckMandatory("document.appForm.appName", "app_name_mandatory");
        this.writelnCheckMandatory("document.appForm.appUrls", "app_urls_mandatory");
        this.writeln("   return true;");
        this.writeln("}");
        this.writeln("</script>");
        this.writeln("<br/> <br/>");
        this.writeln("<form name='appForm' method='post' action='' onsubmit='return validateAppForm();'>");
        this.writeln("<br/><b>#app_name_to_monitor# :</b>&nbsp;&nbsp;<input type='text' size='15' name='appName'/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<b>#app_urls# :</b>&nbsp;&nbsp;<input type='text' size='50' name='appUrls'/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeln("<input type='submit' value='#add#'/><br/>");
        this.writeln("#urls_sample# : <i>http://myhost/myapp/</i> #or# <i>http://host1/myapp/,http://host2/myapp/</i>");
        this.writeln("<br/> <br/>");
        this.writeln("</form>");
        this.writeln("</div>\n");
    }

    private void writelnCheckMandatory(String fieldFullName, String msgKey) throws IOException {
        this.writeln("   if (" + fieldFullName + ".value.length == 0) {");
        this.writeln("      alert('" + HtmlForms.getStringForJavascript(msgKey) + "');");
        this.writeln("      " + fieldFullName + ".focus();");
        this.writeln("      return false;");
        this.writeln("   }");
    }

    @Override
    void toHtml() {
        throw new UnsupportedOperationException();
    }
}

