/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody.internal.web.html;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.List;
import net.bull.javamelody.internal.common.I18N;
import net.bull.javamelody.internal.common.Parameters;
import net.bull.javamelody.internal.model.JCacheInformations;
import net.bull.javamelody.internal.web.html.HtmlAbstractReport;

public class HtmlJCacheInformationsReport
extends HtmlAbstractReport {
    private final List<JCacheInformations> jcacheInformationsList;
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();
    private final boolean hitsRatioEnabled;
    private final boolean systemActionsEnabled = Parameters.isSystemActionsEnabled();

    HtmlJCacheInformationsReport(List<JCacheInformations> jcacheInformationsList, Writer writer) {
        super(writer);
        assert (jcacheInformationsList != null);
        this.jcacheInformationsList = jcacheInformationsList;
        this.hitsRatioEnabled = HtmlJCacheInformationsReport.isHitsRatioEnabled(jcacheInformationsList);
    }

    @Override
    void toHtml() throws IOException {
        this.writeJCaches(this.jcacheInformationsList);
        this.write("<div align='right' class='noPrint'>");
        if (!this.hitsRatioEnabled) {
            this.writeln("#jcaches_statistics_enable#<br/>");
        }
        if (this.systemActionsEnabled) {
            this.writeln("<a href='?action=clear_jcaches" + HtmlJCacheInformationsReport.getCsrfTokenUrlPart() + "' onclick=\"javascript:return confirm('" + HtmlJCacheInformationsReport.getStringForJavascript("confirm_purge_caches") + "');\">");
            this.writeln("<img src='?resource=user-trash.png' width='18' height='18' alt=\"#Purge_caches#\" /> #Purge_caches#</a>");
            this.writeln("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        }
        this.writeln("</div>");
    }

    private void writeJCaches(List<JCacheInformations> jcacheInformations) throws IOException {
        HtmlAbstractReport.HtmlTable table = new HtmlAbstractReport.HtmlTable(this);
        table.beginTable(HtmlJCacheInformationsReport.getString("Caches"));
        this.write("<th>#Cache#</th>");
        if (this.hitsRatioEnabled) {
            this.write("<th class='sorttable_numeric'>");
            this.write(HtmlJCacheInformationsReport.getString("Efficacite_cache").replaceAll("\n", "<br/>"));
            this.write("</th>");
        }
        if (this.systemActionsEnabled) {
            this.write("<th class='noPrint'>#Purger#</th>");
        }
        for (JCacheInformations jcacheInfos : jcacheInformations) {
            table.nextRow();
            this.writeJCacheInformations(jcacheInfos);
        }
        table.endTable();
    }

    private void writeJCacheInformations(JCacheInformations jcacheInformations) throws IOException {
        this.write("<td>");
        this.writeDirectly("<a href='?part=jcacheKeys&amp;cacheId=" + HtmlJCacheInformationsReport.urlEncode(jcacheInformations.getName()) + "'>");
        if (jcacheInformations.getName().isEmpty()) {
            this.write("--");
        } else {
            this.writeDirectly(HtmlJCacheInformationsReport.htmlEncodeButNotSpace(jcacheInformations.getName()));
        }
        this.writeln("</a>");
        String nextColumnAlignRight = "</td> <td align='right'>";
        if (this.hitsRatioEnabled) {
            this.write("</td> <td align='right'>");
            this.write(this.integerFormat.format(jcacheInformations.getHitsRatio()));
        }
        this.write("</td>");
        if (this.systemActionsEnabled) {
            this.write("<td align='center' class='noPrint'>");
            String confirmClearCache = HtmlJCacheInformationsReport.javascriptEncode(HtmlJCacheInformationsReport.getFormattedString("confirm_purge_cache", jcacheInformations.getName()));
            this.writeDirectly("<a href='?action=clear_jcache&amp;cacheId=" + HtmlJCacheInformationsReport.urlEncode(jcacheInformations.getName()) + HtmlJCacheInformationsReport.getCsrfTokenUrlPart() + "' onclick=\"javascript:return confirm('" + confirmClearCache + "');\">");
            String title = HtmlJCacheInformationsReport.htmlEncode(HtmlJCacheInformationsReport.getFormattedString("Purge_cache", jcacheInformations.getName()));
            this.writeDirectly("<img src='?resource=user-trash.png' width='16' height='16' alt='" + title + "' title='" + title + "' /></a>");
            this.write("</td>");
        }
    }

    public static boolean isHitsRatioEnabled(List<JCacheInformations> jcacheInformationsList) {
        for (JCacheInformations jcacheInformations : jcacheInformationsList) {
            if (jcacheInformations.getHitsRatio() < 0) continue;
            return true;
        }
        return false;
    }

    void writeJCacheWithKeys(String cacheId, boolean withoutHeaders) throws IOException {
        assert (this.jcacheInformationsList.size() == 1);
        if (!withoutHeaders) {
            this.writeBackAndRefreshLinksForCache(cacheId);
            this.writeln("<br/>");
            this.writeTitle("caches.png", HtmlJCacheInformationsReport.getFormattedString("Keys_cache", HtmlJCacheInformationsReport.htmlEncodeButNotSpace(cacheId)));
        }
        this.writeJCaches(this.jcacheInformationsList);
        this.writeln("<br/><b>#Keys#</b>");
        this.writeJCacheKeys(this.jcacheInformationsList.get(0));
    }

    private void writeBackAndRefreshLinksForCache(String cacheId) throws IOException {
        this.writeln("<div class='noPrint'>");
        this.writeln("<a href='javascript:history.back()'><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        this.writeDirectly("<a href='?part=jcacheKeys&amp;cacheId=" + HtmlJCacheInformationsReport.urlEncode(cacheId) + "'>");
        this.writeln("<img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#</a>");
        this.writeln("</div>");
    }

    private void writeJCacheKeys(JCacheInformations jcacheInformations) throws IOException {
        List<?> cacheKeys = jcacheInformations.getCacheKeys();
        assert (cacheKeys != null);
        if (cacheKeys.isEmpty()) {
            this.write("<br/>#No_keys#");
            return;
        }
        if (cacheKeys.size() > 20) {
            this.writeln("<div align='right'>" + cacheKeys.size() + " #Keys#</div>");
            this.writeln("<br/>");
        }
        HtmlAbstractReport.HtmlTable table = new HtmlAbstractReport.HtmlTable(this);
        table.beginTable(HtmlJCacheInformationsReport.getString("Keys"));
        this.write("<th>#Keys#</th>");
        if (this.systemActionsEnabled) {
            this.write("<th class='noPrint'>#Purger#</th>");
        }
        String cacheNameEncoded = HtmlJCacheInformationsReport.urlEncode(jcacheInformations.getName());
        String csrfTokenUrlPart = HtmlJCacheInformationsReport.getCsrfTokenUrlPart();
        String confirmClearCache = HtmlJCacheInformationsReport.javascriptEncode(HtmlJCacheInformationsReport.getFormattedString("confirm_purge_cache", jcacheInformations.getName()));
        String title = HtmlJCacheInformationsReport.htmlEncode(HtmlJCacheInformationsReport.getFormattedString("Purge_cache", jcacheInformations.getName()));
        for (Object key : cacheKeys) {
            if (key == null) continue;
            String myKey = key.toString();
            table.nextRow();
            this.writeDirectly("<td>");
            this.writeDirectly(HtmlJCacheInformationsReport.htmlEncodeButNotSpace(myKey));
            this.writeDirectly("</td>");
            if (!this.systemActionsEnabled) continue;
            this.writeDirectly("<td class='noPrint' style='text-align: center;'>");
            this.writeDirectly("<a href='?part=jcacheKeys&amp;action=clear_jcache_key&amp;cacheId=");
            this.writeDirectly(cacheNameEncoded);
            this.writeDirectly("&amp;cacheKey=");
            this.writeDirectly(HtmlJCacheInformationsReport.urlEncode(myKey));
            this.writeDirectly(csrfTokenUrlPart);
            this.writeDirectly("' onclick=\"javascript:return confirm('");
            this.writeDirectly(confirmClearCache);
            this.writeDirectly("');\">");
            this.writeDirectly("<img src='?resource=user-trash.png' width='16' height='16' alt='");
            this.writeDirectly(title);
            this.writeDirectly("' title='");
            this.writeDirectly(title);
            this.writeDirectly("' /></a>");
            this.writeDirectly("</td>");
        }
        table.endTable();
        this.writeln("<br/>");
        this.writeln("<div align='right'>" + cacheKeys.size() + " #Keys#</div>");
    }
}

