/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.bull.javamelody.Action;
import net.bull.javamelody.Collector;
import net.bull.javamelody.CollectorServer;
import net.bull.javamelody.DatabaseInformations;
import net.bull.javamelody.HeapHistogram;
import net.bull.javamelody.HtmlProcessInformationsReport;
import net.bull.javamelody.HtmlReport;
import net.bull.javamelody.I18N;
import net.bull.javamelody.JavaInformations;
import net.bull.javamelody.LabradorRetriever;
import net.bull.javamelody.MonitoringController;
import net.bull.javamelody.Parameter;
import net.bull.javamelody.Parameters;
import net.bull.javamelody.Period;
import net.bull.javamelody.SessionInformations;
import net.bull.javamelody.SessionListener;
import net.bull.javamelody.TransportFormat;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectorServlet
extends HttpServlet {
    private static final String BACK_LINK = "<a href='javascript:history.back()'><img src='?resource=action_back.png' alt='#Retour#'/> #Retour#</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
    private static final String COOKIE_NAME = "javamelody";
    private static final long serialVersionUID = -2070469677921953224L;
    private static final Logger LOGGER = Logger.getLogger((String)"javamelody");
    private Pattern allowedAddrPattern;
    private transient CollectorServer collectorServer;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        Parameters.initialize(config.getServletContext());
        if (!Boolean.parseBoolean(Parameters.getParameter(Parameter.LOG))) {
            LOGGER.setLevel(Level.WARN);
        }
        LOGGER.info((Object)"initialisation de la servlet de collecte du monitoring");
        if (Parameters.getParameter(Parameter.ALLOWED_ADDR_PATTERN) != null) {
            this.allowedAddrPattern = Pattern.compile(Parameters.getParameter(Parameter.ALLOWED_ADDR_PATTERN));
        }
        try {
            this.collectorServer = new CollectorServer();
        }
        catch (IOException e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String application;
        long start;
        block10: {
            block9: {
                start = System.currentTimeMillis();
                if (this.isAddressAllowed(req)) {
                    resp.sendError(403, "Acc\u00e8s interdit");
                    return;
                }
                application = this.getApplication(req, resp);
                I18N.bindLocale(req.getLocale());
                try {
                    if (application != null) break block9;
                    CollectorServlet.writeOnlyAddApplication(resp);
                }
                catch (Throwable throwable) {
                    I18N.unbindLocale();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("monitoring depuis " + req.getRemoteAddr() + ", request=" + req.getRequestURI() + (req.getQueryString() != null ? '?' + req.getQueryString() : "") + ", application=" + application + " en " + (System.currentTimeMillis() - start) + "ms"));
                    }
                    throw throwable;
                }
                I18N.unbindLocale();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("monitoring depuis " + req.getRemoteAddr() + ", request=" + req.getRequestURI() + (req.getQueryString() != null ? '?' + req.getQueryString() : "") + ", application=" + application + " en " + (System.currentTimeMillis() - start) + "ms"));
                }
                return;
            }
            if (this.collectorServer.isApplicationDataAvailable(application)) break block10;
            resp.sendError(500, "Donn\u00e9es non disponibles pour l'application " + application);
            I18N.unbindLocale();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("monitoring depuis " + req.getRemoteAddr() + ", request=" + req.getRequestURI() + (req.getQueryString() != null ? '?' + req.getQueryString() : "") + ", application=" + application + " en " + (System.currentTimeMillis() - start) + "ms"));
            }
            return;
        }
        this.doMonitoring(req, resp, application);
        I18N.unbindLocale();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("monitoring depuis " + req.getRemoteAddr() + ", request=" + req.getRequestURI() + (req.getQueryString() != null ? '?' + req.getQueryString() : "") + ", application=" + application + " en " + (System.currentTimeMillis() - start) + "ms"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.isAddressAllowed(req)) {
            resp.sendError(403, "Acc\u00e8s interdit");
            return;
        }
        I18N.bindLocale(req.getLocale());
        try {
            String appName = req.getParameter("appName");
            String appUrls = req.getParameter("appUrls");
            if (appName == null || appUrls == null) {
                this.writeMessage(req, resp, this.getApplication(req, resp), I18N.getString("donnees_manquantes"));
                return;
            }
            if (!appUrls.startsWith("http://") && !appUrls.startsWith("https://")) {
                this.writeMessage(req, resp, this.getApplication(req, resp), I18N.getString("urls_format"));
                return;
            }
            List<URL> urls = Parameters.parseUrl(appUrls);
            this.collectorServer.addCollectorApplication(appName, urls);
            LOGGER.info((Object)("ajout application monitor\u00e9e : " + appName));
            LOGGER.info((Object)("urls de l'application monitor\u00e9e : " + urls));
            CollectorServlet.showAlertAndRedirectTo(resp, I18N.getFormattedString("application_ajoutee", appName), "?application=" + appName);
        }
        catch (FileNotFoundException e) {
            String message = I18N.getString("monitoring_configure");
            LOGGER.warn((Object)message, (Throwable)e);
            this.writeMessage(req, resp, this.getApplication(req, resp), message + '\n' + e.toString());
        }
        catch (Exception e) {
            LOGGER.warn((Object)e.toString(), (Throwable)e);
            this.writeMessage(req, resp, this.getApplication(req, resp), e.toString());
        }
        finally {
            I18N.unbindLocale();
        }
    }

    private void doMonitoring(HttpServletRequest req, HttpServletResponse resp, String application) throws IOException {
        try {
            Collector collector = this.getCollectorByApplication(application);
            MonitoringController monitoringController = new MonitoringController(collector, true);
            String actionParameter = req.getParameter("action");
            if ("remove_application".equalsIgnoreCase(actionParameter)) {
                this.collectorServer.removeCollectorApplication(application);
                String message = I18N.getFormattedString("application_enlevee", application);
                CollectorServlet.showAlertAndRedirectTo(resp, message, "?");
                return;
            }
            if (actionParameter != null && Action.valueOfIgnoreCase(actionParameter) != Action.CLEAR_COUNTER) {
                this.forwardActionAndUpdateData(req, application);
            } else {
                monitoringController.executeActionIfNeeded(req);
            }
            String partParameter = req.getParameter("part");
            if (partParameter == null) {
                List<JavaInformations> javaInformationsList = this.getJavaInformationsByApplication(application);
                monitoringController.doReport(req, resp, javaInformationsList);
            } else {
                this.doPart(req, resp, application, monitoringController, partParameter);
            }
        }
        catch (RuntimeException e) {
            this.writeMessage(req, resp, application, e.getMessage());
        }
        catch (Exception e) {
            this.writeMessage(req, resp, application, e.getMessage());
        }
    }

    private void doPart(HttpServletRequest req, HttpServletResponse resp, String application, MonitoringController monitoringController, String partParameter) throws IOException, ClassNotFoundException {
        if ("web.xml".equalsIgnoreCase(partParameter)) {
            MonitoringController.noCache(resp);
            this.doProxy(req, resp, application, "part=web.xml");
        } else if ("pom.xml".equalsIgnoreCase(partParameter)) {
            MonitoringController.noCache(resp);
            this.doProxy(req, resp, application, "part=pom.xml");
        } else if ("sessions".equalsIgnoreCase(partParameter)) {
            this.doSessions(req, resp, application, monitoringController);
        } else if ("currentRequests".equalsIgnoreCase(partParameter)) {
            this.doCurrentRequests(req, resp, application);
        } else if ("heaphisto".equalsIgnoreCase(partParameter)) {
            this.doHeapHisto(req, resp, application, monitoringController);
        } else if ("processes".equalsIgnoreCase(partParameter)) {
            this.doProcesses(req, resp, application);
        } else if ("database".equalsIgnoreCase(partParameter)) {
            this.doDatabase(req, resp, application);
        } else {
            List<JavaInformations> javaInformationsList = this.getJavaInformationsByApplication(application);
            monitoringController.doReport(req, resp, javaInformationsList);
        }
    }

    private void doProxy(HttpServletRequest req, HttpServletResponse resp, String application, String urlParameter) throws IOException {
        URL url = CollectorServlet.getUrlsByApplication(application).get(0);
        URL webXmlUrl = new URL(url.toString() + '&' + urlParameter);
        new LabradorRetriever(webXmlUrl).copyTo(req, resp);
    }

    private void doHeapHisto(HttpServletRequest req, HttpServletResponse resp, String application, MonitoringController monitoringController) throws IOException, ClassNotFoundException {
        HeapHistogram heapHistoTotal = null;
        for (URL url : CollectorServlet.getUrlsByApplication(application)) {
            URL heapHistoUrl = new URL(url.toString() + '&' + "part" + '=' + "heaphisto");
            LabradorRetriever labradorRetriever = new LabradorRetriever(heapHistoUrl);
            HeapHistogram heapHisto = (HeapHistogram)labradorRetriever.call();
            if (heapHistoTotal == null) {
                heapHistoTotal = heapHisto;
                continue;
            }
            heapHistoTotal.add(heapHisto);
        }
        monitoringController.setHeapHistogramIfCollectServer(heapHistoTotal);
        List<JavaInformations> javaInformationsList = this.getJavaInformationsByApplication(application);
        monitoringController.doReport(req, resp, javaInformationsList);
    }

    private void doSessions(HttpServletRequest req, HttpServletResponse resp, String application, MonitoringController monitoringController) throws IOException, ClassNotFoundException {
        String sessionId = req.getParameter("sessionId");
        if (sessionId == null) {
            ArrayList<SessionInformations> sessionsInformations = new ArrayList<SessionInformations>();
            for (URL url : CollectorServlet.getUrlsByApplication(application)) {
                URL sessionsUrl = new URL(url.toString() + '&' + "part" + '=' + "sessions");
                LabradorRetriever labradorRetriever = new LabradorRetriever(sessionsUrl);
                List sessions = (List)labradorRetriever.call();
                sessionsInformations.addAll(sessions);
            }
            SessionListener.sortSessions(sessionsInformations);
            monitoringController.setSessionsInformations(sessionsInformations);
            List<JavaInformations> javaInformationsList = this.getJavaInformationsByApplication(application);
            monitoringController.doReport(req, resp, javaInformationsList);
        } else {
            SessionInformations found = null;
            for (URL url : CollectorServlet.getUrlsByApplication(application)) {
                URL sessionsUrl = new URL(url.toString() + '&' + "part" + '=' + "sessions" + '&' + "sessionId" + '=' + sessionId);
                LabradorRetriever labradorRetriever = new LabradorRetriever(sessionsUrl);
                SessionInformations session = (SessionInformations)labradorRetriever.call();
                if (session == null) continue;
                found = session;
                break;
            }
            monitoringController.setSessionsInformations(Collections.singletonList(found));
            List<JavaInformations> javaInformationsList = this.getJavaInformationsByApplication(application);
            monitoringController.doReport(req, resp, javaInformationsList);
        }
    }

    private void doCurrentRequests(HttpServletRequest req, HttpServletResponse resp, String application) throws IOException {
        PrintWriter writer = CollectorServlet.createWriterFromOutputStream(resp);
        HtmlReport htmlReport = this.createHtmlReport(req, writer, application);
        htmlReport.writeHtmlHeader(false);
        writer.write("<div class='noPrint'>");
        I18N.writelnTo(BACK_LINK, writer);
        writer.write("<a href='?part=");
        writer.write("currentRequests");
        writer.write("&amp;period=");
        writer.write(MonitoringController.getPeriod(req).getCode());
        writer.write("'>");
        I18N.writelnTo("<img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#", writer);
        writer.write("</a></div>");
        for (URL url : CollectorServlet.getUrlsByApplication(application)) {
            String title = I18N.getString("Requetes_en_cours");
            String htmlTitle = "<h3><img width='24' height='24' src='?resource=hourglass.png' alt='" + title + "'/>" + title + " (" + CollectorServlet.getHostAndPort(url) + ")</h3>";
            writer.write(htmlTitle);
            writer.flush();
            URL currentRequestsUrl = new URL(url.toString().replace(TransportFormat.SERIALIZED.getCode(), "html").replace(TransportFormat.XML.getCode(), "html") + '&' + "part" + '=' + "currentRequests");
            new LabradorRetriever(currentRequestsUrl).copyTo(req, resp);
        }
        htmlReport.writeHtmlFooter();
        writer.close();
    }

    private void doProcesses(HttpServletRequest req, HttpServletResponse resp, String application) throws IOException, ClassNotFoundException {
        PrintWriter writer = CollectorServlet.createWriterFromOutputStream(resp);
        HtmlReport htmlReport = this.createHtmlReport(req, writer, application);
        htmlReport.writeHtmlHeader(false);
        writer.write("<div class='noPrint'>");
        I18N.writelnTo(BACK_LINK, writer);
        writer.write("<a href='?part=");
        writer.write("processes");
        writer.write("'>");
        I18N.writelnTo("<img src='?resource=action_refresh.png' alt='#Actualiser#'/> #Actualiser#", writer);
        writer.write("</a></div>");
        for (URL url : CollectorServlet.getUrlsByApplication(application)) {
            String title = I18N.getString("Processus");
            String htmlTitle = "<h3><img width='24' height='24' src='?resource=threads.png' alt='" + title + "'/>&nbsp;" + title + " (" + CollectorServlet.getHostAndPort(url) + ")</h3>";
            writer.write(htmlTitle);
            writer.flush();
            URL processesUrl = new URL(url.toString() + '&' + "part" + '=' + "processes");
            List processes = (List)new LabradorRetriever(processesUrl).call();
            new HtmlProcessInformationsReport(processes, writer).writeTable();
        }
        htmlReport.writeHtmlFooter();
        writer.close();
    }

    private void doDatabase(HttpServletRequest req, HttpServletResponse resp, String application) throws IOException, ClassNotFoundException {
        int requestIndex = req.getParameter("request") != null ? Integer.parseInt(req.getParameter("request")) : 0;
        PrintWriter writer = CollectorServlet.createWriterFromOutputStream(resp);
        HtmlReport htmlReport = this.createHtmlReport(req, writer, application);
        URL url = CollectorServlet.getUrlsByApplication(application).get(0);
        URL processesUrl = new URL(url.toString() + '&' + "part" + '=' + "database" + '&' + "request" + '=' + requestIndex);
        DatabaseInformations databaseInformations = (DatabaseInformations)new LabradorRetriever(processesUrl).call();
        htmlReport.writeDatabase(databaseInformations);
        writer.close();
    }

    private HtmlReport createHtmlReport(HttpServletRequest req, PrintWriter writer, String application) {
        Period period = MonitoringController.getPeriod(req);
        Collector collector = this.getCollectorByApplication(application);
        List<JavaInformations> javaInformationsList = this.getJavaInformationsByApplication(application);
        return new HtmlReport(collector, true, javaInformationsList, period, writer);
    }

    private static String getHostAndPort(URL url) {
        if (url.getPort() != -1) {
            return url.getHost() + ':' + url.getPort();
        }
        return url.getHost();
    }

    private void writeMessage(HttpServletRequest req, HttpServletResponse resp, String application, String message) throws IOException {
        PrintWriter writer;
        MonitoringController.noCache(resp);
        Collector collector = this.getCollectorByApplication(application);
        List<JavaInformations> javaInformationsList = this.getJavaInformationsByApplication(application);
        try {
            writer = resp.getWriter();
        }
        catch (Exception e) {
            writer = CollectorServlet.createWriterFromOutputStream(resp);
        }
        if (application == null) {
            CollectorServlet.showAlertAndRedirectTo(resp, message, "?");
        } else {
            Period period = MonitoringController.getPeriod(req);
            new HtmlReport(collector, true, javaInformationsList, period, writer).writeMessageIfNotNull(message, null);
        }
        writer.close();
    }

    private Collector getCollectorByApplication(String application) {
        return this.collectorServer.getCollectorByApplication(application);
    }

    private List<JavaInformations> getJavaInformationsByApplication(String application) {
        return this.collectorServer.getJavaInformationsByApplication(application);
    }

    private static PrintWriter createWriterFromOutputStream(HttpServletResponse httpResponse) throws IOException {
        MonitoringController.noCache(httpResponse);
        httpResponse.setContentType("text/html; charset=ISO-8859-1");
        return new PrintWriter(new OutputStreamWriter((OutputStream)httpResponse.getOutputStream(), "ISO-8859-1"));
    }

    private static void writeOnlyAddApplication(HttpServletResponse resp) throws IOException {
        MonitoringController.noCache(resp);
        resp.setContentType("text/html; charset=ISO-8859-1");
        PrintWriter writer = resp.getWriter();
        writer.write("<html><head><title>Monitoring</title></head><body>");
        HtmlReport.writeAddAndRemoveApplicationLinks(null, Period.JOUR, writer);
        writer.write("</body></html>");
    }

    private static void showAlertAndRedirectTo(HttpServletResponse resp, String message, String redirectTo) throws IOException {
        resp.setContentType("text/html; charset=ISO-8859-1");
        PrintWriter writer = resp.getWriter();
        writer.write("<script type='text/javascript'>alert('");
        writer.write(I18N.javascriptEncode(message));
        writer.write("');location.href='");
        writer.write(redirectTo);
        writer.write("';</script>");
    }

    private boolean isAddressAllowed(HttpServletRequest req) {
        return this.allowedAddrPattern != null && !this.allowedAddrPattern.matcher(req.getRemoteAddr()).matches();
    }

    private void forwardActionAndUpdateData(HttpServletRequest req, String application) throws IOException {
        String actionParameter = req.getParameter("action");
        String sessionIdParameter = req.getParameter("sessionId");
        List<URL> urls = CollectorServlet.getUrlsByApplication(application);
        ArrayList<URL> actionUrls = new ArrayList<URL>(urls.size());
        for (URL url : urls) {
            String tmp = url.toString() + "&action=" + actionParameter;
            String actionUrl = sessionIdParameter == null ? tmp : tmp + "&sessionId=" + sessionIdParameter;
            actionUrls.add(new URL(actionUrl));
        }
        try {
            this.collectorServer.collectForApplication(application, actionUrls);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private String getApplication(HttpServletRequest req, HttpServletResponse resp) {
        String application = req.getParameter("application");
        if (application == null) {
            Cookie[] cookies = req.getCookies();
            if (cookies != null) {
                for (Cookie cookie : Arrays.asList(cookies)) {
                    if (!COOKIE_NAME.equals(cookie.getName())) continue;
                    application = cookie.getValue();
                    if (this.collectorServer.isApplicationDataAvailable(application)) break;
                    cookie.setMaxAge(-1);
                    resp.addCookie(cookie);
                    application = null;
                    break;
                }
            }
            if (application == null) {
                application = this.collectorServer.getFirstApplication();
            }
        } else if (this.collectorServer.isApplicationDataAvailable(application)) {
            Cookie cookie = new Cookie(COOKIE_NAME, String.valueOf(application));
            cookie.setMaxAge(2592000);
            resp.addCookie(cookie);
        }
        return application;
    }

    private static List<URL> getUrlsByApplication(String application) throws IOException {
        assert (application != null);
        return Parameters.getCollectorUrlsByApplications().get(application);
    }

    public void destroy() {
        LOGGER.info((Object)"servlet de collecte en phase d'arr\u00eat");
        if (this.collectorServer != null) {
            this.collectorServer.stop();
        }
        Collector.stopJRobin();
        LOGGER.info((Object)"servlet de collecte arr\u00eat\u00e9e");
        super.destroy();
    }
}

