/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.bull.javamelody.Counter;
import net.bull.javamelody.Parameters;

class CounterStorage {
    private final Counter counter;

    CounterStorage(Counter counter) {
        assert (counter != null);
        this.counter = counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeToFile() throws IOException {
        File file = new File(Parameters.getStorageDirectory(this.counter.getApplication()), this.counter.getStorageName() + ".ser.gz");
        if (this.counter.getRequestsCount() == 0 && this.counter.getErrorsCount() == 0 && !file.exists()) {
            return;
        }
        File directory = file.getParentFile();
        if (!directory.mkdirs() && !directory.exists()) {
            throw new IOException("JavaMelody directory can't be created: " + directory.getPath());
        }
        FileOutputStream out = new FileOutputStream(file);
        try {
            ObjectOutputStream output = new ObjectOutputStream(new GZIPOutputStream(new BufferedOutputStream(out)));
            try {
                output.writeObject(this.counter);
            }
            finally {
                output.close();
            }
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Counter readFromFile() throws IOException {
        File file = new File(Parameters.getStorageDirectory(this.counter.getApplication()), this.counter.getStorageName() + ".ser.gz");
        if (file.exists()) {
            FileInputStream in = new FileInputStream(file);
            try {
                Counter counter;
                ObjectInputStream input = new ObjectInputStream(new GZIPInputStream(new BufferedInputStream(in)));
                try {
                    counter = (Counter)input.readObject();
                }
                catch (Throwable throwable) {
                    try {
                        input.close();
                        throw throwable;
                    }
                    catch (ClassNotFoundException e) {
                        throw CounterStorage.createIOException(e);
                    }
                }
                input.close();
                return counter;
            }
            finally {
                in.close();
            }
        }
        return null;
    }

    private static IOException createIOException(Exception e) {
        IOException ex = new IOException(e.getMessage());
        ex.initCause(e);
        return ex;
    }
}

